/**
 * UserTokenInfo.java
 *
 * This file was auto-generated from WSDL
 * by the Apache Axis 1.4 Apr 22, 2006 (06:55:48 PDT) WSDL2Java emitter.
 */

package com.good.adapters.entrust.stubs;


/**
 * Defines the information returned about a user token.
 */
public class UserTokenInfo  implements java.io.Serializable {
    /* The user ID that owns the token. */
    private String userid;

    /* The user name of the user ID  that owns the token. */
    private String userName;

    /* The group of the user ID that owns the token. */
    private String group;

    /* This value will contain the name of the token
     *                                 vendor if it is defined.  Otherwise
     * it will
     *                                 contain the vendor id of the token. */
    private String vendorId;

    /* The serial number of the token. */
    private String serialNumber;

    /* The set of the token. */
    private String tokenSet;

    /* The state of the token. */
    private State state;

    /* The type of the token. */
    private String tokenType;

    /* Flag indicating if this token supports
     *                                 token response-only authentication. */
    private boolean responseSupported;

    /* Flag indicating if this token supports
     *                                 token challenge/response authentication. */
    private boolean challengeSupported;

    /* Flag indicating if this token supports
     *                                 the unlock operation. */
    private boolean unlockSupported;

    /* Flag indicating if this token supports
     *                                 the data signature operation. */
    private boolean signatureSupported;

    /* Flag indicating if this token supports
     *                                 token delivery and data signature
     * operation
     *                                 where Entrust IdentityGuard will deliver
     * transaction details directly to the token where
     *                                 they will be used as input to the
     * token
     *                                 response calculation. */
    private boolean deliveryAndSignatureSupported;

    /* The load date of the token. If this is a soft
     *                                 token that was created for a user,
     * this is the
     *                                 date at which the token was created. */
    private java.util.Calendar loadDate;

    /* Flag indicating if this is a soft token that was
     *                                 created and immediately assigned to
     * a user
     *                                 using userTokenCreate. Such tokens
     * cannot be
     *                                 unassigned using userTokenUnassign. */
    private boolean createdForUser;

    /* Flag indicating if this is a soft token that
     *                                 uses up a license in the system. */
    private boolean usesLicense;

    /* The activation state of the token. One of
     *                                 CREATED, ACTIVATION_CODE_GENERATED,
     * or
     *                                 ACTIVATED. CREATED means the token
     * has been
     *                                 created using userTokenCreate.
     *                                 ACTIVATION_CODE_GENERATED means activation
     * codes
     *                                 have been generated using userTokenActivate.
     * ACTIVATED means the token has been activated
     *                                 using userTokenActivateComplete, or
     * the token
     *                                 did not require any activation process.
     * Only
     *                                 tokens in the ACTIVATED state may
     * be used for
     *                                 authentication. */
    private String activationState;

    /* Value specifying what kind of activation
     *                                 is current configured for this token. */
    private TokenActivationType currentActivationType;

    /* Value specifying what kind of activation
     *                                 types are available for this token. */
    private TokenActivationType[] availableActivationTypes;

    /* The last used date of the token. A value of
     *                                 Date(0) indicates that the token has
     * never
     *                                 been used. */
    private java.util.Calendar lastUsedDate;

    /* A list of token specific parameters.
     *                                 For example, for soft tokens, these
     * parameters
     *                                 might include information about the
     * device
     *                                 on which this token was loaded. */
    private NameValue[] tokenParameters;

    /* If this token has been registered
     *                                 with the Entrust IdentityGuard Mobile
     * OTP application, this value
     *                                 will show the platform type of the
     * mobile application. */
    private String mobilePlatform;

    /* If this token has been registered
     *                                 with the Entrust IdentityGuard Mobile
     * OTP application, this value
     *                                 will show the version of the
     *                                 mobile application. */
    private String mobileVersion;

    /* When this structure is returned by an admin
     *                                 service operation, this is the list
     * of the
     *                                 names of the roles that granted access
     * to this
     *                                 structure. */
    private String[] rolesGrantingAccess;

    /* The token comment. */
    private String comment;

    public UserTokenInfo() {
    }

    public UserTokenInfo(
           String userid,
           String userName,
           String group,
           String vendorId,
           String serialNumber,
           String tokenSet,
           State state,
           String tokenType,
           boolean responseSupported,
           boolean challengeSupported,
           boolean unlockSupported,
           boolean signatureSupported,
           boolean deliveryAndSignatureSupported,
           java.util.Calendar loadDate,
           boolean createdForUser,
           boolean usesLicense,
           String activationState,
           TokenActivationType currentActivationType,
           TokenActivationType[] availableActivationTypes,
           java.util.Calendar lastUsedDate,
           NameValue[] tokenParameters,
           String mobilePlatform,
           String mobileVersion,
           String[] rolesGrantingAccess,
           String comment) {
           this.userid = userid;
           this.userName = userName;
           this.group = group;
           this.vendorId = vendorId;
           this.serialNumber = serialNumber;
           this.tokenSet = tokenSet;
           this.state = state;
           this.tokenType = tokenType;
           this.responseSupported = responseSupported;
           this.challengeSupported = challengeSupported;
           this.unlockSupported = unlockSupported;
           this.signatureSupported = signatureSupported;
           this.deliveryAndSignatureSupported = deliveryAndSignatureSupported;
           this.loadDate = loadDate;
           this.createdForUser = createdForUser;
           this.usesLicense = usesLicense;
           this.activationState = activationState;
           this.currentActivationType = currentActivationType;
           this.availableActivationTypes = availableActivationTypes;
           this.lastUsedDate = lastUsedDate;
           this.tokenParameters = tokenParameters;
           this.mobilePlatform = mobilePlatform;
           this.mobileVersion = mobileVersion;
           this.rolesGrantingAccess = rolesGrantingAccess;
           this.comment = comment;
    }


    /**
     * Gets the userid value for this UserTokenInfo.
     * 
     * @return userid   * The user ID that owns the token.
     */
    public String getUserid() {
        return userid;
    }


    /**
     * Sets the userid value for this UserTokenInfo.
     * 
     * @param userid   * The user ID that owns the token.
     */
    public void setUserid(String userid) {
        this.userid = userid;
    }


    /**
     * Gets the userName value for this UserTokenInfo.
     * 
     * @return userName   * The user name of the user ID  that owns the token.
     */
    public String getUserName() {
        return userName;
    }


    /**
     * Sets the userName value for this UserTokenInfo.
     * 
     * @param userName   * The user name of the user ID  that owns the token.
     */
    public void setUserName(String userName) {
        this.userName = userName;
    }


    /**
     * Gets the group value for this UserTokenInfo.
     * 
     * @return group   * The group of the user ID that owns the token.
     */
    public String getGroup() {
        return group;
    }


    /**
     * Sets the group value for this UserTokenInfo.
     * 
     * @param group   * The group of the user ID that owns the token.
     */
    public void setGroup(String group) {
        this.group = group;
    }


    /**
     * Gets the vendorId value for this UserTokenInfo.
     * 
     * @return vendorId   * This value will contain the name of the token
     *                                 vendor if it is defined.  Otherwise
     * it will
     *                                 contain the vendor id of the token.
     */
    public String getVendorId() {
        return vendorId;
    }


    /**
     * Sets the vendorId value for this UserTokenInfo.
     * 
     * @param vendorId   * This value will contain the name of the token
     *                                 vendor if it is defined.  Otherwise
     * it will
     *                                 contain the vendor id of the token.
     */
    public void setVendorId(String vendorId) {
        this.vendorId = vendorId;
    }


    /**
     * Gets the serialNumber value for this UserTokenInfo.
     * 
     * @return serialNumber   * The serial number of the token.
     */
    public String getSerialNumber() {
        return serialNumber;
    }


    /**
     * Sets the serialNumber value for this UserTokenInfo.
     * 
     * @param serialNumber   * The serial number of the token.
     */
    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }


    /**
     * Gets the tokenSet value for this UserTokenInfo.
     * 
     * @return tokenSet   * The set of the token.
     */
    public String getTokenSet() {
        return tokenSet;
    }


    /**
     * Sets the tokenSet value for this UserTokenInfo.
     * 
     * @param tokenSet   * The set of the token.
     */
    public void setTokenSet(String tokenSet) {
        this.tokenSet = tokenSet;
    }


    /**
     * Gets the state value for this UserTokenInfo.
     * 
     * @return state   * The state of the token.
     */
    public State getState() {
        return state;
    }


    /**
     * Sets the state value for this UserTokenInfo.
     * 
     * @param state   * The state of the token.
     */
    public void setState(State state) {
        this.state = state;
    }


    /**
     * Gets the tokenType value for this UserTokenInfo.
     * 
     * @return tokenType   * The type of the token.
     */
    public String getTokenType() {
        return tokenType;
    }


    /**
     * Sets the tokenType value for this UserTokenInfo.
     * 
     * @param tokenType   * The type of the token.
     */
    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }


    /**
     * Gets the responseSupported value for this UserTokenInfo.
     * 
     * @return responseSupported   * Flag indicating if this token supports
     *                                 token response-only authentication.
     */
    public boolean isResponseSupported() {
        return responseSupported;
    }


    /**
     * Sets the responseSupported value for this UserTokenInfo.
     * 
     * @param responseSupported   * Flag indicating if this token supports
     *                                 token response-only authentication.
     */
    public void setResponseSupported(boolean responseSupported) {
        this.responseSupported = responseSupported;
    }


    /**
     * Gets the challengeSupported value for this UserTokenInfo.
     * 
     * @return challengeSupported   * Flag indicating if this token supports
     *                                 token challenge/response authentication.
     */
    public boolean isChallengeSupported() {
        return challengeSupported;
    }


    /**
     * Sets the challengeSupported value for this UserTokenInfo.
     * 
     * @param challengeSupported   * Flag indicating if this token supports
     *                                 token challenge/response authentication.
     */
    public void setChallengeSupported(boolean challengeSupported) {
        this.challengeSupported = challengeSupported;
    }


    /**
     * Gets the unlockSupported value for this UserTokenInfo.
     * 
     * @return unlockSupported   * Flag indicating if this token supports
     *                                 the unlock operation.
     */
    public boolean isUnlockSupported() {
        return unlockSupported;
    }


    /**
     * Sets the unlockSupported value for this UserTokenInfo.
     * 
     * @param unlockSupported   * Flag indicating if this token supports
     *                                 the unlock operation.
     */
    public void setUnlockSupported(boolean unlockSupported) {
        this.unlockSupported = unlockSupported;
    }


    /**
     * Gets the signatureSupported value for this UserTokenInfo.
     * 
     * @return signatureSupported   * Flag indicating if this token supports
     *                                 the data signature operation.
     */
    public boolean isSignatureSupported() {
        return signatureSupported;
    }


    /**
     * Sets the signatureSupported value for this UserTokenInfo.
     * 
     * @param signatureSupported   * Flag indicating if this token supports
     *                                 the data signature operation.
     */
    public void setSignatureSupported(boolean signatureSupported) {
        this.signatureSupported = signatureSupported;
    }


    /**
     * Gets the deliveryAndSignatureSupported value for this UserTokenInfo.
     * 
     * @return deliveryAndSignatureSupported   * Flag indicating if this token supports
     *                                 token delivery and data signature
     * operation
     *                                 where Entrust IdentityGuard will deliver
     * transaction details directly to the token where
     *                                 they will be used as input to the
     * token
     *                                 response calculation.
     */
    public boolean isDeliveryAndSignatureSupported() {
        return deliveryAndSignatureSupported;
    }


    /**
     * Sets the deliveryAndSignatureSupported value for this UserTokenInfo.
     * 
     * @param deliveryAndSignatureSupported   * Flag indicating if this token supports
     *                                 token delivery and data signature
     * operation
     *                                 where Entrust IdentityGuard will deliver
     * transaction details directly to the token where
     *                                 they will be used as input to the
     * token
     *                                 response calculation.
     */
    public void setDeliveryAndSignatureSupported(boolean deliveryAndSignatureSupported) {
        this.deliveryAndSignatureSupported = deliveryAndSignatureSupported;
    }


    /**
     * Gets the loadDate value for this UserTokenInfo.
     * 
     * @return loadDate   * The load date of the token. If this is a soft
     *                                 token that was created for a user,
     * this is the
     *                                 date at which the token was created.
     */
    public java.util.Calendar getLoadDate() {
        return loadDate;
    }


    /**
     * Sets the loadDate value for this UserTokenInfo.
     * 
     * @param loadDate   * The load date of the token. If this is a soft
     *                                 token that was created for a user,
     * this is the
     *                                 date at which the token was created.
     */
    public void setLoadDate(java.util.Calendar loadDate) {
        this.loadDate = loadDate;
    }


    /**
     * Gets the createdForUser value for this UserTokenInfo.
     * 
     * @return createdForUser   * Flag indicating if this is a soft token that was
     *                                 created and immediately assigned to
     * a user
     *                                 using userTokenCreate. Such tokens
     * cannot be
     *                                 unassigned using userTokenUnassign.
     */
    public boolean isCreatedForUser() {
        return createdForUser;
    }


    /**
     * Sets the createdForUser value for this UserTokenInfo.
     * 
     * @param createdForUser   * Flag indicating if this is a soft token that was
     *                                 created and immediately assigned to
     * a user
     *                                 using userTokenCreate. Such tokens
     * cannot be
     *                                 unassigned using userTokenUnassign.
     */
    public void setCreatedForUser(boolean createdForUser) {
        this.createdForUser = createdForUser;
    }


    /**
     * Gets the usesLicense value for this UserTokenInfo.
     * 
     * @return usesLicense   * Flag indicating if this is a soft token that
     *                                 uses up a license in the system.
     */
    public boolean isUsesLicense() {
        return usesLicense;
    }


    /**
     * Sets the usesLicense value for this UserTokenInfo.
     * 
     * @param usesLicense   * Flag indicating if this is a soft token that
     *                                 uses up a license in the system.
     */
    public void setUsesLicense(boolean usesLicense) {
        this.usesLicense = usesLicense;
    }


    /**
     * Gets the activationState value for this UserTokenInfo.
     * 
     * @return activationState   * The activation state of the token. One of
     *                                 CREATED, ACTIVATION_CODE_GENERATED,
     * or
     *                                 ACTIVATED. CREATED means the token
     * has been
     *                                 created using userTokenCreate.
     *                                 ACTIVATION_CODE_GENERATED means activation
     * codes
     *                                 have been generated using userTokenActivate.
     * ACTIVATED means the token has been activated
     *                                 using userTokenActivateComplete, or
     * the token
     *                                 did not require any activation process.
     * Only
     *                                 tokens in the ACTIVATED state may
     * be used for
     *                                 authentication.
     */
    public String getActivationState() {
        return activationState;
    }


    /**
     * Sets the activationState value for this UserTokenInfo.
     * 
     * @param activationState   * The activation state of the token. One of
     *                                 CREATED, ACTIVATION_CODE_GENERATED,
     * or
     *                                 ACTIVATED. CREATED means the token
     * has been
     *                                 created using userTokenCreate.
     *                                 ACTIVATION_CODE_GENERATED means activation
     * codes
     *                                 have been generated using userTokenActivate.
     * ACTIVATED means the token has been activated
     *                                 using userTokenActivateComplete, or
     * the token
     *                                 did not require any activation process.
     * Only
     *                                 tokens in the ACTIVATED state may
     * be used for
     *                                 authentication.
     */
    public void setActivationState(String activationState) {
        this.activationState = activationState;
    }


    /**
     * Gets the currentActivationType value for this UserTokenInfo.
     * 
     * @return currentActivationType   * Value specifying what kind of activation
     *                                 is current configured for this token.
     */
    public TokenActivationType getCurrentActivationType() {
        return currentActivationType;
    }


    /**
     * Sets the currentActivationType value for this UserTokenInfo.
     * 
     * @param currentActivationType   * Value specifying what kind of activation
     *                                 is current configured for this token.
     */
    public void setCurrentActivationType(TokenActivationType currentActivationType) {
        this.currentActivationType = currentActivationType;
    }


    /**
     * Gets the availableActivationTypes value for this UserTokenInfo.
     * 
     * @return availableActivationTypes   * Value specifying what kind of activation
     *                                 types are available for this token.
     */
    public TokenActivationType[] getAvailableActivationTypes() {
        return availableActivationTypes;
    }


    /**
     * Sets the availableActivationTypes value for this UserTokenInfo.
     * 
     * @param availableActivationTypes   * Value specifying what kind of activation
     *                                 types are available for this token.
     */
    public void setAvailableActivationTypes(TokenActivationType[] availableActivationTypes) {
        this.availableActivationTypes = availableActivationTypes;
    }


    /**
     * Gets the lastUsedDate value for this UserTokenInfo.
     * 
     * @return lastUsedDate   * The last used date of the token. A value of
     *                                 Date(0) indicates that the token has
     * never
     *                                 been used.
     */
    public java.util.Calendar getLastUsedDate() {
        return lastUsedDate;
    }


    /**
     * Sets the lastUsedDate value for this UserTokenInfo.
     * 
     * @param lastUsedDate   * The last used date of the token. A value of
     *                                 Date(0) indicates that the token has
     * never
     *                                 been used.
     */
    public void setLastUsedDate(java.util.Calendar lastUsedDate) {
        this.lastUsedDate = lastUsedDate;
    }


    /**
     * Gets the tokenParameters value for this UserTokenInfo.
     * 
     * @return tokenParameters   * A list of token specific parameters.
     *                                 For example, for soft tokens, these
     * parameters
     *                                 might include information about the
     * device
     *                                 on which this token was loaded.
     */
    public NameValue[] getTokenParameters() {
        return tokenParameters;
    }


    /**
     * Sets the tokenParameters value for this UserTokenInfo.
     * 
     * @param tokenParameters   * A list of token specific parameters.
     *                                 For example, for soft tokens, these
     * parameters
     *                                 might include information about the
     * device
     *                                 on which this token was loaded.
     */
    public void setTokenParameters(NameValue[] tokenParameters) {
        this.tokenParameters = tokenParameters;
    }


    /**
     * Gets the mobilePlatform value for this UserTokenInfo.
     * 
     * @return mobilePlatform   * If this token has been registered
     *                                 with the Entrust IdentityGuard Mobile
     * OTP application, this value
     *                                 will show the platform type of the
     * mobile application.
     */
    public String getMobilePlatform() {
        return mobilePlatform;
    }


    /**
     * Sets the mobilePlatform value for this UserTokenInfo.
     * 
     * @param mobilePlatform   * If this token has been registered
     *                                 with the Entrust IdentityGuard Mobile
     * OTP application, this value
     *                                 will show the platform type of the
     * mobile application.
     */
    public void setMobilePlatform(String mobilePlatform) {
        this.mobilePlatform = mobilePlatform;
    }


    /**
     * Gets the mobileVersion value for this UserTokenInfo.
     * 
     * @return mobileVersion   * If this token has been registered
     *                                 with the Entrust IdentityGuard Mobile
     * OTP application, this value
     *                                 will show the version of the
     *                                 mobile application.
     */
    public String getMobileVersion() {
        return mobileVersion;
    }


    /**
     * Sets the mobileVersion value for this UserTokenInfo.
     * 
     * @param mobileVersion   * If this token has been registered
     *                                 with the Entrust IdentityGuard Mobile
     * OTP application, this value
     *                                 will show the version of the
     *                                 mobile application.
     */
    public void setMobileVersion(String mobileVersion) {
        this.mobileVersion = mobileVersion;
    }


    /**
     * Gets the rolesGrantingAccess value for this UserTokenInfo.
     * 
     * @return rolesGrantingAccess   * When this structure is returned by an admin
     *                                 service operation, this is the list
     * of the
     *                                 names of the roles that granted access
     * to this
     *                                 structure.
     */
    public String[] getRolesGrantingAccess() {
        return rolesGrantingAccess;
    }


    /**
     * Sets the rolesGrantingAccess value for this UserTokenInfo.
     * 
     * @param rolesGrantingAccess   * When this structure is returned by an admin
     *                                 service operation, this is the list
     * of the
     *                                 names of the roles that granted access
     * to this
     *                                 structure.
     */
    public void setRolesGrantingAccess(String[] rolesGrantingAccess) {
        this.rolesGrantingAccess = rolesGrantingAccess;
    }


    /**
     * Gets the comment value for this UserTokenInfo.
     * 
     * @return comment   * The token comment.
     */
    public String getComment() {
        return comment;
    }


    /**
     * Sets the comment value for this UserTokenInfo.
     * 
     * @param comment   * The token comment.
     */
    public void setComment(String comment) {
        this.comment = comment;
    }

    private Object __equalsCalc = null;
    public synchronized boolean equals(Object obj) {
        if (!(obj instanceof UserTokenInfo)) return false;
        UserTokenInfo other = (UserTokenInfo) obj;
        if (obj == null) return false;
        if (this == obj) return true;
        if (__equalsCalc != null) {
            return (__equalsCalc == obj);
        }
        __equalsCalc = obj;
        boolean _equals;
        _equals = true && 
            ((this.userid==null && other.getUserid()==null) || 
             (this.userid!=null &&
              this.userid.equals(other.getUserid()))) &&
            ((this.userName==null && other.getUserName()==null) || 
             (this.userName!=null &&
              this.userName.equals(other.getUserName()))) &&
            ((this.group==null && other.getGroup()==null) || 
             (this.group!=null &&
              this.group.equals(other.getGroup()))) &&
            ((this.vendorId==null && other.getVendorId()==null) || 
             (this.vendorId!=null &&
              this.vendorId.equals(other.getVendorId()))) &&
            ((this.serialNumber==null && other.getSerialNumber()==null) || 
             (this.serialNumber!=null &&
              this.serialNumber.equals(other.getSerialNumber()))) &&
            ((this.tokenSet==null && other.getTokenSet()==null) || 
             (this.tokenSet!=null &&
              this.tokenSet.equals(other.getTokenSet()))) &&
            ((this.state==null && other.getState()==null) || 
             (this.state!=null &&
              this.state.equals(other.getState()))) &&
            ((this.tokenType==null && other.getTokenType()==null) || 
             (this.tokenType!=null &&
              this.tokenType.equals(other.getTokenType()))) &&
            this.responseSupported == other.isResponseSupported() &&
            this.challengeSupported == other.isChallengeSupported() &&
            this.unlockSupported == other.isUnlockSupported() &&
            this.signatureSupported == other.isSignatureSupported() &&
            this.deliveryAndSignatureSupported == other.isDeliveryAndSignatureSupported() &&
            ((this.loadDate==null && other.getLoadDate()==null) || 
             (this.loadDate!=null &&
              this.loadDate.equals(other.getLoadDate()))) &&
            this.createdForUser == other.isCreatedForUser() &&
            this.usesLicense == other.isUsesLicense() &&
            ((this.activationState==null && other.getActivationState()==null) || 
             (this.activationState!=null &&
              this.activationState.equals(other.getActivationState()))) &&
            ((this.currentActivationType==null && other.getCurrentActivationType()==null) || 
             (this.currentActivationType!=null &&
              this.currentActivationType.equals(other.getCurrentActivationType()))) &&
            ((this.availableActivationTypes==null && other.getAvailableActivationTypes()==null) || 
             (this.availableActivationTypes!=null &&
              java.util.Arrays.equals(this.availableActivationTypes, other.getAvailableActivationTypes()))) &&
            ((this.lastUsedDate==null && other.getLastUsedDate()==null) || 
             (this.lastUsedDate!=null &&
              this.lastUsedDate.equals(other.getLastUsedDate()))) &&
            ((this.tokenParameters==null && other.getTokenParameters()==null) || 
             (this.tokenParameters!=null &&
              java.util.Arrays.equals(this.tokenParameters, other.getTokenParameters()))) &&
            ((this.mobilePlatform==null && other.getMobilePlatform()==null) || 
             (this.mobilePlatform!=null &&
              this.mobilePlatform.equals(other.getMobilePlatform()))) &&
            ((this.mobileVersion==null && other.getMobileVersion()==null) || 
             (this.mobileVersion!=null &&
              this.mobileVersion.equals(other.getMobileVersion()))) &&
            ((this.rolesGrantingAccess==null && other.getRolesGrantingAccess()==null) || 
             (this.rolesGrantingAccess!=null &&
              java.util.Arrays.equals(this.rolesGrantingAccess, other.getRolesGrantingAccess()))) &&
            ((this.comment==null && other.getComment()==null) || 
             (this.comment!=null &&
              this.comment.equals(other.getComment())));
        __equalsCalc = null;
        return _equals;
    }

    private boolean __hashCodeCalc = false;
    public synchronized int hashCode() {
        if (__hashCodeCalc) {
            return 0;
        }
        __hashCodeCalc = true;
        int _hashCode = 1;
        if (getUserid() != null) {
            _hashCode += getUserid().hashCode();
        }
        if (getUserName() != null) {
            _hashCode += getUserName().hashCode();
        }
        if (getGroup() != null) {
            _hashCode += getGroup().hashCode();
        }
        if (getVendorId() != null) {
            _hashCode += getVendorId().hashCode();
        }
        if (getSerialNumber() != null) {
            _hashCode += getSerialNumber().hashCode();
        }
        if (getTokenSet() != null) {
            _hashCode += getTokenSet().hashCode();
        }
        if (getState() != null) {
            _hashCode += getState().hashCode();
        }
        if (getTokenType() != null) {
            _hashCode += getTokenType().hashCode();
        }
        _hashCode += (isResponseSupported() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        _hashCode += (isChallengeSupported() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        _hashCode += (isUnlockSupported() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        _hashCode += (isSignatureSupported() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        _hashCode += (isDeliveryAndSignatureSupported() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        if (getLoadDate() != null) {
            _hashCode += getLoadDate().hashCode();
        }
        _hashCode += (isCreatedForUser() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        _hashCode += (isUsesLicense() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        if (getActivationState() != null) {
            _hashCode += getActivationState().hashCode();
        }
        if (getCurrentActivationType() != null) {
            _hashCode += getCurrentActivationType().hashCode();
        }
        if (getAvailableActivationTypes() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getAvailableActivationTypes());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getAvailableActivationTypes(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getLastUsedDate() != null) {
            _hashCode += getLastUsedDate().hashCode();
        }
        if (getTokenParameters() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getTokenParameters());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getTokenParameters(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getMobilePlatform() != null) {
            _hashCode += getMobilePlatform().hashCode();
        }
        if (getMobileVersion() != null) {
            _hashCode += getMobileVersion().hashCode();
        }
        if (getRolesGrantingAccess() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getRolesGrantingAccess());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getRolesGrantingAccess(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getComment() != null) {
            _hashCode += getComment().hashCode();
        }
        __hashCodeCalc = false;
        return _hashCode;
    }

    // Type metadata
    private static org.apache.axis.description.TypeDesc typeDesc =
        new org.apache.axis.description.TypeDesc(UserTokenInfo.class, true);

    static {
        typeDesc.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "UserTokenInfo"));
        org.apache.axis.description.ElementDesc elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("userid");
        elemField.setXmlName(new javax.xml.namespace.QName("", "Userid"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("userName");
        elemField.setXmlName(new javax.xml.namespace.QName("", "UserName"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("group");
        elemField.setXmlName(new javax.xml.namespace.QName("", "Group"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("vendorId");
        elemField.setXmlName(new javax.xml.namespace.QName("", "VendorId"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("serialNumber");
        elemField.setXmlName(new javax.xml.namespace.QName("", "SerialNumber"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("tokenSet");
        elemField.setXmlName(new javax.xml.namespace.QName("", "TokenSet"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("state");
        elemField.setXmlName(new javax.xml.namespace.QName("", "State"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "State"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("tokenType");
        elemField.setXmlName(new javax.xml.namespace.QName("", "TokenType"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("responseSupported");
        elemField.setXmlName(new javax.xml.namespace.QName("", "ResponseSupported"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("challengeSupported");
        elemField.setXmlName(new javax.xml.namespace.QName("", "ChallengeSupported"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("unlockSupported");
        elemField.setXmlName(new javax.xml.namespace.QName("", "UnlockSupported"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("signatureSupported");
        elemField.setXmlName(new javax.xml.namespace.QName("", "SignatureSupported"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("deliveryAndSignatureSupported");
        elemField.setXmlName(new javax.xml.namespace.QName("", "DeliveryAndSignatureSupported"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("loadDate");
        elemField.setXmlName(new javax.xml.namespace.QName("", "LoadDate"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "dateTime"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("createdForUser");
        elemField.setXmlName(new javax.xml.namespace.QName("", "CreatedForUser"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("usesLicense");
        elemField.setXmlName(new javax.xml.namespace.QName("", "UsesLicense"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("activationState");
        elemField.setXmlName(new javax.xml.namespace.QName("", "ActivationState"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("currentActivationType");
        elemField.setXmlName(new javax.xml.namespace.QName("", "CurrentActivationType"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "TokenActivationType"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("availableActivationTypes");
        elemField.setXmlName(new javax.xml.namespace.QName("", "AvailableActivationTypes"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "TokenActivationType"));
        elemField.setNillable(false);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("lastUsedDate");
        elemField.setXmlName(new javax.xml.namespace.QName("", "LastUsedDate"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "dateTime"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("tokenParameters");
        elemField.setXmlName(new javax.xml.namespace.QName("", "tokenParameters"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:commonV9", "NameValue"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("mobilePlatform");
        elemField.setXmlName(new javax.xml.namespace.QName("", "MobilePlatform"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("mobileVersion");
        elemField.setXmlName(new javax.xml.namespace.QName("", "MobileVersion"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("rolesGrantingAccess");
        elemField.setXmlName(new javax.xml.namespace.QName("", "RolesGrantingAccess"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(false);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("comment");
        elemField.setXmlName(new javax.xml.namespace.QName("", "Comment"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
    }

    /**
     * Return type metadata object
     */
    public static org.apache.axis.description.TypeDesc getTypeDesc() {
        return typeDesc;
    }

    /**
     * Get Custom Serializer
     */
    public static org.apache.axis.encoding.Serializer getSerializer(
           String mechType,
           Class _javaType,
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanSerializer(
            _javaType, _xmlType, typeDesc);
    }

    /**
     * Get Custom Deserializer
     */
    public static org.apache.axis.encoding.Deserializer getDeserializer(
           String mechType,
           Class _javaType,
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanDeserializer(
            _javaType, _xmlType, typeDesc);
    }

}
