/**
 * UserDigitalIdParms.java
 *
 * This file was auto-generated from WSDL
 * by the Apache Axis 1.4 Apr 22, 2006 (06:55:48 PDT) WSDL2Java emitter.
 */

package com.good.adapters.entrust.stubs;


import java.util.Arrays;

/**
 * Defines parameters about a User Digital Id.
 */
public class UserDigitalIdParms  implements java.io.Serializable {
    /* The name of Digital Id Config to be used. */
    private String digitalIdConfig;

    /* The optional DN of the user's digital Id. If 
     *                                 this value is specified, it is used
     * as the DN 
     *                                 of the Digital Id. */
    private String DN;

    /* An optional list of variables that will be used 
     *                                 to generate the DN from the DNFormat
     * specified 
     *                                 in the Digital Id Config. When creating
     * a 
     *                                 Digital Id for a user smart credential,
     * the 
     *                                 smart credential enrollment values
     * will also be 
     *                                 used as variable values. Supported
     * only for 
     *                                 use with an Entrust CA. With a Microsoft
     * CA this
     *                                 setting is ignored (has no effect). */
    private NameValue[] DNVariables;

    /* List of SubjectAltName values to add to the
     *                                 digital Ids. Supported only for use
     * with an 
     *                                 Entrust CA. With a Microsoft CA this
     * setting is 
     *                                 ignored (has no effect). */
    private SubjectAltName[] subjectAltName;

    /* List of Managed CA variables to be set for this 
     *                                 digital identity. Supported only for
     * use with 
     *                                 an Entrust CA. With a Microsoft CA
     * this setting 
     *                                 is ignored (has no effect). */
    private ManagedCaVariable[] caVariables;

    /* The Managed CA Directory mode. Supported only 
     *                                 for use with an Entrust CA. With a
     * Microsoft CA 
     *                                 this setting is ignored (has no effect). */
    private ManagedCaDirectoryMode caDirectoryMode;

    /* A flag indicating if the operation should add a 
     *                                 new Digital Id if one does not exist.
     * The flag 
     *                                 defaults to the DigitalIdConfig value
     * for this 
     *                                 setting if not specified. Supported
     * only for 
     *                                 use with an Entrust CA. With a Microsoft
     * CA this
     *                                 setting is ignored (has no effect). */
    private Boolean createIfNotExists;

    /* A flag indicating if the operation should 
     *                                 recover an existing Digital Id.  The
     * flag
     *                                 defaults to the DigitalIdConfig value
     * for this 
     *                                 setting if not specified. Supported
     * only for 
     *                                 use with an Entrust CA. With a Microsoft
     * CA this
     *                                 setting is ignored (has no effect). */
    private Boolean recoverIfExists;

    /* When a PKCS#12 is being requested this flag 
     *                                 governs whether the full key history
     * should be 
     *                                 contained in the PKCS#12 or just the
     * most recent 
     *                                 key for each certificate stream. Supported
     * only 
     *                                 for use with an Entrust CA. With a
     * Microsoft CA, 
     *                                 this setting is ignored; the PKCS#12
     * produced 
     *                                 will always only contain the most
     * recent key for 
     *                                 each certificate stream. */
    private Boolean p12LatestKeyOnly;

    /* If specified, a digital Id security store is 
     *                                 created with the given type.
     *                                 An error is returned if both a SecurityStoreType
     * and P10 Requests are specified. Supported for
     *                                 both Entrust and Microsoft CAs. However,
     * the
     *                                 EPF security store type is only supported
     * for
     *                                 use with an Entrust CA. If the EPF
     * security
     *                                 store type is provided for a create/recover
     * operation against a Microsoft CA, and error will
     *                                 result. */
    private com.good.adapters.entrust.stubs.DigitalIdSecurityStoreType securityStoreType;

    /* If the SecurityStoreType is specified, the
     *                                 SecurityStorePassword argument specifies
     * the
     *                                 password for the security store. If
     * 
     *                                 SecurityStoreType is specified and
     * 
     *                                 SecurityStorePassword is not specified,
     * a random 
     *                                 password is generated. If SecurityStorePassword
     * 
     *                                 is specified and SecurityStoreType
     * is not 
     *                                 specified, the password is ignored.
     * Supported
     *                                 for both Entrust and Microsoft CAs. */
    private String securityStorePassword;

    /* If specified, certificates for the given P10 
     *                                 requests are generated against the
     * Digital Id 
     *                                 created or recovered with this request.
     * An error 
     *                                 is returned if both a SecurityStoreType
     * and 
     *                                 P10Requests are specified. */
    private DigitalIdP10Request[] p10Requests;

    /* Client Type for this Digital Id. */
    private String clientType;

    /* If specified, specifies the certificate
     *                                 lifetime in months.  Most be a positive
     * value. */
    private Integer certificateLifetime;

    /* If specified, specifies the certificate
     *                                 expiry date.  This value is ignored
     * if
     *                                 the CertificateLifetime is specified. */
    private java.util.Calendar certificateExpiryDate;

    /* Comments about this Digital Id. */
    private String comment;

    public UserDigitalIdParms() {
    }

    public UserDigitalIdParms(
           String digitalIdConfig,
           String DN,
           NameValue[] DNVariables,
           SubjectAltName[] subjectAltName,
           ManagedCaVariable[] caVariables,
           ManagedCaDirectoryMode caDirectoryMode,
           Boolean createIfNotExists,
           Boolean recoverIfExists,
           Boolean p12LatestKeyOnly,
           com.good.adapters.entrust.stubs.DigitalIdSecurityStoreType securityStoreType,
           String securityStorePassword,
           DigitalIdP10Request[] p10Requests,
           String clientType,
           Integer certificateLifetime,
           java.util.Calendar certificateExpiryDate,
           String comment) {
           this.digitalIdConfig = digitalIdConfig;
           this.DN = DN;
           this.DNVariables = DNVariables;
           this.subjectAltName = subjectAltName;
           this.caVariables = caVariables;
           this.caDirectoryMode = caDirectoryMode;
           this.createIfNotExists = createIfNotExists;
           this.recoverIfExists = recoverIfExists;
           this.p12LatestKeyOnly = p12LatestKeyOnly;
           this.securityStoreType = securityStoreType;
           this.securityStorePassword = securityStorePassword;
           this.p10Requests = p10Requests;
           this.clientType = clientType;
           this.certificateLifetime = certificateLifetime;
           this.certificateExpiryDate = certificateExpiryDate;
           this.comment = comment;
    }


    /**
     * Gets the digitalIdConfig value for this UserDigitalIdParms.
     * 
     * @return digitalIdConfig   * The name of Digital Id Config to be used.
     */
    public String getDigitalIdConfig() {
        return digitalIdConfig;
    }


    /**
     * Sets the digitalIdConfig value for this UserDigitalIdParms.
     * 
     * @param digitalIdConfig   * The name of Digital Id Config to be used.
     */
    public void setDigitalIdConfig(String digitalIdConfig) {
        this.digitalIdConfig = digitalIdConfig;
    }


    /**
     * Gets the DN value for this UserDigitalIdParms.
     * 
     * @return DN   * The optional DN of the user's digital Id. If 
     *                                 this value is specified, it is used
     * as the DN 
     *                                 of the Digital Id.
     */
    public String getDN() {
        return DN;
    }


    /**
     * Sets the DN value for this UserDigitalIdParms.
     * 
     * @param DN   * The optional DN of the user's digital Id. If 
     *                                 this value is specified, it is used
     * as the DN 
     *                                 of the Digital Id.
     */
    public void setDN(String DN) {
        this.DN = DN;
    }


    /**
     * Gets the DNVariables value for this UserDigitalIdParms.
     * 
     * @return DNVariables   * An optional list of variables that will be used 
     *                                 to generate the DN from the DNFormat
     * specified 
     *                                 in the Digital Id Config. When creating
     * a 
     *                                 Digital Id for a user smart credential,
     * the 
     *                                 smart credential enrollment values
     * will also be 
     *                                 used as variable values. Supported
     * only for 
     *                                 use with an Entrust CA. With a Microsoft
     * CA this
     *                                 setting is ignored (has no effect).
     */
    public NameValue[] getDNVariables() {
        return DNVariables;
    }


    /**
     * Sets the DNVariables value for this UserDigitalIdParms.
     * 
     * @param DNVariables   * An optional list of variables that will be used 
     *                                 to generate the DN from the DNFormat
     * specified 
     *                                 in the Digital Id Config. When creating
     * a 
     *                                 Digital Id for a user smart credential,
     * the 
     *                                 smart credential enrollment values
     * will also be 
     *                                 used as variable values. Supported
     * only for 
     *                                 use with an Entrust CA. With a Microsoft
     * CA this
     *                                 setting is ignored (has no effect).
     */
    public void setDNVariables(NameValue[] DNVariables) {
        this.DNVariables = DNVariables;
    }


    /**
     * Gets the subjectAltName value for this UserDigitalIdParms.
     * 
     * @return subjectAltName   * List of SubjectAltName values to add to the
     *                                 digital Ids. Supported only for use
     * with an 
     *                                 Entrust CA. With a Microsoft CA this
     * setting is 
     *                                 ignored (has no effect).
     */
    public SubjectAltName[] getSubjectAltName() {
        return subjectAltName;
    }


    /**
     * Sets the subjectAltName value for this UserDigitalIdParms.
     * 
     * @param subjectAltName   * List of SubjectAltName values to add to the
     *                                 digital Ids. Supported only for use
     * with an 
     *                                 Entrust CA. With a Microsoft CA this
     * setting is 
     *                                 ignored (has no effect).
     */
    public void setSubjectAltName(SubjectAltName[] subjectAltName) {
        this.subjectAltName = subjectAltName;
    }


    /**
     * Gets the caVariables value for this UserDigitalIdParms.
     * 
     * @return caVariables   * List of Managed CA variables to be set for this 
     *                                 digital identity. Supported only for
     * use with 
     *                                 an Entrust CA. With a Microsoft CA
     * this setting 
     *                                 is ignored (has no effect).
     */
    public ManagedCaVariable[] getCaVariables() {
        return caVariables;
    }


    /**
     * Sets the caVariables value for this UserDigitalIdParms.
     * 
     * @param caVariables   * List of Managed CA variables to be set for this 
     *                                 digital identity. Supported only for
     * use with 
     *                                 an Entrust CA. With a Microsoft CA
     * this setting 
     *                                 is ignored (has no effect).
     */
    public void setCaVariables(ManagedCaVariable[] caVariables) {
        this.caVariables = caVariables;
    }


    /**
     * Gets the caDirectoryMode value for this UserDigitalIdParms.
     * 
     * @return caDirectoryMode   * The Managed CA Directory mode. Supported only 
     *                                 for use with an Entrust CA. With a
     * Microsoft CA 
     *                                 this setting is ignored (has no effect).
     */
    public ManagedCaDirectoryMode getCaDirectoryMode() {
        return caDirectoryMode;
    }


    /**
     * Sets the caDirectoryMode value for this UserDigitalIdParms.
     * 
     * @param caDirectoryMode   * The Managed CA Directory mode. Supported only 
     *                                 for use with an Entrust CA. With a
     * Microsoft CA 
     *                                 this setting is ignored (has no effect).
     */
    public void setCaDirectoryMode(ManagedCaDirectoryMode caDirectoryMode) {
        this.caDirectoryMode = caDirectoryMode;
    }


    /**
     * Gets the createIfNotExists value for this UserDigitalIdParms.
     * 
     * @return createIfNotExists   * A flag indicating if the operation should add a 
     *                                 new Digital Id if one does not exist.
     * The flag 
     *                                 defaults to the DigitalIdConfig value
     * for this 
     *                                 setting if not specified. Supported
     * only for 
     *                                 use with an Entrust CA. With a Microsoft
     * CA this
     *                                 setting is ignored (has no effect).
     */
    public Boolean getCreateIfNotExists() {
        return createIfNotExists;
    }


    /**
     * Sets the createIfNotExists value for this UserDigitalIdParms.
     * 
     * @param createIfNotExists   * A flag indicating if the operation should add a 
     *                                 new Digital Id if one does not exist.
     * The flag 
     *                                 defaults to the DigitalIdConfig value
     * for this 
     *                                 setting if not specified. Supported
     * only for 
     *                                 use with an Entrust CA. With a Microsoft
     * CA this
     *                                 setting is ignored (has no effect).
     */
    public void setCreateIfNotExists(Boolean createIfNotExists) {
        this.createIfNotExists = createIfNotExists;
    }


    /**
     * Gets the recoverIfExists value for this UserDigitalIdParms.
     * 
     * @return recoverIfExists   * A flag indicating if the operation should 
     *                                 recover an existing Digital Id.  The
     * flag
     *                                 defaults to the DigitalIdConfig value
     * for this 
     *                                 setting if not specified. Supported
     * only for 
     *                                 use with an Entrust CA. With a Microsoft
     * CA this
     *                                 setting is ignored (has no effect).
     */
    public Boolean getRecoverIfExists() {
        return recoverIfExists;
    }


    /**
     * Sets the recoverIfExists value for this UserDigitalIdParms.
     * 
     * @param recoverIfExists   * A flag indicating if the operation should 
     *                                 recover an existing Digital Id.  The
     * flag
     *                                 defaults to the DigitalIdConfig value
     * for this 
     *                                 setting if not specified. Supported
     * only for 
     *                                 use with an Entrust CA. With a Microsoft
     * CA this
     *                                 setting is ignored (has no effect).
     */
    public void setRecoverIfExists(Boolean recoverIfExists) {
        this.recoverIfExists = recoverIfExists;
    }


    /**
     * Gets the p12LatestKeyOnly value for this UserDigitalIdParms.
     * 
     * @return p12LatestKeyOnly   * When a PKCS#12 is being requested this flag 
     *                                 governs whether the full key history
     * should be 
     *                                 contained in the PKCS#12 or just the
     * most recent 
     *                                 key for each certificate stream. Supported
     * only 
     *                                 for use with an Entrust CA. With a
     * Microsoft CA, 
     *                                 this setting is ignored; the PKCS#12
     * produced 
     *                                 will always only contain the most
     * recent key for 
     *                                 each certificate stream.
     */
    public Boolean getP12LatestKeyOnly() {
        return p12LatestKeyOnly;
    }


    /**
     * Sets the p12LatestKeyOnly value for this UserDigitalIdParms.
     * 
     * @param p12LatestKeyOnly   * When a PKCS#12 is being requested this flag 
     *                                 governs whether the full key history
     * should be 
     *                                 contained in the PKCS#12 or just the
     * most recent 
     *                                 key for each certificate stream. Supported
     * only 
     *                                 for use with an Entrust CA. With a
     * Microsoft CA, 
     *                                 this setting is ignored; the PKCS#12
     * produced 
     *                                 will always only contain the most
     * recent key for 
     *                                 each certificate stream.
     */
    public void setP12LatestKeyOnly(Boolean p12LatestKeyOnly) {
        this.p12LatestKeyOnly = p12LatestKeyOnly;
    }


    /**
     * Gets the securityStoreType value for this UserDigitalIdParms.
     * 
     * @return securityStoreType   * If specified, a digital Id security store is 
     *                                 created with the given type.
     *                                 An error is returned if both a SecurityStoreType
     * and P10 Requests are specified. Supported for
     *                                 both Entrust and Microsoft CAs. However,
     * the
     *                                 EPF security store type is only supported
     * for
     *                                 use with an Entrust CA. If the EPF
     * security
     *                                 store type is provided for a create/recover
     * operation against a Microsoft CA, and error will
     *                                 result.
     */
    public com.good.adapters.entrust.stubs.DigitalIdSecurityStoreType getSecurityStoreType() {
        return securityStoreType;
    }


    /**
     * Sets the securityStoreType value for this UserDigitalIdParms.
     * 
     * @param securityStoreType   * If specified, a digital Id security store is 
     *                                 created with the given type.
     *                                 An error is returned if both a SecurityStoreType
     * and P10 Requests are specified. Supported for
     *                                 both Entrust and Microsoft CAs. However,
     * the
     *                                 EPF security store type is only supported
     * for
     *                                 use with an Entrust CA. If the EPF
     * security
     *                                 store type is provided for a create/recover
     * operation against a Microsoft CA, and error will
     *                                 result.
     */
    public void setSecurityStoreType(com.good.adapters.entrust.stubs.DigitalIdSecurityStoreType securityStoreType) {
        this.securityStoreType = securityStoreType;
    }


    /**
     * Gets the securityStorePassword value for this UserDigitalIdParms.
     * 
     * @return securityStorePassword   * If the SecurityStoreType is specified, the
     *                                 SecurityStorePassword argument specifies
     * the
     *                                 password for the security store. If
     * 
     *                                 SecurityStoreType is specified and
     * 
     *                                 SecurityStorePassword is not specified,
     * a random 
     *                                 password is generated. If SecurityStorePassword
     * 
     *                                 is specified and SecurityStoreType
     * is not 
     *                                 specified, the password is ignored.
     * Supported
     *                                 for both Entrust and Microsoft CAs.
     */
    public String getSecurityStorePassword() {
        return securityStorePassword;
    }


    /**
     * Sets the securityStorePassword value for this UserDigitalIdParms.
     * 
     * @param securityStorePassword   * If the SecurityStoreType is specified, the
     *                                 SecurityStorePassword argument specifies
     * the
     *                                 password for the security store. If
     * 
     *                                 SecurityStoreType is specified and
     * 
     *                                 SecurityStorePassword is not specified,
     * a random 
     *                                 password is generated. If SecurityStorePassword
     * 
     *                                 is specified and SecurityStoreType
     * is not 
     *                                 specified, the password is ignored.
     * Supported
     *                                 for both Entrust and Microsoft CAs.
     */
    public void setSecurityStorePassword(String securityStorePassword) {
        this.securityStorePassword = securityStorePassword;
    }


    /**
     * Gets the p10Requests value for this UserDigitalIdParms.
     * 
     * @return p10Requests   * If specified, certificates for the given P10 
     *                                 requests are generated against the
     * Digital Id 
     *                                 created or recovered with this request.
     * An error 
     *                                 is returned if both a SecurityStoreType
     * and 
     *                                 P10Requests are specified.
     */
    public DigitalIdP10Request[] getP10Requests() {
        return p10Requests;
    }


    /**
     * Sets the p10Requests value for this UserDigitalIdParms.
     * 
     * @param p10Requests   * If specified, certificates for the given P10 
     *                                 requests are generated against the
     * Digital Id 
     *                                 created or recovered with this request.
     * An error 
     *                                 is returned if both a SecurityStoreType
     * and 
     *                                 P10Requests are specified.
     */
    public void setP10Requests(DigitalIdP10Request[] p10Requests) {
        this.p10Requests = p10Requests;
    }


    /**
     * Gets the clientType value for this UserDigitalIdParms.
     * 
     * @return clientType   * Client Type for this Digital Id.
     */
    public String getClientType() {
        return clientType;
    }


    /**
     * Sets the clientType value for this UserDigitalIdParms.
     * 
     * @param clientType   * Client Type for this Digital Id.
     */
    public void setClientType(String clientType) {
        this.clientType = clientType;
    }


    /**
     * Gets the certificateLifetime value for this UserDigitalIdParms.
     * 
     * @return certificateLifetime   * If specified, specifies the certificate
     *                                 lifetime in months.  Most be a positive
     * value.
     */
    public Integer getCertificateLifetime() {
        return certificateLifetime;
    }


    /**
     * Sets the certificateLifetime value for this UserDigitalIdParms.
     * 
     * @param certificateLifetime   * If specified, specifies the certificate
     *                                 lifetime in months.  Most be a positive
     * value.
     */
    public void setCertificateLifetime(Integer certificateLifetime) {
        this.certificateLifetime = certificateLifetime;
    }


    /**
     * Gets the certificateExpiryDate value for this UserDigitalIdParms.
     * 
     * @return certificateExpiryDate   * If specified, specifies the certificate
     *                                 expiry date.  This value is ignored
     * if
     *                                 the CertificateLifetime is specified.
     */
    public java.util.Calendar getCertificateExpiryDate() {
        return certificateExpiryDate;
    }


    /**
     * Sets the certificateExpiryDate value for this UserDigitalIdParms.
     * 
     * @param certificateExpiryDate   * If specified, specifies the certificate
     *                                 expiry date.  This value is ignored
     * if
     *                                 the CertificateLifetime is specified.
     */
    public void setCertificateExpiryDate(java.util.Calendar certificateExpiryDate) {
        this.certificateExpiryDate = certificateExpiryDate;
    }


    /**
     * Gets the comment value for this UserDigitalIdParms.
     * 
     * @return comment   * Comments about this Digital Id.
     */
    public String getComment() {
        return comment;
    }


    /**
     * Sets the comment value for this UserDigitalIdParms.
     * 
     * @param comment   * Comments about this Digital Id.
     */
    public void setComment(String comment) {
        this.comment = comment;
    }

    private Object __equalsCalc = null;
    public synchronized boolean equals(Object obj) {
        if (!(obj instanceof UserDigitalIdParms)) return false;
        UserDigitalIdParms other = (UserDigitalIdParms) obj;
        if (obj == null) return false;
        if (this == obj) return true;
        if (__equalsCalc != null) {
            return (__equalsCalc == obj);
        }
        __equalsCalc = obj;
        boolean _equals;
        _equals = true && 
            ((this.digitalIdConfig==null && other.getDigitalIdConfig()==null) || 
             (this.digitalIdConfig!=null &&
              this.digitalIdConfig.equals(other.getDigitalIdConfig()))) &&
            ((this.DN==null && other.getDN()==null) || 
             (this.DN!=null &&
              this.DN.equals(other.getDN()))) &&
            ((this.DNVariables==null && other.getDNVariables()==null) || 
             (this.DNVariables!=null &&
              java.util.Arrays.equals(this.DNVariables, other.getDNVariables()))) &&
            ((this.subjectAltName==null && other.getSubjectAltName()==null) || 
             (this.subjectAltName!=null &&
              java.util.Arrays.equals(this.subjectAltName, other.getSubjectAltName()))) &&
            ((this.caVariables==null && other.getCaVariables()==null) || 
             (this.caVariables!=null &&
              java.util.Arrays.equals(this.caVariables, other.getCaVariables()))) &&
            ((this.caDirectoryMode==null && other.getCaDirectoryMode()==null) || 
             (this.caDirectoryMode!=null &&
              this.caDirectoryMode.equals(other.getCaDirectoryMode()))) &&
            ((this.createIfNotExists==null && other.getCreateIfNotExists()==null) || 
             (this.createIfNotExists!=null &&
              this.createIfNotExists.equals(other.getCreateIfNotExists()))) &&
            ((this.recoverIfExists==null && other.getRecoverIfExists()==null) || 
             (this.recoverIfExists!=null &&
              this.recoverIfExists.equals(other.getRecoverIfExists()))) &&
            ((this.p12LatestKeyOnly==null && other.getP12LatestKeyOnly()==null) || 
             (this.p12LatestKeyOnly!=null &&
              this.p12LatestKeyOnly.equals(other.getP12LatestKeyOnly()))) &&
            ((this.securityStoreType==null && other.getSecurityStoreType()==null) || 
             (this.securityStoreType!=null &&
              this.securityStoreType.equals(other.getSecurityStoreType()))) &&
            ((this.securityStorePassword==null && other.getSecurityStorePassword()==null) || 
             (this.securityStorePassword!=null &&
              this.securityStorePassword.equals(other.getSecurityStorePassword()))) &&
            ((this.p10Requests==null && other.getP10Requests()==null) || 
             (this.p10Requests!=null &&
              java.util.Arrays.equals(this.p10Requests, other.getP10Requests()))) &&
            ((this.clientType==null && other.getClientType()==null) || 
             (this.clientType!=null &&
              this.clientType.equals(other.getClientType()))) &&
            ((this.certificateLifetime==null && other.getCertificateLifetime()==null) || 
             (this.certificateLifetime!=null &&
              this.certificateLifetime.equals(other.getCertificateLifetime()))) &&
            ((this.certificateExpiryDate==null && other.getCertificateExpiryDate()==null) || 
             (this.certificateExpiryDate!=null &&
              this.certificateExpiryDate.equals(other.getCertificateExpiryDate()))) &&
            ((this.comment==null && other.getComment()==null) || 
             (this.comment!=null &&
              this.comment.equals(other.getComment())));
        __equalsCalc = null;
        return _equals;
    }

    private boolean __hashCodeCalc = false;
    public synchronized int hashCode() {
        if (__hashCodeCalc) {
            return 0;
        }
        __hashCodeCalc = true;
        int _hashCode = 1;
        if (getDigitalIdConfig() != null) {
            _hashCode += getDigitalIdConfig().hashCode();
        }
        if (getDN() != null) {
            _hashCode += getDN().hashCode();
        }
        if (getDNVariables() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getDNVariables());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getDNVariables(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getSubjectAltName() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getSubjectAltName());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getSubjectAltName(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getCaVariables() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getCaVariables());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getCaVariables(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getCaDirectoryMode() != null) {
            _hashCode += getCaDirectoryMode().hashCode();
        }
        if (getCreateIfNotExists() != null) {
            _hashCode += getCreateIfNotExists().hashCode();
        }
        if (getRecoverIfExists() != null) {
            _hashCode += getRecoverIfExists().hashCode();
        }
        if (getP12LatestKeyOnly() != null) {
            _hashCode += getP12LatestKeyOnly().hashCode();
        }
        if (getSecurityStoreType() != null) {
            _hashCode += getSecurityStoreType().hashCode();
        }
        if (getSecurityStorePassword() != null) {
            _hashCode += getSecurityStorePassword().hashCode();
        }
        if (getP10Requests() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getP10Requests());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getP10Requests(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getClientType() != null) {
            _hashCode += getClientType().hashCode();
        }
        if (getCertificateLifetime() != null) {
            _hashCode += getCertificateLifetime().hashCode();
        }
        if (getCertificateExpiryDate() != null) {
            _hashCode += getCertificateExpiryDate().hashCode();
        }
        if (getComment() != null) {
            _hashCode += getComment().hashCode();
        }
        __hashCodeCalc = false;
        return _hashCode;
    }

    @Override
    public String toString() {
        return "UserDigitalIdParms{" +
                "comment='" + comment + '\'' +
                ", digitalIdConfig='" + digitalIdConfig + '\'' +
                ", DN='" + DN + '\'' +
                ", DNVariables=" + Arrays.toString(DNVariables) +
                ", caVariables=" + Arrays.toString(caVariables) +
                ", createIfNotExists=" + createIfNotExists +
                ", recoverIfExists=" + recoverIfExists +
                ", p12LatestKeyOnly=" + p12LatestKeyOnly +
                ", securityStoreType=" + securityStoreType +
                ", p10Requests=" + Arrays.toString(p10Requests) +
                ", caDirectoryMode=" + caDirectoryMode +
                ", clientType='" + clientType + '\'' +
                ", certificateLifetime=" + certificateLifetime +
                ", certificateExpiryDate=" + certificateExpiryDate +
                ", subjectAltName=" + Arrays.toString(subjectAltName) +
                '}';
    }

    // Type metadata
    private static org.apache.axis.description.TypeDesc typeDesc =
        new org.apache.axis.description.TypeDesc(UserDigitalIdParms.class, true);

    static {
        typeDesc.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "UserDigitalIdParms"));
        org.apache.axis.description.ElementDesc elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("digitalIdConfig");
        elemField.setXmlName(new javax.xml.namespace.QName("", "DigitalIdConfig"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("DN");
        elemField.setXmlName(new javax.xml.namespace.QName("", "DN"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("DNVariables");
        elemField.setXmlName(new javax.xml.namespace.QName("", "DNVariables"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:commonV9", "NameValue"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("subjectAltName");
        elemField.setXmlName(new javax.xml.namespace.QName("", "SubjectAltName"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "SubjectAltName"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("caVariables");
        elemField.setXmlName(new javax.xml.namespace.QName("", "CaVariables"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "ManagedCaVariable"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("caDirectoryMode");
        elemField.setXmlName(new javax.xml.namespace.QName("", "CaDirectoryMode"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "ManagedCaDirectoryMode"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("createIfNotExists");
        elemField.setXmlName(new javax.xml.namespace.QName("", "CreateIfNotExists"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("recoverIfExists");
        elemField.setXmlName(new javax.xml.namespace.QName("", "RecoverIfExists"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("p12LatestKeyOnly");
        elemField.setXmlName(new javax.xml.namespace.QName("", "P12LatestKeyOnly"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("securityStoreType");
        elemField.setXmlName(new javax.xml.namespace.QName("", "SecurityStoreType"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "DigitalIdSecurityStoreType"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("securityStorePassword");
        elemField.setXmlName(new javax.xml.namespace.QName("", "SecurityStorePassword"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("p10Requests");
        elemField.setXmlName(new javax.xml.namespace.QName("", "P10Requests"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "DigitalIdP10Request"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("clientType");
        elemField.setXmlName(new javax.xml.namespace.QName("", "ClientType"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("certificateLifetime");
        elemField.setXmlName(new javax.xml.namespace.QName("", "CertificateLifetime"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("certificateExpiryDate");
        elemField.setXmlName(new javax.xml.namespace.QName("", "CertificateExpiryDate"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "dateTime"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("comment");
        elemField.setXmlName(new javax.xml.namespace.QName("", "Comment"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
    }

    /**
     * Return type metadata object
     */
    public static org.apache.axis.description.TypeDesc getTypeDesc() {
        return typeDesc;
    }

    /**
     * Get Custom Serializer
     */
    public static org.apache.axis.encoding.Serializer getSerializer(
           String mechType,
           Class _javaType,
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanSerializer(
            _javaType, _xmlType, typeDesc);
    }

    /**
     * Get Custom Deserializer
     */
    public static org.apache.axis.encoding.Deserializer getDeserializer(
           String mechType,
           Class _javaType,
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanDeserializer(
            _javaType, _xmlType, typeDesc);
    }

}
