/**
 * PasswordRulesInfo.java
 *
 * This file was auto-generated from WSDL
 * by the Apache Axis 1.4 Apr 22, 2006 (06:55:48 PDT) WSDL2Java emitter.
 */

package com.good.adapters.entrust.stubs;


/**
 * Defines a password policy used to specify the rules
 *                         newly created passwords must obey. The password
 * rules
 *                         for the default policy apply to master users
 * as well
 *                         as regular users of the system.
 */
public class PasswordRulesInfo  implements java.io.Serializable {
    /* The name of the password policy. */
    private String name;

    /* The name of a password.  This value will be
     *                             specified for a named password rules and
     * null
     *                             for the default password rules. */
    private String passwordName;

    /* The minimum length of the password. */
    private int minLength;

    /* The lifetime of the password in days. A value
     *                                 of 0 means the password has an infinite
     * lifetime. This
     *                                 value does not apply to master user
     * passwords. */
    private int lifetime;

    /* The minimum lifetime of the password in days. A value
     *                                 of 0 means the password has no minimum
     * lifetime. This
     *                                 value controls how frequently users
     * can change their
     *                                 passwords.
     *                                 This value does not apply to master
     * user passwords. */
    private int minLifetime;

    /* The number of old passwords kept in history to prevent
     *                                 duplicates. This value does not apply
     * to master user
     *                                 passwords. */
    private int history;

    /* If true, a new password value for this
     *                                 password must be unique with respect
     * to the
     *                                 current password values of all other
     * passwords for the user in addition to not
     *                                 matching any passwords in its history. */
    private boolean unique;

    /* The time in minutes before a logged in but idle
     *                                 administration service session requires
     * relogin.
     *                                 A value of 0 means a logged in session
     * will
     *                                 not be timed out by this value, but
     * will instead
     *                                 be timed out by the session timeout
     * configured
     *                                 in the application server.
     *                                 This value will not be set for named
     * password
     *                                 rules. */
    private Integer idleTimeout;

    /* The interval in seconds that a logged in
     *                                 administration service session is
     * validated
     *                                 to ensure that the administrator is
     * still
     *                                 a valid administrator.  A negative
     * value
     *                                 indicates that the administrator is
     * only
     *                                 validated at login time.  A value
     * of 0
     *                                 that the administrator is validated
     * during
     *                                 each request.
     *                                 This value will not be set for named
     * password
     *                                 rules. */
    private Integer confirmationInterval;

    /* Specify whether an uppercase character is
     *                                 required, allowed or not allowed in
     * the pasword. */
    private PasswordCharacterType uppercase;

    /* If uppercase characters are required, specify
     *                                 the number of uppercase characters
     * required.
     *                                 The specified value must be a positive
     * integer. */
    private int uppercaseRequired;

    /* Specify whether a lowercase character is
     *                                 required, allowed or not allowed in
     * the pasword. */
    private PasswordCharacterType lowercase;

    /* If lowercase characters are required, specify
     *                                 the number of lowercase characters
     * required.
     *                                 The specified value must be a positive
     * integer. */
    private int lowercaseRequired;

    /* Specify whether a numeric character is
     *                                 required, allowed or not allowed in
     * the pasword. */
    private PasswordCharacterType number;

    /* If numeric characters are required, specify
     *                                 the number of numeric characters required.
     * The specified value must be a positive integer. */
    private int numberRequired;

    /* Specify whether a non-alphanumeric character is
     *                                 required, allowed or not allowed in
     * the pasword. */
    private PasswordCharacterType special;

    /* If special characters are required, specify
     *                                 the number of special characters required.
     * The specified value must be a positive integer. */
    private int specialRequired;

    /* The type of first-factor authentication
     *                                 used by an administrator to login
     * to the
     *                                 administration service.  Allowed values
     * are PASSWORD and EXTERNAL.
     *                                 This attribute will not be set for
     * named
     *                                 password rules. */
    private AuthenticationType firstAuth;

    /* If set to one of the values GRID, TOKENRO or
     *                                 TOKENCR
     *                                 then an administrator will require
     * this type
     *                                 of second factor authentication to
     * login to the
     *                                 administration service.  If
     *                                 set to the value NONE, the administrator
     * will
     *                                 not require second factor authentication
     * to
     *                                 login.  This value does not apply
     * to master
     *                                 user login attempts.
     *                                 This attribute will not be set for
     * named
     *                                 password rules. */
    private AuthenticationType secondAuth;

    /* If true, an administrator is allowed to use a SAML
     *                                 assertion to login to the administration
     * service. */
    private Boolean samlAuthAllowed;

    /* If true, an administrator is allowed to use 
     *                                 Smart Credential authentication to
     * login to
     *                                 the administration service. */
    private Boolean smartcredentialAuthAllowed;

    /* If true, an administrator is allowed to use header
     *                                 based authentication to login to the
     * administration service. */
    private Boolean headerAuthAllowed;

    /* Indicates how the password values are stored in
     *                                 the repository.  This value does not
     * apply to
     *                                 how master user passwords are stored. */
    private PasswordStorage storage;

    /* The maximum number of times a character can
     *                                 be repeated consecutively in a password.
     * A value of 0 means there is no restriction.
     *                                 The default for a new policy is 0. */
    private int maxRepeatedChars;

    /* The maximum time in hours in which a password
     *                                 which has been set to require change
     * must be
     *                                 changed.
     *                                 A value of 0 means there is no restriction.
     * The default for a new policy is 0. */
    private int maxPasswordChangeTime;

    /* The number of consecutive PASSWORD authentication 
     *                                 failures allowed before a user is
     * locked out. A value 
     *                                 of 0 means the user is never locked
     * out, no matter 
     *                                 how many times they fail to authenticate.
     * This policy is used with the ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes. */
    private int maxPasswordFailures;

    /* When this structure is returned by an admin
     *                                 service operation, this is the list
     * of the
     *                                 names of the roles that granted access
     * to this
     *                                 structure. */
    private String[] rolesGrantingAccess;

    /* Descriptive comments. */
    private String comment;

    public PasswordRulesInfo() {
    }

    public PasswordRulesInfo(
           String name,
           String passwordName,
           int minLength,
           int lifetime,
           int minLifetime,
           int history,
           boolean unique,
           Integer idleTimeout,
           Integer confirmationInterval,
           PasswordCharacterType uppercase,
           int uppercaseRequired,
           PasswordCharacterType lowercase,
           int lowercaseRequired,
           PasswordCharacterType number,
           int numberRequired,
           PasswordCharacterType special,
           int specialRequired,
           AuthenticationType firstAuth,
           AuthenticationType secondAuth,
           Boolean samlAuthAllowed,
           Boolean smartcredentialAuthAllowed,
           Boolean headerAuthAllowed,
           PasswordStorage storage,
           int maxRepeatedChars,
           int maxPasswordChangeTime,
           int maxPasswordFailures,
           String[] rolesGrantingAccess,
           String comment) {
           this.name = name;
           this.passwordName = passwordName;
           this.minLength = minLength;
           this.lifetime = lifetime;
           this.minLifetime = minLifetime;
           this.history = history;
           this.unique = unique;
           this.idleTimeout = idleTimeout;
           this.confirmationInterval = confirmationInterval;
           this.uppercase = uppercase;
           this.uppercaseRequired = uppercaseRequired;
           this.lowercase = lowercase;
           this.lowercaseRequired = lowercaseRequired;
           this.number = number;
           this.numberRequired = numberRequired;
           this.special = special;
           this.specialRequired = specialRequired;
           this.firstAuth = firstAuth;
           this.secondAuth = secondAuth;
           this.samlAuthAllowed = samlAuthAllowed;
           this.smartcredentialAuthAllowed = smartcredentialAuthAllowed;
           this.headerAuthAllowed = headerAuthAllowed;
           this.storage = storage;
           this.maxRepeatedChars = maxRepeatedChars;
           this.maxPasswordChangeTime = maxPasswordChangeTime;
           this.maxPasswordFailures = maxPasswordFailures;
           this.rolesGrantingAccess = rolesGrantingAccess;
           this.comment = comment;
    }


    /**
     * Gets the name value for this PasswordRulesInfo.
     * 
     * @return name   * The name of the password policy.
     */
    public String getName() {
        return name;
    }


    /**
     * Sets the name value for this PasswordRulesInfo.
     * 
     * @param name   * The name of the password policy.
     */
    public void setName(String name) {
        this.name = name;
    }


    /**
     * Gets the passwordName value for this PasswordRulesInfo.
     * 
     * @return passwordName   * The name of a password.  This value will be
     *                             specified for a named password rules and
     * null
     *                             for the default password rules.
     */
    public String getPasswordName() {
        return passwordName;
    }


    /**
     * Sets the passwordName value for this PasswordRulesInfo.
     * 
     * @param passwordName   * The name of a password.  This value will be
     *                             specified for a named password rules and
     * null
     *                             for the default password rules.
     */
    public void setPasswordName(String passwordName) {
        this.passwordName = passwordName;
    }


    /**
     * Gets the minLength value for this PasswordRulesInfo.
     * 
     * @return minLength   * The minimum length of the password.
     */
    public int getMinLength() {
        return minLength;
    }


    /**
     * Sets the minLength value for this PasswordRulesInfo.
     * 
     * @param minLength   * The minimum length of the password.
     */
    public void setMinLength(int minLength) {
        this.minLength = minLength;
    }


    /**
     * Gets the lifetime value for this PasswordRulesInfo.
     * 
     * @return lifetime   * The lifetime of the password in days. A value
     *                                 of 0 means the password has an infinite
     * lifetime. This
     *                                 value does not apply to master user
     * passwords.
     */
    public int getLifetime() {
        return lifetime;
    }


    /**
     * Sets the lifetime value for this PasswordRulesInfo.
     * 
     * @param lifetime   * The lifetime of the password in days. A value
     *                                 of 0 means the password has an infinite
     * lifetime. This
     *                                 value does not apply to master user
     * passwords.
     */
    public void setLifetime(int lifetime) {
        this.lifetime = lifetime;
    }


    /**
     * Gets the minLifetime value for this PasswordRulesInfo.
     * 
     * @return minLifetime   * The minimum lifetime of the password in days. A value
     *                                 of 0 means the password has no minimum
     * lifetime. This
     *                                 value controls how frequently users
     * can change their
     *                                 passwords.
     *                                 This value does not apply to master
     * user passwords.
     */
    public int getMinLifetime() {
        return minLifetime;
    }


    /**
     * Sets the minLifetime value for this PasswordRulesInfo.
     * 
     * @param minLifetime   * The minimum lifetime of the password in days. A value
     *                                 of 0 means the password has no minimum
     * lifetime. This
     *                                 value controls how frequently users
     * can change their
     *                                 passwords.
     *                                 This value does not apply to master
     * user passwords.
     */
    public void setMinLifetime(int minLifetime) {
        this.minLifetime = minLifetime;
    }


    /**
     * Gets the history value for this PasswordRulesInfo.
     * 
     * @return history   * The number of old passwords kept in history to prevent
     *                                 duplicates. This value does not apply
     * to master user
     *                                 passwords.
     */
    public int getHistory() {
        return history;
    }


    /**
     * Sets the history value for this PasswordRulesInfo.
     * 
     * @param history   * The number of old passwords kept in history to prevent
     *                                 duplicates. This value does not apply
     * to master user
     *                                 passwords.
     */
    public void setHistory(int history) {
        this.history = history;
    }


    /**
     * Gets the unique value for this PasswordRulesInfo.
     * 
     * @return unique   * If true, a new password value for this
     *                                 password must be unique with respect
     * to the
     *                                 current password values of all other
     * passwords for the user in addition to not
     *                                 matching any passwords in its history.
     */
    public boolean isUnique() {
        return unique;
    }


    /**
     * Sets the unique value for this PasswordRulesInfo.
     * 
     * @param unique   * If true, a new password value for this
     *                                 password must be unique with respect
     * to the
     *                                 current password values of all other
     * passwords for the user in addition to not
     *                                 matching any passwords in its history.
     */
    public void setUnique(boolean unique) {
        this.unique = unique;
    }


    /**
     * Gets the idleTimeout value for this PasswordRulesInfo.
     * 
     * @return idleTimeout   * The time in minutes before a logged in but idle
     *                                 administration service session requires
     * relogin.
     *                                 A value of 0 means a logged in session
     * will
     *                                 not be timed out by this value, but
     * will instead
     *                                 be timed out by the session timeout
     * configured
     *                                 in the application server.
     *                                 This value will not be set for named
     * password
     *                                 rules.
     */
    public Integer getIdleTimeout() {
        return idleTimeout;
    }


    /**
     * Sets the idleTimeout value for this PasswordRulesInfo.
     * 
     * @param idleTimeout   * The time in minutes before a logged in but idle
     *                                 administration service session requires
     * relogin.
     *                                 A value of 0 means a logged in session
     * will
     *                                 not be timed out by this value, but
     * will instead
     *                                 be timed out by the session timeout
     * configured
     *                                 in the application server.
     *                                 This value will not be set for named
     * password
     *                                 rules.
     */
    public void setIdleTimeout(Integer idleTimeout) {
        this.idleTimeout = idleTimeout;
    }


    /**
     * Gets the confirmationInterval value for this PasswordRulesInfo.
     * 
     * @return confirmationInterval   * The interval in seconds that a logged in
     *                                 administration service session is
     * validated
     *                                 to ensure that the administrator is
     * still
     *                                 a valid administrator.  A negative
     * value
     *                                 indicates that the administrator is
     * only
     *                                 validated at login time.  A value
     * of 0
     *                                 that the administrator is validated
     * during
     *                                 each request.
     *                                 This value will not be set for named
     * password
     *                                 rules.
     */
    public Integer getConfirmationInterval() {
        return confirmationInterval;
    }


    /**
     * Sets the confirmationInterval value for this PasswordRulesInfo.
     * 
     * @param confirmationInterval   * The interval in seconds that a logged in
     *                                 administration service session is
     * validated
     *                                 to ensure that the administrator is
     * still
     *                                 a valid administrator.  A negative
     * value
     *                                 indicates that the administrator is
     * only
     *                                 validated at login time.  A value
     * of 0
     *                                 that the administrator is validated
     * during
     *                                 each request.
     *                                 This value will not be set for named
     * password
     *                                 rules.
     */
    public void setConfirmationInterval(Integer confirmationInterval) {
        this.confirmationInterval = confirmationInterval;
    }


    /**
     * Gets the uppercase value for this PasswordRulesInfo.
     * 
     * @return uppercase   * Specify whether an uppercase character is
     *                                 required, allowed or not allowed in
     * the pasword.
     */
    public PasswordCharacterType getUppercase() {
        return uppercase;
    }


    /**
     * Sets the uppercase value for this PasswordRulesInfo.
     * 
     * @param uppercase   * Specify whether an uppercase character is
     *                                 required, allowed or not allowed in
     * the pasword.
     */
    public void setUppercase(PasswordCharacterType uppercase) {
        this.uppercase = uppercase;
    }


    /**
     * Gets the uppercaseRequired value for this PasswordRulesInfo.
     * 
     * @return uppercaseRequired   * If uppercase characters are required, specify
     *                                 the number of uppercase characters
     * required.
     *                                 The specified value must be a positive
     * integer.
     */
    public int getUppercaseRequired() {
        return uppercaseRequired;
    }


    /**
     * Sets the uppercaseRequired value for this PasswordRulesInfo.
     * 
     * @param uppercaseRequired   * If uppercase characters are required, specify
     *                                 the number of uppercase characters
     * required.
     *                                 The specified value must be a positive
     * integer.
     */
    public void setUppercaseRequired(int uppercaseRequired) {
        this.uppercaseRequired = uppercaseRequired;
    }


    /**
     * Gets the lowercase value for this PasswordRulesInfo.
     * 
     * @return lowercase   * Specify whether a lowercase character is
     *                                 required, allowed or not allowed in
     * the pasword.
     */
    public PasswordCharacterType getLowercase() {
        return lowercase;
    }


    /**
     * Sets the lowercase value for this PasswordRulesInfo.
     * 
     * @param lowercase   * Specify whether a lowercase character is
     *                                 required, allowed or not allowed in
     * the pasword.
     */
    public void setLowercase(PasswordCharacterType lowercase) {
        this.lowercase = lowercase;
    }


    /**
     * Gets the lowercaseRequired value for this PasswordRulesInfo.
     * 
     * @return lowercaseRequired   * If lowercase characters are required, specify
     *                                 the number of lowercase characters
     * required.
     *                                 The specified value must be a positive
     * integer.
     */
    public int getLowercaseRequired() {
        return lowercaseRequired;
    }


    /**
     * Sets the lowercaseRequired value for this PasswordRulesInfo.
     * 
     * @param lowercaseRequired   * If lowercase characters are required, specify
     *                                 the number of lowercase characters
     * required.
     *                                 The specified value must be a positive
     * integer.
     */
    public void setLowercaseRequired(int lowercaseRequired) {
        this.lowercaseRequired = lowercaseRequired;
    }


    /**
     * Gets the number value for this PasswordRulesInfo.
     * 
     * @return number   * Specify whether a numeric character is
     *                                 required, allowed or not allowed in
     * the pasword.
     */
    public PasswordCharacterType getNumber() {
        return number;
    }


    /**
     * Sets the number value for this PasswordRulesInfo.
     * 
     * @param number   * Specify whether a numeric character is
     *                                 required, allowed or not allowed in
     * the pasword.
     */
    public void setNumber(PasswordCharacterType number) {
        this.number = number;
    }


    /**
     * Gets the numberRequired value for this PasswordRulesInfo.
     * 
     * @return numberRequired   * If numeric characters are required, specify
     *                                 the number of numeric characters required.
     * The specified value must be a positive integer.
     */
    public int getNumberRequired() {
        return numberRequired;
    }


    /**
     * Sets the numberRequired value for this PasswordRulesInfo.
     * 
     * @param numberRequired   * If numeric characters are required, specify
     *                                 the number of numeric characters required.
     * The specified value must be a positive integer.
     */
    public void setNumberRequired(int numberRequired) {
        this.numberRequired = numberRequired;
    }


    /**
     * Gets the special value for this PasswordRulesInfo.
     * 
     * @return special   * Specify whether a non-alphanumeric character is
     *                                 required, allowed or not allowed in
     * the pasword.
     */
    public PasswordCharacterType getSpecial() {
        return special;
    }


    /**
     * Sets the special value for this PasswordRulesInfo.
     * 
     * @param special   * Specify whether a non-alphanumeric character is
     *                                 required, allowed or not allowed in
     * the pasword.
     */
    public void setSpecial(PasswordCharacterType special) {
        this.special = special;
    }


    /**
     * Gets the specialRequired value for this PasswordRulesInfo.
     * 
     * @return specialRequired   * If special characters are required, specify
     *                                 the number of special characters required.
     * The specified value must be a positive integer.
     */
    public int getSpecialRequired() {
        return specialRequired;
    }


    /**
     * Sets the specialRequired value for this PasswordRulesInfo.
     * 
     * @param specialRequired   * If special characters are required, specify
     *                                 the number of special characters required.
     * The specified value must be a positive integer.
     */
    public void setSpecialRequired(int specialRequired) {
        this.specialRequired = specialRequired;
    }


    /**
     * Gets the firstAuth value for this PasswordRulesInfo.
     * 
     * @return firstAuth   * The type of first-factor authentication
     *                                 used by an administrator to login
     * to the
     *                                 administration service.  Allowed values
     * are PASSWORD and EXTERNAL.
     *                                 This attribute will not be set for
     * named
     *                                 password rules.
     */
    public AuthenticationType getFirstAuth() {
        return firstAuth;
    }


    /**
     * Sets the firstAuth value for this PasswordRulesInfo.
     * 
     * @param firstAuth   * The type of first-factor authentication
     *                                 used by an administrator to login
     * to the
     *                                 administration service.  Allowed values
     * are PASSWORD and EXTERNAL.
     *                                 This attribute will not be set for
     * named
     *                                 password rules.
     */
    public void setFirstAuth(AuthenticationType firstAuth) {
        this.firstAuth = firstAuth;
    }


    /**
     * Gets the secondAuth value for this PasswordRulesInfo.
     * 
     * @return secondAuth   * If set to one of the values GRID, TOKENRO or
     *                                 TOKENCR
     *                                 then an administrator will require
     * this type
     *                                 of second factor authentication to
     * login to the
     *                                 administration service.  If
     *                                 set to the value NONE, the administrator
     * will
     *                                 not require second factor authentication
     * to
     *                                 login.  This value does not apply
     * to master
     *                                 user login attempts.
     *                                 This attribute will not be set for
     * named
     *                                 password rules.
     */
    public AuthenticationType getSecondAuth() {
        return secondAuth;
    }


    /**
     * Sets the secondAuth value for this PasswordRulesInfo.
     * 
     * @param secondAuth   * If set to one of the values GRID, TOKENRO or
     *                                 TOKENCR
     *                                 then an administrator will require
     * this type
     *                                 of second factor authentication to
     * login to the
     *                                 administration service.  If
     *                                 set to the value NONE, the administrator
     * will
     *                                 not require second factor authentication
     * to
     *                                 login.  This value does not apply
     * to master
     *                                 user login attempts.
     *                                 This attribute will not be set for
     * named
     *                                 password rules.
     */
    public void setSecondAuth(AuthenticationType secondAuth) {
        this.secondAuth = secondAuth;
    }


    /**
     * Gets the samlAuthAllowed value for this PasswordRulesInfo.
     * 
     * @return samlAuthAllowed   * If true, an administrator is allowed to use a SAML
     *                                 assertion to login to the administration
     * service.
     */
    public Boolean getSamlAuthAllowed() {
        return samlAuthAllowed;
    }


    /**
     * Sets the samlAuthAllowed value for this PasswordRulesInfo.
     * 
     * @param samlAuthAllowed   * If true, an administrator is allowed to use a SAML
     *                                 assertion to login to the administration
     * service.
     */
    public void setSamlAuthAllowed(Boolean samlAuthAllowed) {
        this.samlAuthAllowed = samlAuthAllowed;
    }


    /**
     * Gets the smartcredentialAuthAllowed value for this PasswordRulesInfo.
     * 
     * @return smartcredentialAuthAllowed   * If true, an administrator is allowed to use 
     *                                 Smart Credential authentication to
     * login to
     *                                 the administration service.
     */
    public Boolean getSmartcredentialAuthAllowed() {
        return smartcredentialAuthAllowed;
    }


    /**
     * Sets the smartcredentialAuthAllowed value for this PasswordRulesInfo.
     * 
     * @param smartcredentialAuthAllowed   * If true, an administrator is allowed to use 
     *                                 Smart Credential authentication to
     * login to
     *                                 the administration service.
     */
    public void setSmartcredentialAuthAllowed(Boolean smartcredentialAuthAllowed) {
        this.smartcredentialAuthAllowed = smartcredentialAuthAllowed;
    }


    /**
     * Gets the headerAuthAllowed value for this PasswordRulesInfo.
     * 
     * @return headerAuthAllowed   * If true, an administrator is allowed to use header
     *                                 based authentication to login to the
     * administration service.
     */
    public Boolean getHeaderAuthAllowed() {
        return headerAuthAllowed;
    }


    /**
     * Sets the headerAuthAllowed value for this PasswordRulesInfo.
     * 
     * @param headerAuthAllowed   * If true, an administrator is allowed to use header
     *                                 based authentication to login to the
     * administration service.
     */
    public void setHeaderAuthAllowed(Boolean headerAuthAllowed) {
        this.headerAuthAllowed = headerAuthAllowed;
    }


    /**
     * Gets the storage value for this PasswordRulesInfo.
     * 
     * @return storage   * Indicates how the password values are stored in
     *                                 the repository.  This value does not
     * apply to
     *                                 how master user passwords are stored.
     */
    public PasswordStorage getStorage() {
        return storage;
    }


    /**
     * Sets the storage value for this PasswordRulesInfo.
     * 
     * @param storage   * Indicates how the password values are stored in
     *                                 the repository.  This value does not
     * apply to
     *                                 how master user passwords are stored.
     */
    public void setStorage(PasswordStorage storage) {
        this.storage = storage;
    }


    /**
     * Gets the maxRepeatedChars value for this PasswordRulesInfo.
     * 
     * @return maxRepeatedChars   * The maximum number of times a character can
     *                                 be repeated consecutively in a password.
     * A value of 0 means there is no restriction.
     *                                 The default for a new policy is 0.
     */
    public int getMaxRepeatedChars() {
        return maxRepeatedChars;
    }


    /**
     * Sets the maxRepeatedChars value for this PasswordRulesInfo.
     * 
     * @param maxRepeatedChars   * The maximum number of times a character can
     *                                 be repeated consecutively in a password.
     * A value of 0 means there is no restriction.
     *                                 The default for a new policy is 0.
     */
    public void setMaxRepeatedChars(int maxRepeatedChars) {
        this.maxRepeatedChars = maxRepeatedChars;
    }


    /**
     * Gets the maxPasswordChangeTime value for this PasswordRulesInfo.
     * 
     * @return maxPasswordChangeTime   * The maximum time in hours in which a password
     *                                 which has been set to require change
     * must be
     *                                 changed.
     *                                 A value of 0 means there is no restriction.
     * The default for a new policy is 0.
     */
    public int getMaxPasswordChangeTime() {
        return maxPasswordChangeTime;
    }


    /**
     * Sets the maxPasswordChangeTime value for this PasswordRulesInfo.
     * 
     * @param maxPasswordChangeTime   * The maximum time in hours in which a password
     *                                 which has been set to require change
     * must be
     *                                 changed.
     *                                 A value of 0 means there is no restriction.
     * The default for a new policy is 0.
     */
    public void setMaxPasswordChangeTime(int maxPasswordChangeTime) {
        this.maxPasswordChangeTime = maxPasswordChangeTime;
    }


    /**
     * Gets the maxPasswordFailures value for this PasswordRulesInfo.
     * 
     * @return maxPasswordFailures   * The number of consecutive PASSWORD authentication 
     *                                 failures allowed before a user is
     * locked out. A value 
     *                                 of 0 means the user is never locked
     * out, no matter 
     *                                 how many times they fail to authenticate.
     * This policy is used with the ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes.
     */
    public int getMaxPasswordFailures() {
        return maxPasswordFailures;
    }


    /**
     * Sets the maxPasswordFailures value for this PasswordRulesInfo.
     * 
     * @param maxPasswordFailures   * The number of consecutive PASSWORD authentication 
     *                                 failures allowed before a user is
     * locked out. A value 
     *                                 of 0 means the user is never locked
     * out, no matter 
     *                                 how many times they fail to authenticate.
     * This policy is used with the ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes.
     */
    public void setMaxPasswordFailures(int maxPasswordFailures) {
        this.maxPasswordFailures = maxPasswordFailures;
    }


    /**
     * Gets the rolesGrantingAccess value for this PasswordRulesInfo.
     * 
     * @return rolesGrantingAccess   * When this structure is returned by an admin
     *                                 service operation, this is the list
     * of the
     *                                 names of the roles that granted access
     * to this
     *                                 structure.
     */
    public String[] getRolesGrantingAccess() {
        return rolesGrantingAccess;
    }


    /**
     * Sets the rolesGrantingAccess value for this PasswordRulesInfo.
     * 
     * @param rolesGrantingAccess   * When this structure is returned by an admin
     *                                 service operation, this is the list
     * of the
     *                                 names of the roles that granted access
     * to this
     *                                 structure.
     */
    public void setRolesGrantingAccess(String[] rolesGrantingAccess) {
        this.rolesGrantingAccess = rolesGrantingAccess;
    }


    /**
     * Gets the comment value for this PasswordRulesInfo.
     * 
     * @return comment   * Descriptive comments.
     */
    public String getComment() {
        return comment;
    }


    /**
     * Sets the comment value for this PasswordRulesInfo.
     * 
     * @param comment   * Descriptive comments.
     */
    public void setComment(String comment) {
        this.comment = comment;
    }

    private Object __equalsCalc = null;
    public synchronized boolean equals(Object obj) {
        if (!(obj instanceof PasswordRulesInfo)) return false;
        PasswordRulesInfo other = (PasswordRulesInfo) obj;
        if (obj == null) return false;
        if (this == obj) return true;
        if (__equalsCalc != null) {
            return (__equalsCalc == obj);
        }
        __equalsCalc = obj;
        boolean _equals;
        _equals = true && 
            ((this.name==null && other.getName()==null) || 
             (this.name!=null &&
              this.name.equals(other.getName()))) &&
            ((this.passwordName==null && other.getPasswordName()==null) || 
             (this.passwordName!=null &&
              this.passwordName.equals(other.getPasswordName()))) &&
            this.minLength == other.getMinLength() &&
            this.lifetime == other.getLifetime() &&
            this.minLifetime == other.getMinLifetime() &&
            this.history == other.getHistory() &&
            this.unique == other.isUnique() &&
            ((this.idleTimeout==null && other.getIdleTimeout()==null) || 
             (this.idleTimeout!=null &&
              this.idleTimeout.equals(other.getIdleTimeout()))) &&
            ((this.confirmationInterval==null && other.getConfirmationInterval()==null) || 
             (this.confirmationInterval!=null &&
              this.confirmationInterval.equals(other.getConfirmationInterval()))) &&
            ((this.uppercase==null && other.getUppercase()==null) || 
             (this.uppercase!=null &&
              this.uppercase.equals(other.getUppercase()))) &&
            this.uppercaseRequired == other.getUppercaseRequired() &&
            ((this.lowercase==null && other.getLowercase()==null) || 
             (this.lowercase!=null &&
              this.lowercase.equals(other.getLowercase()))) &&
            this.lowercaseRequired == other.getLowercaseRequired() &&
            ((this.number==null && other.getNumber()==null) || 
             (this.number!=null &&
              this.number.equals(other.getNumber()))) &&
            this.numberRequired == other.getNumberRequired() &&
            ((this.special==null && other.getSpecial()==null) || 
             (this.special!=null &&
              this.special.equals(other.getSpecial()))) &&
            this.specialRequired == other.getSpecialRequired() &&
            ((this.firstAuth==null && other.getFirstAuth()==null) || 
             (this.firstAuth!=null &&
              this.firstAuth.equals(other.getFirstAuth()))) &&
            ((this.secondAuth==null && other.getSecondAuth()==null) || 
             (this.secondAuth!=null &&
              this.secondAuth.equals(other.getSecondAuth()))) &&
            ((this.samlAuthAllowed==null && other.getSamlAuthAllowed()==null) || 
             (this.samlAuthAllowed!=null &&
              this.samlAuthAllowed.equals(other.getSamlAuthAllowed()))) &&
            ((this.smartcredentialAuthAllowed==null && other.getSmartcredentialAuthAllowed()==null) || 
             (this.smartcredentialAuthAllowed!=null &&
              this.smartcredentialAuthAllowed.equals(other.getSmartcredentialAuthAllowed()))) &&
            ((this.headerAuthAllowed==null && other.getHeaderAuthAllowed()==null) || 
             (this.headerAuthAllowed!=null &&
              this.headerAuthAllowed.equals(other.getHeaderAuthAllowed()))) &&
            ((this.storage==null && other.getStorage()==null) || 
             (this.storage!=null &&
              this.storage.equals(other.getStorage()))) &&
            this.maxRepeatedChars == other.getMaxRepeatedChars() &&
            this.maxPasswordChangeTime == other.getMaxPasswordChangeTime() &&
            this.maxPasswordFailures == other.getMaxPasswordFailures() &&
            ((this.rolesGrantingAccess==null && other.getRolesGrantingAccess()==null) || 
             (this.rolesGrantingAccess!=null &&
              java.util.Arrays.equals(this.rolesGrantingAccess, other.getRolesGrantingAccess()))) &&
            ((this.comment==null && other.getComment()==null) || 
             (this.comment!=null &&
              this.comment.equals(other.getComment())));
        __equalsCalc = null;
        return _equals;
    }

    private boolean __hashCodeCalc = false;
    public synchronized int hashCode() {
        if (__hashCodeCalc) {
            return 0;
        }
        __hashCodeCalc = true;
        int _hashCode = 1;
        if (getName() != null) {
            _hashCode += getName().hashCode();
        }
        if (getPasswordName() != null) {
            _hashCode += getPasswordName().hashCode();
        }
        _hashCode += getMinLength();
        _hashCode += getLifetime();
        _hashCode += getMinLifetime();
        _hashCode += getHistory();
        _hashCode += (isUnique() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        if (getIdleTimeout() != null) {
            _hashCode += getIdleTimeout().hashCode();
        }
        if (getConfirmationInterval() != null) {
            _hashCode += getConfirmationInterval().hashCode();
        }
        if (getUppercase() != null) {
            _hashCode += getUppercase().hashCode();
        }
        _hashCode += getUppercaseRequired();
        if (getLowercase() != null) {
            _hashCode += getLowercase().hashCode();
        }
        _hashCode += getLowercaseRequired();
        if (getNumber() != null) {
            _hashCode += getNumber().hashCode();
        }
        _hashCode += getNumberRequired();
        if (getSpecial() != null) {
            _hashCode += getSpecial().hashCode();
        }
        _hashCode += getSpecialRequired();
        if (getFirstAuth() != null) {
            _hashCode += getFirstAuth().hashCode();
        }
        if (getSecondAuth() != null) {
            _hashCode += getSecondAuth().hashCode();
        }
        if (getSamlAuthAllowed() != null) {
            _hashCode += getSamlAuthAllowed().hashCode();
        }
        if (getSmartcredentialAuthAllowed() != null) {
            _hashCode += getSmartcredentialAuthAllowed().hashCode();
        }
        if (getHeaderAuthAllowed() != null) {
            _hashCode += getHeaderAuthAllowed().hashCode();
        }
        if (getStorage() != null) {
            _hashCode += getStorage().hashCode();
        }
        _hashCode += getMaxRepeatedChars();
        _hashCode += getMaxPasswordChangeTime();
        _hashCode += getMaxPasswordFailures();
        if (getRolesGrantingAccess() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getRolesGrantingAccess());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getRolesGrantingAccess(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getComment() != null) {
            _hashCode += getComment().hashCode();
        }
        __hashCodeCalc = false;
        return _hashCode;
    }

    // Type metadata
    private static org.apache.axis.description.TypeDesc typeDesc =
        new org.apache.axis.description.TypeDesc(PasswordRulesInfo.class, true);

    static {
        typeDesc.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "PasswordRulesInfo"));
        org.apache.axis.description.ElementDesc elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("name");
        elemField.setXmlName(new javax.xml.namespace.QName("", "name"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("passwordName");
        elemField.setXmlName(new javax.xml.namespace.QName("", "passwordName"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("minLength");
        elemField.setXmlName(new javax.xml.namespace.QName("", "minLength"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("lifetime");
        elemField.setXmlName(new javax.xml.namespace.QName("", "lifetime"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("minLifetime");
        elemField.setXmlName(new javax.xml.namespace.QName("", "minLifetime"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("history");
        elemField.setXmlName(new javax.xml.namespace.QName("", "history"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("unique");
        elemField.setXmlName(new javax.xml.namespace.QName("", "unique"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("idleTimeout");
        elemField.setXmlName(new javax.xml.namespace.QName("", "idleTimeout"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("confirmationInterval");
        elemField.setXmlName(new javax.xml.namespace.QName("", "confirmationInterval"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("uppercase");
        elemField.setXmlName(new javax.xml.namespace.QName("", "uppercase"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:commonV9", "PasswordCharacterType"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("uppercaseRequired");
        elemField.setXmlName(new javax.xml.namespace.QName("", "uppercaseRequired"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("lowercase");
        elemField.setXmlName(new javax.xml.namespace.QName("", "lowercase"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:commonV9", "PasswordCharacterType"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("lowercaseRequired");
        elemField.setXmlName(new javax.xml.namespace.QName("", "lowercaseRequired"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("number");
        elemField.setXmlName(new javax.xml.namespace.QName("", "number"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:commonV9", "PasswordCharacterType"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("numberRequired");
        elemField.setXmlName(new javax.xml.namespace.QName("", "numberRequired"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("special");
        elemField.setXmlName(new javax.xml.namespace.QName("", "special"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:commonV9", "PasswordCharacterType"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("specialRequired");
        elemField.setXmlName(new javax.xml.namespace.QName("", "specialRequired"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("firstAuth");
        elemField.setXmlName(new javax.xml.namespace.QName("", "firstAuth"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:commonV9", "AuthenticationType"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("secondAuth");
        elemField.setXmlName(new javax.xml.namespace.QName("", "secondAuth"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:commonV9", "AuthenticationType"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("samlAuthAllowed");
        elemField.setXmlName(new javax.xml.namespace.QName("", "samlAuthAllowed"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("smartcredentialAuthAllowed");
        elemField.setXmlName(new javax.xml.namespace.QName("", "smartcredentialAuthAllowed"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("headerAuthAllowed");
        elemField.setXmlName(new javax.xml.namespace.QName("", "headerAuthAllowed"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("storage");
        elemField.setXmlName(new javax.xml.namespace.QName("", "storage"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "PasswordStorage"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxRepeatedChars");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxRepeatedChars"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxPasswordChangeTime");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxPasswordChangeTime"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxPasswordFailures");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxPasswordFailures"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("rolesGrantingAccess");
        elemField.setXmlName(new javax.xml.namespace.QName("", "rolesGrantingAccess"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(false);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("comment");
        elemField.setXmlName(new javax.xml.namespace.QName("", "comment"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
    }

    /**
     * Return type metadata object
     */
    public static org.apache.axis.description.TypeDesc getTypeDesc() {
        return typeDesc;
    }

    /**
     * Get Custom Serializer
     */
    public static org.apache.axis.encoding.Serializer getSerializer(
           String mechType,
           Class _javaType,
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanSerializer(
            _javaType, _xmlType, typeDesc);
    }

    /**
     * Get Custom Deserializer
     */
    public static org.apache.axis.encoding.Deserializer getDeserializer(
           String mechType,
           Class _javaType,
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanDeserializer(
            _javaType, _xmlType, typeDesc);
    }

}
