/**
 * CardSpecParms.java
 *
 * This file was auto-generated from WSDL
 * by the Apache Axis 1.4 Apr 22, 2006 (06:55:48 PDT) WSDL2Java emitter.
 */

package com.good.adapters.entrust.stubs;


/**
 * Parameters used to modify a card specification policy.
 *                     All parameters are optional.
 *                     <p>
 *                     Some of the parameters have
 *                     restrictions that are affected by other parameters
 * that
 *                     may or may not be set. In this case, when modifying
 * an existing
 *                     policy, the resulting policy must obey the restrictions
 * listed. For example, if only the challengeSize parameter is
 *                     included, the resulting policy must obey the restrictions
 * placed on the challengeSize.
 */
public class CardSpecParms  implements java.io.Serializable {
    /* The number of rows in the card. Must be at least 1,
     *                             and the product of
     *                             numRows and numColumns must not exceed
     * one million. */
    private Integer numRows;

    /* The number of columns in the card. Must be at least
     *                             1, and the product of
     *                             numRows and numColumns must not exceed
     * one million. */
    private Integer numColumns;

    /* The number of characters in each cell. This must be
     *                             at least 1 and at most 20. */
    private Integer cellSize;

    /* The characters that can appear in a cell. */
    private String[] cellAlphabet;

    /* A list of characters that are replaced in a challenge
     *                             response before it is validated. This
     * can be used
     *                             to make challenge validation case-insensitive,
     * or
     *                             to make many similar-looking characters
     * such as '1',
     *                             'l', and 'I' all be treated as the same
     * character during
     *                             validation. */
    private CellReplacement[] cellReplacements;

    /* The size of the challenge. The challenge size must
     *                             obey the following constraint:
     *                             1 <= minChallengeSize <= challengeSize
     * <= maxChallengeSize <= numRows * numColumns */
    private Integer challengeSize;

    /* The minimum size of the challenge. Used to validate
     *                             the size when the call to obtain a challenge
     * specifies an explicit size. This must obey 
     *                             the following constraint:
     *                             1 <= minChallengeSize <= challengeSize
     * <= maxChallengeSize <= numRows * numColumns */
    private Integer minChallengeSize;

    /* The maximum size of the challenge. Used to validate
     *                             the size when the call to obtain a challenge
     * specifies an explicit size. This must obey 
     *                             the following constraint:
     *                             1 <= minChallengeSize <= challengeSize
     * <= maxChallengeSize <= numRows * numColumns */
    private Integer maxChallengeSize;

    /* The lifetime in days of a card created using this policy.
     *                             This value must be at least 0 and at most
     * 36500.
     *                             A value of 0 indicates that cards have
     * infinite lifetime. */
    private Long lifetime;

    /* The amount of time in days that a superseded
     *                             card can be used after it is superseded.
     * This value must be at least 0 and at most 36500.
     *                             A value of 0 indicates that superseded
     * cards can be used indefinitely. */
    private Long supersede;

    /* If true, challenges are sorted by column/row after
     *                             generation. Challenges sorted in this
     * way are
     *                             easier for a person to respond to. */
    private Boolean sortChallenge;

    /* If false, don't include the hasPin flag or serial
     *                             number list in challenges. Including this
     * information in a challenge may be classed as a
     *                             leak of information since potentially
     * anyone can
     *                             ask for a challenge for any user in the
     * system. On the other hand,
     *                             this information can be useful to display
     * to a user
     *                             who is trying to authenticate, and for
     * configuring
     *                             the interface where the user responds
     * to the
     *                             challenge. */
    private Boolean userInfoInChallenge;

    /* If true, challenge retention is disabled for
     *                                 GRID challenges.  This means a new
     * challenge
     *                                 will be generated for every challenge
     * request.
     *                                 Note that doing this allows an attacker
     * who
     *                                 knows part of the GRID to request
     * different
     *                                 challenges until they receive a challenge
     * that they can answer. */
    private Boolean disableChallengeRetention;

    /* Specifies the GRID challenge lifetime in
     *                                 seconds.  A value of 0 means infinite
     * lifetime.
     *                                 When requesting a challenge, if the
     * retained challenge has exceeded its lifetime
     *                                 a new challenge is generated.  When
     * authenticating a challenge, if the retained
     *                                 challenge has exceeded its lifetime
     * a
     *                                 USER_NO_CHALLENGE error is returned. */
    private Integer challengeLifetime;

    /* If true, the lockout count is updated when
     *                                 an existing GRID challenge is replaced
     * during a 
     *                                 challenge request either because challenge
     * retention is disabled or because its lifetime
     *                                 has expired.  If false, the lockout
     * count is
     *                                 not updated. The default for this
     * policy is
     *                                 true. */
    private Boolean updateLockoutForReplacedChallenge;

    /* If true, don't allow anonymous authentication
     *                             operations for users in groups assigned
     * this policy. */
    private Boolean disableAnonymousAuth;

    /* Identifies the challenge generation algorithm being
     *                             used. */
    private ChallengeGenAlg challengeGenAlg;

    /* Indicates whether or not usage statistics should be
     *                             gathered. This only applies when the RANDOM
     * challenge
     *                             generation algorithm is being used; when
     * the
     *                             LEASTUSED challenge generation algorithm
     * is being
     *                             used usage statistics are always gathered
     * regardless
     *                             of this setting. */
    private Boolean gatherUsageStatistics;

    /* Indicates the minimum number of least used cells that
     *                             will be included in every generated challenge;
     * only
     *                             applies when the LEASTUSED challenge generation
     * algorithm is being used. This value must be at
     *                             least one, and cannot exceed the maximum
     * challenge
     *                             size. */
    private Integer leastUsedCellsPerChallenge;

    /* The challenge count warning threshold. Once a
     *                             card has been used to successfully answer
     * this many
     *                             challenges, the card should be replaced.
     * When a
     *                             card that has reached this threshold is
     * used for an
     *                             authentication, a warning message will
     * be generated
     *                             in the logs.
     *                             <p>
     *                             This value must be at least one, and not
     * exceed
     *                             challengeCountReplacementThreshold. */
    private Integer challengeCountWarningThreshold;

    /* The challenge count replacement threshold. Once this
     *                             many challenges have been reached the
     * card will
     *                             automatically be moved to the HOLD state
     * and
     *                             must be replaced.
     *                             <p>
     *                             This value must be at least challengeCountWarningThreshold. */
    private Integer challengeCountReplacementThreshold;

    /* The least used cell warning threshold. Once the
     *                             least used cell on the card (the cell
     * that has been
     *                             used in a successful authentication the
     * least
     *                             number of times)
     *                             has been used this many times, the card
     * should be
     *                             replaced. When a card that has reached
     * this
     *                             threshold is used for an authentication,
     * a warning
     *                             message will be generated in the logs.
     * <p>
     *                             This value must be at least one, and not
     * exceed
     *                             leastUsedCellReplacementThreshold. */
    private Integer leastUsedCellWarningThreshold;

    /* The least used cell replacement threshold.
     *                             Once the least-used cell on the card has
     * been used this many times, the card will
     *                             automatically be moved to the HOLD state
     * and
     *                             must be replaced.
     *                             <p>
     *                             This value must be at least leastUsedCellWarningThreshold. */
    private Integer leastUsedCellReplacementThreshold;

    /* Optional descriptive comments. */
    private String comment;

    public CardSpecParms() {
    }

    public CardSpecParms(
           Integer numRows,
           Integer numColumns,
           Integer cellSize,
           String[] cellAlphabet,
           CellReplacement[] cellReplacements,
           Integer challengeSize,
           Integer minChallengeSize,
           Integer maxChallengeSize,
           Long lifetime,
           Long supersede,
           Boolean sortChallenge,
           Boolean userInfoInChallenge,
           Boolean disableChallengeRetention,
           Integer challengeLifetime,
           Boolean updateLockoutForReplacedChallenge,
           Boolean disableAnonymousAuth,
           ChallengeGenAlg challengeGenAlg,
           Boolean gatherUsageStatistics,
           Integer leastUsedCellsPerChallenge,
           Integer challengeCountWarningThreshold,
           Integer challengeCountReplacementThreshold,
           Integer leastUsedCellWarningThreshold,
           Integer leastUsedCellReplacementThreshold,
           String comment) {
           this.numRows = numRows;
           this.numColumns = numColumns;
           this.cellSize = cellSize;
           this.cellAlphabet = cellAlphabet;
           this.cellReplacements = cellReplacements;
           this.challengeSize = challengeSize;
           this.minChallengeSize = minChallengeSize;
           this.maxChallengeSize = maxChallengeSize;
           this.lifetime = lifetime;
           this.supersede = supersede;
           this.sortChallenge = sortChallenge;
           this.userInfoInChallenge = userInfoInChallenge;
           this.disableChallengeRetention = disableChallengeRetention;
           this.challengeLifetime = challengeLifetime;
           this.updateLockoutForReplacedChallenge = updateLockoutForReplacedChallenge;
           this.disableAnonymousAuth = disableAnonymousAuth;
           this.challengeGenAlg = challengeGenAlg;
           this.gatherUsageStatistics = gatherUsageStatistics;
           this.leastUsedCellsPerChallenge = leastUsedCellsPerChallenge;
           this.challengeCountWarningThreshold = challengeCountWarningThreshold;
           this.challengeCountReplacementThreshold = challengeCountReplacementThreshold;
           this.leastUsedCellWarningThreshold = leastUsedCellWarningThreshold;
           this.leastUsedCellReplacementThreshold = leastUsedCellReplacementThreshold;
           this.comment = comment;
    }


    /**
     * Gets the numRows value for this CardSpecParms.
     * 
     * @return numRows   * The number of rows in the card. Must be at least 1,
     *                             and the product of
     *                             numRows and numColumns must not exceed
     * one million.
     */
    public Integer getNumRows() {
        return numRows;
    }


    /**
     * Sets the numRows value for this CardSpecParms.
     * 
     * @param numRows   * The number of rows in the card. Must be at least 1,
     *                             and the product of
     *                             numRows and numColumns must not exceed
     * one million.
     */
    public void setNumRows(Integer numRows) {
        this.numRows = numRows;
    }


    /**
     * Gets the numColumns value for this CardSpecParms.
     * 
     * @return numColumns   * The number of columns in the card. Must be at least
     *                             1, and the product of
     *                             numRows and numColumns must not exceed
     * one million.
     */
    public Integer getNumColumns() {
        return numColumns;
    }


    /**
     * Sets the numColumns value for this CardSpecParms.
     * 
     * @param numColumns   * The number of columns in the card. Must be at least
     *                             1, and the product of
     *                             numRows and numColumns must not exceed
     * one million.
     */
    public void setNumColumns(Integer numColumns) {
        this.numColumns = numColumns;
    }


    /**
     * Gets the cellSize value for this CardSpecParms.
     * 
     * @return cellSize   * The number of characters in each cell. This must be
     *                             at least 1 and at most 20.
     */
    public Integer getCellSize() {
        return cellSize;
    }


    /**
     * Sets the cellSize value for this CardSpecParms.
     * 
     * @param cellSize   * The number of characters in each cell. This must be
     *                             at least 1 and at most 20.
     */
    public void setCellSize(Integer cellSize) {
        this.cellSize = cellSize;
    }


    /**
     * Gets the cellAlphabet value for this CardSpecParms.
     * 
     * @return cellAlphabet   * The characters that can appear in a cell.
     */
    public String[] getCellAlphabet() {
        return cellAlphabet;
    }


    /**
     * Sets the cellAlphabet value for this CardSpecParms.
     * 
     * @param cellAlphabet   * The characters that can appear in a cell.
     */
    public void setCellAlphabet(String[] cellAlphabet) {
        this.cellAlphabet = cellAlphabet;
    }


    /**
     * Gets the cellReplacements value for this CardSpecParms.
     * 
     * @return cellReplacements   * A list of characters that are replaced in a challenge
     *                             response before it is validated. This
     * can be used
     *                             to make challenge validation case-insensitive,
     * or
     *                             to make many similar-looking characters
     * such as '1',
     *                             'l', and 'I' all be treated as the same
     * character during
     *                             validation.
     */
    public CellReplacement[] getCellReplacements() {
        return cellReplacements;
    }


    /**
     * Sets the cellReplacements value for this CardSpecParms.
     * 
     * @param cellReplacements   * A list of characters that are replaced in a challenge
     *                             response before it is validated. This
     * can be used
     *                             to make challenge validation case-insensitive,
     * or
     *                             to make many similar-looking characters
     * such as '1',
     *                             'l', and 'I' all be treated as the same
     * character during
     *                             validation.
     */
    public void setCellReplacements(CellReplacement[] cellReplacements) {
        this.cellReplacements = cellReplacements;
    }


    /**
     * Gets the challengeSize value for this CardSpecParms.
     * 
     * @return challengeSize   * The size of the challenge. The challenge size must
     *                             obey the following constraint:
     *                             1 <= minChallengeSize <= challengeSize
     * <= maxChallengeSize <= numRows * numColumns
     */
    public Integer getChallengeSize() {
        return challengeSize;
    }


    /**
     * Sets the challengeSize value for this CardSpecParms.
     * 
     * @param challengeSize   * The size of the challenge. The challenge size must
     *                             obey the following constraint:
     *                             1 <= minChallengeSize <= challengeSize
     * <= maxChallengeSize <= numRows * numColumns
     */
    public void setChallengeSize(Integer challengeSize) {
        this.challengeSize = challengeSize;
    }


    /**
     * Gets the minChallengeSize value for this CardSpecParms.
     * 
     * @return minChallengeSize   * The minimum size of the challenge. Used to validate
     *                             the size when the call to obtain a challenge
     * specifies an explicit size. This must obey 
     *                             the following constraint:
     *                             1 <= minChallengeSize <= challengeSize
     * <= maxChallengeSize <= numRows * numColumns
     */
    public Integer getMinChallengeSize() {
        return minChallengeSize;
    }


    /**
     * Sets the minChallengeSize value for this CardSpecParms.
     * 
     * @param minChallengeSize   * The minimum size of the challenge. Used to validate
     *                             the size when the call to obtain a challenge
     * specifies an explicit size. This must obey 
     *                             the following constraint:
     *                             1 <= minChallengeSize <= challengeSize
     * <= maxChallengeSize <= numRows * numColumns
     */
    public void setMinChallengeSize(Integer minChallengeSize) {
        this.minChallengeSize = minChallengeSize;
    }


    /**
     * Gets the maxChallengeSize value for this CardSpecParms.
     * 
     * @return maxChallengeSize   * The maximum size of the challenge. Used to validate
     *                             the size when the call to obtain a challenge
     * specifies an explicit size. This must obey 
     *                             the following constraint:
     *                             1 <= minChallengeSize <= challengeSize
     * <= maxChallengeSize <= numRows * numColumns
     */
    public Integer getMaxChallengeSize() {
        return maxChallengeSize;
    }


    /**
     * Sets the maxChallengeSize value for this CardSpecParms.
     * 
     * @param maxChallengeSize   * The maximum size of the challenge. Used to validate
     *                             the size when the call to obtain a challenge
     * specifies an explicit size. This must obey 
     *                             the following constraint:
     *                             1 <= minChallengeSize <= challengeSize
     * <= maxChallengeSize <= numRows * numColumns
     */
    public void setMaxChallengeSize(Integer maxChallengeSize) {
        this.maxChallengeSize = maxChallengeSize;
    }


    /**
     * Gets the lifetime value for this CardSpecParms.
     * 
     * @return lifetime   * The lifetime in days of a card created using this policy.
     *                             This value must be at least 0 and at most
     * 36500.
     *                             A value of 0 indicates that cards have
     * infinite lifetime.
     */
    public Long getLifetime() {
        return lifetime;
    }


    /**
     * Sets the lifetime value for this CardSpecParms.
     * 
     * @param lifetime   * The lifetime in days of a card created using this policy.
     *                             This value must be at least 0 and at most
     * 36500.
     *                             A value of 0 indicates that cards have
     * infinite lifetime.
     */
    public void setLifetime(Long lifetime) {
        this.lifetime = lifetime;
    }


    /**
     * Gets the supersede value for this CardSpecParms.
     * 
     * @return supersede   * The amount of time in days that a superseded
     *                             card can be used after it is superseded.
     * This value must be at least 0 and at most 36500.
     *                             A value of 0 indicates that superseded
     * cards can be used indefinitely.
     */
    public Long getSupersede() {
        return supersede;
    }


    /**
     * Sets the supersede value for this CardSpecParms.
     * 
     * @param supersede   * The amount of time in days that a superseded
     *                             card can be used after it is superseded.
     * This value must be at least 0 and at most 36500.
     *                             A value of 0 indicates that superseded
     * cards can be used indefinitely.
     */
    public void setSupersede(Long supersede) {
        this.supersede = supersede;
    }


    /**
     * Gets the sortChallenge value for this CardSpecParms.
     * 
     * @return sortChallenge   * If true, challenges are sorted by column/row after
     *                             generation. Challenges sorted in this
     * way are
     *                             easier for a person to respond to.
     */
    public Boolean getSortChallenge() {
        return sortChallenge;
    }


    /**
     * Sets the sortChallenge value for this CardSpecParms.
     * 
     * @param sortChallenge   * If true, challenges are sorted by column/row after
     *                             generation. Challenges sorted in this
     * way are
     *                             easier for a person to respond to.
     */
    public void setSortChallenge(Boolean sortChallenge) {
        this.sortChallenge = sortChallenge;
    }


    /**
     * Gets the userInfoInChallenge value for this CardSpecParms.
     * 
     * @return userInfoInChallenge   * If false, don't include the hasPin flag or serial
     *                             number list in challenges. Including this
     * information in a challenge may be classed as a
     *                             leak of information since potentially
     * anyone can
     *                             ask for a challenge for any user in the
     * system. On the other hand,
     *                             this information can be useful to display
     * to a user
     *                             who is trying to authenticate, and for
     * configuring
     *                             the interface where the user responds
     * to the
     *                             challenge.
     */
    public Boolean getUserInfoInChallenge() {
        return userInfoInChallenge;
    }


    /**
     * Sets the userInfoInChallenge value for this CardSpecParms.
     * 
     * @param userInfoInChallenge   * If false, don't include the hasPin flag or serial
     *                             number list in challenges. Including this
     * information in a challenge may be classed as a
     *                             leak of information since potentially
     * anyone can
     *                             ask for a challenge for any user in the
     * system. On the other hand,
     *                             this information can be useful to display
     * to a user
     *                             who is trying to authenticate, and for
     * configuring
     *                             the interface where the user responds
     * to the
     *                             challenge.
     */
    public void setUserInfoInChallenge(Boolean userInfoInChallenge) {
        this.userInfoInChallenge = userInfoInChallenge;
    }


    /**
     * Gets the disableChallengeRetention value for this CardSpecParms.
     * 
     * @return disableChallengeRetention   * If true, challenge retention is disabled for
     *                                 GRID challenges.  This means a new
     * challenge
     *                                 will be generated for every challenge
     * request.
     *                                 Note that doing this allows an attacker
     * who
     *                                 knows part of the GRID to request
     * different
     *                                 challenges until they receive a challenge
     * that they can answer.
     */
    public Boolean getDisableChallengeRetention() {
        return disableChallengeRetention;
    }


    /**
     * Sets the disableChallengeRetention value for this CardSpecParms.
     * 
     * @param disableChallengeRetention   * If true, challenge retention is disabled for
     *                                 GRID challenges.  This means a new
     * challenge
     *                                 will be generated for every challenge
     * request.
     *                                 Note that doing this allows an attacker
     * who
     *                                 knows part of the GRID to request
     * different
     *                                 challenges until they receive a challenge
     * that they can answer.
     */
    public void setDisableChallengeRetention(Boolean disableChallengeRetention) {
        this.disableChallengeRetention = disableChallengeRetention;
    }


    /**
     * Gets the challengeLifetime value for this CardSpecParms.
     * 
     * @return challengeLifetime   * Specifies the GRID challenge lifetime in
     *                                 seconds.  A value of 0 means infinite
     * lifetime.
     *                                 When requesting a challenge, if the
     * retained challenge has exceeded its lifetime
     *                                 a new challenge is generated.  When
     * authenticating a challenge, if the retained
     *                                 challenge has exceeded its lifetime
     * a
     *                                 USER_NO_CHALLENGE error is returned.
     */
    public Integer getChallengeLifetime() {
        return challengeLifetime;
    }


    /**
     * Sets the challengeLifetime value for this CardSpecParms.
     * 
     * @param challengeLifetime   * Specifies the GRID challenge lifetime in
     *                                 seconds.  A value of 0 means infinite
     * lifetime.
     *                                 When requesting a challenge, if the
     * retained challenge has exceeded its lifetime
     *                                 a new challenge is generated.  When
     * authenticating a challenge, if the retained
     *                                 challenge has exceeded its lifetime
     * a
     *                                 USER_NO_CHALLENGE error is returned.
     */
    public void setChallengeLifetime(Integer challengeLifetime) {
        this.challengeLifetime = challengeLifetime;
    }


    /**
     * Gets the updateLockoutForReplacedChallenge value for this CardSpecParms.
     * 
     * @return updateLockoutForReplacedChallenge   * If true, the lockout count is updated when
     *                                 an existing GRID challenge is replaced
     * during a 
     *                                 challenge request either because challenge
     * retention is disabled or because its lifetime
     *                                 has expired.  If false, the lockout
     * count is
     *                                 not updated. The default for this
     * policy is
     *                                 true.
     */
    public Boolean getUpdateLockoutForReplacedChallenge() {
        return updateLockoutForReplacedChallenge;
    }


    /**
     * Sets the updateLockoutForReplacedChallenge value for this CardSpecParms.
     * 
     * @param updateLockoutForReplacedChallenge   * If true, the lockout count is updated when
     *                                 an existing GRID challenge is replaced
     * during a 
     *                                 challenge request either because challenge
     * retention is disabled or because its lifetime
     *                                 has expired.  If false, the lockout
     * count is
     *                                 not updated. The default for this
     * policy is
     *                                 true.
     */
    public void setUpdateLockoutForReplacedChallenge(Boolean updateLockoutForReplacedChallenge) {
        this.updateLockoutForReplacedChallenge = updateLockoutForReplacedChallenge;
    }


    /**
     * Gets the disableAnonymousAuth value for this CardSpecParms.
     * 
     * @return disableAnonymousAuth   * If true, don't allow anonymous authentication
     *                             operations for users in groups assigned
     * this policy.
     */
    public Boolean getDisableAnonymousAuth() {
        return disableAnonymousAuth;
    }


    /**
     * Sets the disableAnonymousAuth value for this CardSpecParms.
     * 
     * @param disableAnonymousAuth   * If true, don't allow anonymous authentication
     *                             operations for users in groups assigned
     * this policy.
     */
    public void setDisableAnonymousAuth(Boolean disableAnonymousAuth) {
        this.disableAnonymousAuth = disableAnonymousAuth;
    }


    /**
     * Gets the challengeGenAlg value for this CardSpecParms.
     * 
     * @return challengeGenAlg   * Identifies the challenge generation algorithm being
     *                             used.
     */
    public ChallengeGenAlg getChallengeGenAlg() {
        return challengeGenAlg;
    }


    /**
     * Sets the challengeGenAlg value for this CardSpecParms.
     * 
     * @param challengeGenAlg   * Identifies the challenge generation algorithm being
     *                             used.
     */
    public void setChallengeGenAlg(ChallengeGenAlg challengeGenAlg) {
        this.challengeGenAlg = challengeGenAlg;
    }


    /**
     * Gets the gatherUsageStatistics value for this CardSpecParms.
     * 
     * @return gatherUsageStatistics   * Indicates whether or not usage statistics should be
     *                             gathered. This only applies when the RANDOM
     * challenge
     *                             generation algorithm is being used; when
     * the
     *                             LEASTUSED challenge generation algorithm
     * is being
     *                             used usage statistics are always gathered
     * regardless
     *                             of this setting.
     */
    public Boolean getGatherUsageStatistics() {
        return gatherUsageStatistics;
    }


    /**
     * Sets the gatherUsageStatistics value for this CardSpecParms.
     * 
     * @param gatherUsageStatistics   * Indicates whether or not usage statistics should be
     *                             gathered. This only applies when the RANDOM
     * challenge
     *                             generation algorithm is being used; when
     * the
     *                             LEASTUSED challenge generation algorithm
     * is being
     *                             used usage statistics are always gathered
     * regardless
     *                             of this setting.
     */
    public void setGatherUsageStatistics(Boolean gatherUsageStatistics) {
        this.gatherUsageStatistics = gatherUsageStatistics;
    }


    /**
     * Gets the leastUsedCellsPerChallenge value for this CardSpecParms.
     * 
     * @return leastUsedCellsPerChallenge   * Indicates the minimum number of least used cells that
     *                             will be included in every generated challenge;
     * only
     *                             applies when the LEASTUSED challenge generation
     * algorithm is being used. This value must be at
     *                             least one, and cannot exceed the maximum
     * challenge
     *                             size.
     */
    public Integer getLeastUsedCellsPerChallenge() {
        return leastUsedCellsPerChallenge;
    }


    /**
     * Sets the leastUsedCellsPerChallenge value for this CardSpecParms.
     * 
     * @param leastUsedCellsPerChallenge   * Indicates the minimum number of least used cells that
     *                             will be included in every generated challenge;
     * only
     *                             applies when the LEASTUSED challenge generation
     * algorithm is being used. This value must be at
     *                             least one, and cannot exceed the maximum
     * challenge
     *                             size.
     */
    public void setLeastUsedCellsPerChallenge(Integer leastUsedCellsPerChallenge) {
        this.leastUsedCellsPerChallenge = leastUsedCellsPerChallenge;
    }


    /**
     * Gets the challengeCountWarningThreshold value for this CardSpecParms.
     * 
     * @return challengeCountWarningThreshold   * The challenge count warning threshold. Once a
     *                             card has been used to successfully answer
     * this many
     *                             challenges, the card should be replaced.
     * When a
     *                             card that has reached this threshold is
     * used for an
     *                             authentication, a warning message will
     * be generated
     *                             in the logs.
     *                             <p>
     *                             This value must be at least one, and not
     * exceed
     *                             challengeCountReplacementThreshold.
     */
    public Integer getChallengeCountWarningThreshold() {
        return challengeCountWarningThreshold;
    }


    /**
     * Sets the challengeCountWarningThreshold value for this CardSpecParms.
     * 
     * @param challengeCountWarningThreshold   * The challenge count warning threshold. Once a
     *                             card has been used to successfully answer
     * this many
     *                             challenges, the card should be replaced.
     * When a
     *                             card that has reached this threshold is
     * used for an
     *                             authentication, a warning message will
     * be generated
     *                             in the logs.
     *                             <p>
     *                             This value must be at least one, and not
     * exceed
     *                             challengeCountReplacementThreshold.
     */
    public void setChallengeCountWarningThreshold(Integer challengeCountWarningThreshold) {
        this.challengeCountWarningThreshold = challengeCountWarningThreshold;
    }


    /**
     * Gets the challengeCountReplacementThreshold value for this CardSpecParms.
     * 
     * @return challengeCountReplacementThreshold   * The challenge count replacement threshold. Once this
     *                             many challenges have been reached the
     * card will
     *                             automatically be moved to the HOLD state
     * and
     *                             must be replaced.
     *                             <p>
     *                             This value must be at least challengeCountWarningThreshold.
     */
    public Integer getChallengeCountReplacementThreshold() {
        return challengeCountReplacementThreshold;
    }


    /**
     * Sets the challengeCountReplacementThreshold value for this CardSpecParms.
     * 
     * @param challengeCountReplacementThreshold   * The challenge count replacement threshold. Once this
     *                             many challenges have been reached the
     * card will
     *                             automatically be moved to the HOLD state
     * and
     *                             must be replaced.
     *                             <p>
     *                             This value must be at least challengeCountWarningThreshold.
     */
    public void setChallengeCountReplacementThreshold(Integer challengeCountReplacementThreshold) {
        this.challengeCountReplacementThreshold = challengeCountReplacementThreshold;
    }


    /**
     * Gets the leastUsedCellWarningThreshold value for this CardSpecParms.
     * 
     * @return leastUsedCellWarningThreshold   * The least used cell warning threshold. Once the
     *                             least used cell on the card (the cell
     * that has been
     *                             used in a successful authentication the
     * least
     *                             number of times)
     *                             has been used this many times, the card
     * should be
     *                             replaced. When a card that has reached
     * this
     *                             threshold is used for an authentication,
     * a warning
     *                             message will be generated in the logs.
     * <p>
     *                             This value must be at least one, and not
     * exceed
     *                             leastUsedCellReplacementThreshold.
     */
    public Integer getLeastUsedCellWarningThreshold() {
        return leastUsedCellWarningThreshold;
    }


    /**
     * Sets the leastUsedCellWarningThreshold value for this CardSpecParms.
     * 
     * @param leastUsedCellWarningThreshold   * The least used cell warning threshold. Once the
     *                             least used cell on the card (the cell
     * that has been
     *                             used in a successful authentication the
     * least
     *                             number of times)
     *                             has been used this many times, the card
     * should be
     *                             replaced. When a card that has reached
     * this
     *                             threshold is used for an authentication,
     * a warning
     *                             message will be generated in the logs.
     * <p>
     *                             This value must be at least one, and not
     * exceed
     *                             leastUsedCellReplacementThreshold.
     */
    public void setLeastUsedCellWarningThreshold(Integer leastUsedCellWarningThreshold) {
        this.leastUsedCellWarningThreshold = leastUsedCellWarningThreshold;
    }


    /**
     * Gets the leastUsedCellReplacementThreshold value for this CardSpecParms.
     * 
     * @return leastUsedCellReplacementThreshold   * The least used cell replacement threshold.
     *                             Once the least-used cell on the card has
     * been used this many times, the card will
     *                             automatically be moved to the HOLD state
     * and
     *                             must be replaced.
     *                             <p>
     *                             This value must be at least leastUsedCellWarningThreshold.
     */
    public Integer getLeastUsedCellReplacementThreshold() {
        return leastUsedCellReplacementThreshold;
    }


    /**
     * Sets the leastUsedCellReplacementThreshold value for this CardSpecParms.
     * 
     * @param leastUsedCellReplacementThreshold   * The least used cell replacement threshold.
     *                             Once the least-used cell on the card has
     * been used this many times, the card will
     *                             automatically be moved to the HOLD state
     * and
     *                             must be replaced.
     *                             <p>
     *                             This value must be at least leastUsedCellWarningThreshold.
     */
    public void setLeastUsedCellReplacementThreshold(Integer leastUsedCellReplacementThreshold) {
        this.leastUsedCellReplacementThreshold = leastUsedCellReplacementThreshold;
    }


    /**
     * Gets the comment value for this CardSpecParms.
     * 
     * @return comment   * Optional descriptive comments.
     */
    public String getComment() {
        return comment;
    }


    /**
     * Sets the comment value for this CardSpecParms.
     * 
     * @param comment   * Optional descriptive comments.
     */
    public void setComment(String comment) {
        this.comment = comment;
    }

    private Object __equalsCalc = null;
    public synchronized boolean equals(Object obj) {
        if (!(obj instanceof CardSpecParms)) return false;
        CardSpecParms other = (CardSpecParms) obj;
        if (obj == null) return false;
        if (this == obj) return true;
        if (__equalsCalc != null) {
            return (__equalsCalc == obj);
        }
        __equalsCalc = obj;
        boolean _equals;
        _equals = true && 
            ((this.numRows==null && other.getNumRows()==null) || 
             (this.numRows!=null &&
              this.numRows.equals(other.getNumRows()))) &&
            ((this.numColumns==null && other.getNumColumns()==null) || 
             (this.numColumns!=null &&
              this.numColumns.equals(other.getNumColumns()))) &&
            ((this.cellSize==null && other.getCellSize()==null) || 
             (this.cellSize!=null &&
              this.cellSize.equals(other.getCellSize()))) &&
            ((this.cellAlphabet==null && other.getCellAlphabet()==null) || 
             (this.cellAlphabet!=null &&
              java.util.Arrays.equals(this.cellAlphabet, other.getCellAlphabet()))) &&
            ((this.cellReplacements==null && other.getCellReplacements()==null) || 
             (this.cellReplacements!=null &&
              java.util.Arrays.equals(this.cellReplacements, other.getCellReplacements()))) &&
            ((this.challengeSize==null && other.getChallengeSize()==null) || 
             (this.challengeSize!=null &&
              this.challengeSize.equals(other.getChallengeSize()))) &&
            ((this.minChallengeSize==null && other.getMinChallengeSize()==null) || 
             (this.minChallengeSize!=null &&
              this.minChallengeSize.equals(other.getMinChallengeSize()))) &&
            ((this.maxChallengeSize==null && other.getMaxChallengeSize()==null) || 
             (this.maxChallengeSize!=null &&
              this.maxChallengeSize.equals(other.getMaxChallengeSize()))) &&
            ((this.lifetime==null && other.getLifetime()==null) || 
             (this.lifetime!=null &&
              this.lifetime.equals(other.getLifetime()))) &&
            ((this.supersede==null && other.getSupersede()==null) || 
             (this.supersede!=null &&
              this.supersede.equals(other.getSupersede()))) &&
            ((this.sortChallenge==null && other.getSortChallenge()==null) || 
             (this.sortChallenge!=null &&
              this.sortChallenge.equals(other.getSortChallenge()))) &&
            ((this.userInfoInChallenge==null && other.getUserInfoInChallenge()==null) || 
             (this.userInfoInChallenge!=null &&
              this.userInfoInChallenge.equals(other.getUserInfoInChallenge()))) &&
            ((this.disableChallengeRetention==null && other.getDisableChallengeRetention()==null) || 
             (this.disableChallengeRetention!=null &&
              this.disableChallengeRetention.equals(other.getDisableChallengeRetention()))) &&
            ((this.challengeLifetime==null && other.getChallengeLifetime()==null) || 
             (this.challengeLifetime!=null &&
              this.challengeLifetime.equals(other.getChallengeLifetime()))) &&
            ((this.updateLockoutForReplacedChallenge==null && other.getUpdateLockoutForReplacedChallenge()==null) || 
             (this.updateLockoutForReplacedChallenge!=null &&
              this.updateLockoutForReplacedChallenge.equals(other.getUpdateLockoutForReplacedChallenge()))) &&
            ((this.disableAnonymousAuth==null && other.getDisableAnonymousAuth()==null) || 
             (this.disableAnonymousAuth!=null &&
              this.disableAnonymousAuth.equals(other.getDisableAnonymousAuth()))) &&
            ((this.challengeGenAlg==null && other.getChallengeGenAlg()==null) || 
             (this.challengeGenAlg!=null &&
              this.challengeGenAlg.equals(other.getChallengeGenAlg()))) &&
            ((this.gatherUsageStatistics==null && other.getGatherUsageStatistics()==null) || 
             (this.gatherUsageStatistics!=null &&
              this.gatherUsageStatistics.equals(other.getGatherUsageStatistics()))) &&
            ((this.leastUsedCellsPerChallenge==null && other.getLeastUsedCellsPerChallenge()==null) || 
             (this.leastUsedCellsPerChallenge!=null &&
              this.leastUsedCellsPerChallenge.equals(other.getLeastUsedCellsPerChallenge()))) &&
            ((this.challengeCountWarningThreshold==null && other.getChallengeCountWarningThreshold()==null) || 
             (this.challengeCountWarningThreshold!=null &&
              this.challengeCountWarningThreshold.equals(other.getChallengeCountWarningThreshold()))) &&
            ((this.challengeCountReplacementThreshold==null && other.getChallengeCountReplacementThreshold()==null) || 
             (this.challengeCountReplacementThreshold!=null &&
              this.challengeCountReplacementThreshold.equals(other.getChallengeCountReplacementThreshold()))) &&
            ((this.leastUsedCellWarningThreshold==null && other.getLeastUsedCellWarningThreshold()==null) || 
             (this.leastUsedCellWarningThreshold!=null &&
              this.leastUsedCellWarningThreshold.equals(other.getLeastUsedCellWarningThreshold()))) &&
            ((this.leastUsedCellReplacementThreshold==null && other.getLeastUsedCellReplacementThreshold()==null) || 
             (this.leastUsedCellReplacementThreshold!=null &&
              this.leastUsedCellReplacementThreshold.equals(other.getLeastUsedCellReplacementThreshold()))) &&
            ((this.comment==null && other.getComment()==null) || 
             (this.comment!=null &&
              this.comment.equals(other.getComment())));
        __equalsCalc = null;
        return _equals;
    }

    private boolean __hashCodeCalc = false;
    public synchronized int hashCode() {
        if (__hashCodeCalc) {
            return 0;
        }
        __hashCodeCalc = true;
        int _hashCode = 1;
        if (getNumRows() != null) {
            _hashCode += getNumRows().hashCode();
        }
        if (getNumColumns() != null) {
            _hashCode += getNumColumns().hashCode();
        }
        if (getCellSize() != null) {
            _hashCode += getCellSize().hashCode();
        }
        if (getCellAlphabet() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getCellAlphabet());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getCellAlphabet(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getCellReplacements() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getCellReplacements());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getCellReplacements(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getChallengeSize() != null) {
            _hashCode += getChallengeSize().hashCode();
        }
        if (getMinChallengeSize() != null) {
            _hashCode += getMinChallengeSize().hashCode();
        }
        if (getMaxChallengeSize() != null) {
            _hashCode += getMaxChallengeSize().hashCode();
        }
        if (getLifetime() != null) {
            _hashCode += getLifetime().hashCode();
        }
        if (getSupersede() != null) {
            _hashCode += getSupersede().hashCode();
        }
        if (getSortChallenge() != null) {
            _hashCode += getSortChallenge().hashCode();
        }
        if (getUserInfoInChallenge() != null) {
            _hashCode += getUserInfoInChallenge().hashCode();
        }
        if (getDisableChallengeRetention() != null) {
            _hashCode += getDisableChallengeRetention().hashCode();
        }
        if (getChallengeLifetime() != null) {
            _hashCode += getChallengeLifetime().hashCode();
        }
        if (getUpdateLockoutForReplacedChallenge() != null) {
            _hashCode += getUpdateLockoutForReplacedChallenge().hashCode();
        }
        if (getDisableAnonymousAuth() != null) {
            _hashCode += getDisableAnonymousAuth().hashCode();
        }
        if (getChallengeGenAlg() != null) {
            _hashCode += getChallengeGenAlg().hashCode();
        }
        if (getGatherUsageStatistics() != null) {
            _hashCode += getGatherUsageStatistics().hashCode();
        }
        if (getLeastUsedCellsPerChallenge() != null) {
            _hashCode += getLeastUsedCellsPerChallenge().hashCode();
        }
        if (getChallengeCountWarningThreshold() != null) {
            _hashCode += getChallengeCountWarningThreshold().hashCode();
        }
        if (getChallengeCountReplacementThreshold() != null) {
            _hashCode += getChallengeCountReplacementThreshold().hashCode();
        }
        if (getLeastUsedCellWarningThreshold() != null) {
            _hashCode += getLeastUsedCellWarningThreshold().hashCode();
        }
        if (getLeastUsedCellReplacementThreshold() != null) {
            _hashCode += getLeastUsedCellReplacementThreshold().hashCode();
        }
        if (getComment() != null) {
            _hashCode += getComment().hashCode();
        }
        __hashCodeCalc = false;
        return _hashCode;
    }

    // Type metadata
    private static org.apache.axis.description.TypeDesc typeDesc =
        new org.apache.axis.description.TypeDesc(CardSpecParms.class, true);

    static {
        typeDesc.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "CardSpecParms"));
        org.apache.axis.description.ElementDesc elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("numRows");
        elemField.setXmlName(new javax.xml.namespace.QName("", "numRows"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("numColumns");
        elemField.setXmlName(new javax.xml.namespace.QName("", "numColumns"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("cellSize");
        elemField.setXmlName(new javax.xml.namespace.QName("", "cellSize"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("cellAlphabet");
        elemField.setXmlName(new javax.xml.namespace.QName("", "cellAlphabet"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("cellReplacements");
        elemField.setXmlName(new javax.xml.namespace.QName("", "cellReplacements"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "CellReplacement"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("challengeSize");
        elemField.setXmlName(new javax.xml.namespace.QName("", "challengeSize"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("minChallengeSize");
        elemField.setXmlName(new javax.xml.namespace.QName("", "minChallengeSize"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxChallengeSize");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxChallengeSize"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("lifetime");
        elemField.setXmlName(new javax.xml.namespace.QName("", "lifetime"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "long"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("supersede");
        elemField.setXmlName(new javax.xml.namespace.QName("", "supersede"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "long"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("sortChallenge");
        elemField.setXmlName(new javax.xml.namespace.QName("", "sortChallenge"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("userInfoInChallenge");
        elemField.setXmlName(new javax.xml.namespace.QName("", "userInfoInChallenge"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("disableChallengeRetention");
        elemField.setXmlName(new javax.xml.namespace.QName("", "disableChallengeRetention"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("challengeLifetime");
        elemField.setXmlName(new javax.xml.namespace.QName("", "challengeLifetime"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("updateLockoutForReplacedChallenge");
        elemField.setXmlName(new javax.xml.namespace.QName("", "updateLockoutForReplacedChallenge"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("disableAnonymousAuth");
        elemField.setXmlName(new javax.xml.namespace.QName("", "disableAnonymousAuth"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("challengeGenAlg");
        elemField.setXmlName(new javax.xml.namespace.QName("", "challengeGenAlg"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "ChallengeGenAlg"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("gatherUsageStatistics");
        elemField.setXmlName(new javax.xml.namespace.QName("", "gatherUsageStatistics"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("leastUsedCellsPerChallenge");
        elemField.setXmlName(new javax.xml.namespace.QName("", "leastUsedCellsPerChallenge"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("challengeCountWarningThreshold");
        elemField.setXmlName(new javax.xml.namespace.QName("", "challengeCountWarningThreshold"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("challengeCountReplacementThreshold");
        elemField.setXmlName(new javax.xml.namespace.QName("", "challengeCountReplacementThreshold"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("leastUsedCellWarningThreshold");
        elemField.setXmlName(new javax.xml.namespace.QName("", "leastUsedCellWarningThreshold"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("leastUsedCellReplacementThreshold");
        elemField.setXmlName(new javax.xml.namespace.QName("", "leastUsedCellReplacementThreshold"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("comment");
        elemField.setXmlName(new javax.xml.namespace.QName("", "comment"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
    }

    /**
     * Return type metadata object
     */
    public static org.apache.axis.description.TypeDesc getTypeDesc() {
        return typeDesc;
    }

    /**
     * Get Custom Serializer
     */
    public static org.apache.axis.encoding.Serializer getSerializer(
           String mechType,
           Class _javaType,
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanSerializer(
            _javaType, _xmlType, typeDesc);
    }

    /**
     * Get Custom Deserializer
     */
    public static org.apache.axis.encoding.Deserializer getDeserializer(
           String mechType,
           Class _javaType,
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanDeserializer(
            _javaType, _xmlType, typeDesc);
    }

}
