/**
 * AdminService_PortType.java
 *
 * This file was auto-generated from WSDL
 * by the Apache Axis 1.4 Apr 22, 2006 (06:55:48 PDT) WSDL2Java emitter.
 */

package com.good.adapters.entrust.stubs;

public interface AdminService_PortType extends java.rmi.Remote {

    /**
     * Login to the Administration service, returning a response
     *                 indicating if the login is complete or a second
     *                 factor of authentication is required. This is the
     * first call that
     *                 must be made before any other operations are permitted.
     * To log
     *                 in, a valid user ID and password must be supplied,
     * and the user
     *                 must have been assigned an administrative role to
     * make them
     *                 an administrator.
     *                 <p>
     *                 If the user's password requires updating, this call
     * will not
     *                 log the user in, and will instead result in an AdminPasswordChangeRequiredFault.
     * If this happens, a new password for the user should be obtained,
     *                 then the changePassword operation should be called,
     * which will change the password and perform the login at the
     *                 same time.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with an INVALID_USERID_PASSWORD error code,
     * if either
     *                 the user ID or password given during login are invalid.
     * 2. A fault with an ADMIN_LOCKED error code, if the caller has
     *                 entered the wrong user ID and password too many times,
     * and is
     *                 locked out.
     *                 3. A fault with an LOGIN_FAILED_ADMIN_LOCKED error
     * code, if the
     *                 caller has now entered the wrong user ID and password
     * too many
     *                 times, causing the administrator account to be locked
     * out.
     *                 Subsequent calls with the same user ID and password
     * will return
     *                 a fault with an ADMIN_LOCKED error code.
     */
    public LoginResult login(LoginCallParms parms) throws java.rmi.RemoteException, AdminServiceFault, com.good.adapters.entrust.stubs.AdminPasswordChangeRequiredFault;

    /**
     * Logout from the Administration service.
     */
    public void logout() throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Change the password for the administrator ID specified in the
     * parameters.
     *                 Other than login, this is the one request that doesn't
     * require that
     *                 the administrator be logged in already.  After this
     * command
     *                 successfully completes, the administrator will be
     * logged in.
     *                 <p>
     *                 If second factor authentication is required, the second
     * call to this operation
     *                 must include the response to the challenge issued
     * in the first call,
     *                 and the new password must be specified in both calls.
     * 
     *                 
     * @return a response indicating if the operation is complete or
     *                 a second factor of authentication is required.
     */
    public LoginResult changePassword(com.good.adapters.entrust.stubs.ChangePasswordCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Ping the Entrust IdentityGuard Server so that its idle timer
     * doesn't expire.  An administrator must be logged in to call
     *                 this method.
     *                 <p>
     *                 This call is not restricted by role permissions.
     *                 <p>
     *                 Any parameters passed to this call are ignored, but
     * null is not
     *                 an acceptable value. A zero-length array is acceptable.
     */
    public void keepAlive(NameValue[] parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Ping the Entrust IdentityGuard Administration Service to see
     * if
     *                 it is alive.  An administrator does not have to be
     * logged in to
     *                 call this method.
     *                 <p>
     *                 This call is not restricted by role permissions.
     *                 <p>
     *                 Any parameters passed to this call are ignored, but
     * null is not
     *                 an acceptable value. A zero-length array is acceptable.
     */
    public void ping(NameValue[] parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Retrieves the system license information, detailing how many
     * users are currently in the system, the maximum number of users,
     *                 and the license expiry date.
     *                 <p>
     *                 Callers of this operation must have a role with the
     * licenseGet
     *                 permission.
     *                 <p>
     *                 Any parameters passed to this call are ignored, but
     * null is not an acceptable value. A zero-length array is acceptable.
     * <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have licenseGet permission.
     */
    public LicenseInfo licenseGet(NameValue[] parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Given an installation key and an activation key, updates the
     * system license and returns
     *                 the new license settings. This operation will not
     * allow setting
     *                 of a license that will cause the system to stop functioning,
     * for
     *                 example because the new expiry date is in the past.
     * <p>
     *                 Callers of this operation must have a role with the
     * licenseSet
     *                 permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have licenseSet permission.
     *                 2. A fault with an INVALID_LICENSE error code, if
     * the installation
     *                 or activation key are incorrect, the license is expired,
     * or the
     *                 license allows for fewer users than are currently
     * in the system.
     */
    public LicenseInfo licenseSet(LicenseSetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Given an installation key and an activation key, returns what
     * the new system license
     *                 information would be if this activation key were used,
     * but does
     *                 not actually update the system license. Instead of
     * a new
     *                 installation and activation key, the option may be
     * given to
     *                 perform a full count of the number of users in the
     * repository,
     *                 to make sure this matches the current license count.
     * <p>
     *                 Callers of this operation must have a role with the
     * licenseSet
     *                 permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have licenseSet permission.
     *                 2. A fault with an INVALID_LICENSE error code, if
     * the installation
     *                 or activation key are incorrect.
     */
    public LicenseInfo licenseCheck(LicenseCheckCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Retrieves the system's token license information, detailing
     * how many
     *                 licensed tokens are currently in the system, the maximum
     * number of licensed tokens,
     *                 and the tokens license expiry date. Tokens added to
     * the system using
     *                 userTokenCreate are considered to take up a license;
     * tokens
     *                 added using tokenLoad do not.
     *                 <p>
     *                 Callers of this operation must have a role with the
     * tokenLicenseGet
     *                 permission.
     *                 <p>
     *                 Any parameters passed to this call are ignored, but
     * null is not an acceptable value. A zero-length array is acceptable.
     * <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have tokenLicenseGet permission.
     */
    public TokenLicenseInfo tokenLicenseGet(NameValue[] parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Given an installation key and an activation key, updates the
     * system's token license and returns
     *                 the new license settings. This operation will not
     * allow setting
     *                 of a token license that will cause the system to stop
     * functioning, for
     *                 example because the new expiry date is in the past.
     * <p>
     *                 Callers of this operation must have a role with the
     * tokenLicenseSet
     *                 permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have tokenLicenseSet permission.
     *                 2. A fault with an INVALID_LICENSE error code, if
     * the installation
     *                 or activation key are incorrect, the license is expired,
     * or the
     *                 license allows for fewer tokens than are currently
     * in the system.
     */
    public TokenLicenseInfo tokenLicenseSet(com.good.adapters.entrust.stubs.TokenLicenseSetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Given an installation key and an activation key, returns what
     * the new system's token license
     *                 information would be if this activation key were used,
     * but does
     *                 not actually update the system license. Instead of
     * a new
     *                 installation and activation key, the option may be
     * given to
     *                 perform a full count of the number of licensed tokens
     * in the repository,
     *                 to make sure this matches the current license count.
     * <p>
     *                 Callers of this operation must have a role with the
     * tokenLicenseSet
     *                 permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have tokenLicenseSet permission.
     *                 2. A fault with an INVALID_LICENSE error code, if
     * the installation
     *                 or activation key are incorrect.
     */
    public TokenLicenseInfo tokenLicenseCheck(com.good.adapters.entrust.stubs.TokenLicenseCheckCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Retrieves the system's smart credential license information,
     * detailing how many
     *                 licensed smart credentials are currently in the system,
     * the maximum number of licensed smart credentials,
     *                 and the smart credentials license expiry date.
     *                 <p>
     *                 Callers of this operation must have a role with the
     * smartCredentialLicenseGet
     *                 permission.
     *                 <p>
     *                 Any parameters passed to this call are ignored, but
     * null is not an acceptable value. A zero-length array is acceptable.
     * <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have smartCredentialLicenseGet permission.
     */
    public com.good.adapters.entrust.stubs.SmartCredentialLicenseInfo smartCredentialLicenseGet(NameValue[] parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Given an installation key and an activation key, updates the
     * system's smart credential license and returns
     *                 the new license settings. This operation will not
     * allow setting
     *                 of a smart credential license that will cause the
     * system to stop functioning, for
     *                 example because the new expiry date is in the past.
     * <p>
     *                 Callers of this operation must have a role with the
     * smartCredentialLicenseSet
     *                 permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have smartCredentialLicenseSet permission.
     * 2. A fault with an INVALID_LICENSE error code, if the installation
     * or activation key are incorrect, the license is expired, or the
     *                 license allows for fewer smart credentials than are
     * currently in the system.
     */
    public com.good.adapters.entrust.stubs.SmartCredentialLicenseInfo smartCredentialLicenseSet(com.good.adapters.entrust.stubs.SmartCredentialLicenseSetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Given an installation key and an activation key, returns what
     * the new system's smart credential license
     *                 information would be if this activation key were used,
     * but does
     *                 not actually update the system license. Instead of
     * a new
     *                 installation and activation key, the option may be
     * given to
     *                 perform a full count of the number of licensed smart
     * credentials in the repository,
     *                 to make sure this matches the current license count.
     * <p>
     *                 Callers of this operation must have a role with the
     * smartCredentialLicenseSet
     *                 permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have smartCredentialLicenseSet permission.
     * 2. A fault with an INVALID_LICENSE error code, if the installation
     * or activation key are incorrect.
     */
    public com.good.adapters.entrust.stubs.SmartCredentialLicenseInfo smartCredentialLicenseCheck(com.good.adapters.entrust.stubs.SmartCredentialLicenseCheckCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Returns information about the system.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the
     *                 systemInfoGet permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if the
     * caller does
     *                 not have a role with systemInfoGet permission.
     */
    public SystemInfo systemInfoGet(NameValue[] parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Create a new partition.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the partitionCreate
     *                 permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if the
     * caller's
     *                 roles do not have the properties described above.
     *                 2. A fault with an OBJECT_EXIST error code, if a partition
     * with the
     *                 given name already exists.
     *                 3. A fault with an INVALID_ARGUMENT error code, if
     * user or
     *                 serial number ranges requested overlap with ranges
     * assigned to
     *                 an existing partition.
     */
    public void partitionCreate(com.good.adapters.entrust.stubs.PartitionCreateCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Deletes a partition. Partitions can only be
     *                 deleted before they have been used to create users
     * or cards, and
     *                 when they are not assigned to any groups. Partitions
     * that have
     *                 been used to create users or cards can never be deleted.
     * <p>
     *                 Callers of this operation must have a role that has
     * the
     *                 partitionDelete permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if the
     * caller does
     *                 not have a role with partitionDelete permission,
     *                 the partition is still assigned to a group, or if
     * the partition
     *                 has been used to create users or cards.
     *                 2. A fault with an OBJECT_NOT_EXIST error code, if
     * the partition
     *                 does not exist.
     */
    public void partitionDelete(com.good.adapters.entrust.stubs.PartitionDeleteCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Returns information about the named partition.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the
     *                 partitionGet permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if the
     * caller does
     *                 not have a role with partitionGet permission
     *                 2. A fault with an OBJECT_NOT_EXIST error code, if
     * the partition
     *                 does not exist.
     */
    public PartitionInfo partitionGet(PartitionGetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Updates a partition definition.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the
     *                 partitionSet permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have partitionSet permission.
     *                 2. A fault with an OBJECT_NOT_EXIST error code, if
     * the partition
     *                 does not exist.
     *                 3. A fault with an INVALID_ARGUMENT error code, if
     * user or
     *                 serial number ranges being added to the partition
     * overlap with
     *                 ranges assigned to an existing partition.
     */
    public void partitionSet(PartitionSetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Returns a list of all partitions defined in the system.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the
     *                 partitionList permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have partitionList permission.
     */
    public PartitionInfoList partitionList(NameValue[] parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Given an IP address in "dot" notation, such as 47.97.1.1,
     *                 return it's location.
     *                 <p>
     *                 Callers of this operation must have a role with the
     * ipLocationGet permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have ipLocationGet permission.
     *                 2. A fault with an INVALID_ARGUMENT error code, if
     * the IP
     *                 address is not valid.
     */
    public IPLocation ipLocationGet(IPLocationGetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Given a country code, return information about it.
     *                 <p>
     *                 Callers of this operation must have a role with the
     * ipLocationGet permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have ipLocationGet permission.
     *                 2. A fault with an INVALID_ARGUMENT error code, if
     * the given
     *                 country code is not recognized.
     */
    public CountryInfo countryGet(CountryGetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * List information about all countries.
     *                 <p>
     *                 Callers of this operation must have a role with the
     * ipLocationGet permission.
     *                 <p>
     *                 Any parameters passed to this call are ignored, but
     * null is not an acceptable value. A zero-length array is
     *                 acceptable.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have ipLocationGet permission.
     */
    public CountryInfo[] countryList(NameValue[] parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Given a country and region code, return information about it.
     * <p>
     *                 Callers of this operation must have a role with the
     * ipLocationGet permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have ipLocationGet permission.
     *                 2. A fault with an INVALID_ARGUMENT error code, if
     * either the
     *                 country code is incorrect or the region code for the
     * given
     *                 country is not recognized.
     */
    public RegionInfo regionGet(RegionGetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * List information about all the regions in a given country.
     *                 <p>
     *                 Callers of this operation must have a role with the
     * ipLocationGet permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have ipLocationGet permission.
     *                 2. A fault with an INVALID_ARGUMENT error code, if
     * the
     *                 country code is not recognized.
     */
    public RegionInfo[] regionList(RegionListCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Given a token vendor ID, return information about it.
     *                 <p>
     *                 Callers of this operation must have a role with the
     * tokenGet or userTokenGet permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have tokenGet or userTokenGet permission.
     * 2. A fault with an OBJECT_NOT_EXIST error code, if the
     *                 token vendor ID is not defined.
     */
    public TokenVendorInfo tokenVendorGet(com.good.adapters.entrust.stubs.TokenVendorGetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * List information about all the token vendors.
     *                 <p>
     *                 Callers of this operation must have a role with the
     * tokenGet or userTokenGet permission.
     *                 <p>
     *                 Any parameters passed to this call are ignored, but
     * null is not an acceptable value. A zero-length array is acceptable.
     * <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have tokenGet or userTokenGet permission.
     */
    public TokenVendorInfo[] tokenVendorList(NameValue[] parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Create a new policy. Any policy setting not supplied during
     * creation will be filled in with the system default for the setting.
     * <p>
     *                 Callers of this operation must have a role that has
     * the policyCreate
     *                 permission and the special "all" flag for the policy
     * list.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if the
     * caller's
     *                 roles do not have the properties described above.
     *                 2. A fault with an OBJECT_EXIST error code, if a policy
     * with the
     *                 given name already exists.
     *                 3. A fault with an INVALID_ARGUMENT error code, if
     * any of
     *                 the policy parameters are not valid.
     */
    public void policyCreate(PolicyCreateCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Delete the named policy from the Entrust IdentityGuard Server.
     * Policies may only be deleted when they are no longer assigned
     *                 to any groups, and the policy flagged as default can
     * never
     *                 be deleted. References to deleted policies are automatically
     * removed from
     *                 any role that may have granted access to them.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the policyDelete
     *                 permission and a policy list that grants access to
     * the policy being
     *                 deleted.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if the
     * caller does
     *                 not have a role with policyDelete permission, the
     * policy is
     *                 still assigned to a group, or the policy to delete
     * is the policy
     *                 flagged as default.
     *                 2. A fault with an OBJECT_NOT_EXIST error code, if
     * the policy
     *                 does not exist, or access to the policy is not permitted
     * by the criteria described above.
     */
    public void policyDelete(PolicyDeleteCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Return the named policy.
     *                 If the given name policy name is null, the policy
     * flagged as
     *                 the default is returned.
     *                 <p>
     *                 The policy is only returned if one or more of the
     * following
     *                 criteria are met:
     *                 1. The caller has a role that grants access to the
     * policy to
     *                 retrieve via the role's policy list. 2. The caller
     * has a role
     *                 that grants access to a group that has the policy
     * to retrieve as
     *                 its policy. 3. It is the policy assigned to the group
     * of 
     *                 the administrator making this call.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if the
     * policy name
     *                 is null and the caller's roles do not allow access
     * to the
     *                 policy flagged as the default.
     *                 2. A fault with an OBJECT_NOT_EXIST error code, if
     * the policy
     *                 does not exist or access to the policy is not permitted
     * by the criteria described above.
     */
    public PolicyInfo policyGet(PolicyGetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Update the named policy.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the policySet
     *                 permission and a policy list that grants access to
     * the policy being
     *                 updated.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have policySet permission.
     *                 2. A fault with an OBJECT_NOT_EXIST error code, if
     * the policy
     *                 does not exist, or access to the policy is not permitted
     * by the role criteria described above.
     *                 3. A fault with an OBJECT_EXIST error code, if the
     * policy
     *                 is being renamed but a policy with the new name already
     * exists.
     *                 4. A fault with an INVALID_ARGUMENT error code, if
     * any of
     *                 the policy parameters are not valid.
     */
    public void policySet(PolicySetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Return a list of the policies for the Entrust IdentityGuard
     * Server.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the policyList
     *                 permission, and the returned list of policies is the
     * list of all
     *                 policies that all of the caller's roles with policyList
     * permission
     *                 grant access to.
     *                 <p>
     *                 Any parameters passed to this call are ignored, but
     * null is not an acceptable value.
     *                 A zero-length array is acceptable.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have policyList permission.
     */
    public PolicyInfoList policyList(NameValue[] parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Return the named user specification policy for the Entrust
     * IdentityGuard Server.
     *                 If the given policy name is null, the policy flagged
     * as
     *                 the default is returned. Unless conserving network
     * bandwidth is
     *                 an extremely high priority, the policyGet call should
     * be used
     *                 instead of this call.
     *                 <p>
     *                 See the policyGet operation for access restrictions
     * and likely
     *                 faults.
     */
    public UserSpecInfo userSpecGet(UserSpecGetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Return the named card specification policy for the Entrust
     * IdentityGuard Sever.
     *                 If the given policy name is null, the policy flagged
     * as
     *                 the default is returned. Unless conserving network
     * bandwidth is
     *                 an extremely high priority, the policyGet call should
     * be used
     *                 instead of this call.
     *                 <p>
     *                 See the policyGet operation for access restrictions
     * and likely
     *                 faults.
     */
    public CardSpecInfo cardSpecGet(CardSpecGetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Return the named PIN policy for the Entrust IdentityGuard Server.
     * If the given policy name is null, the policy flagged as
     *                 the default is returned. Unless conserving network
     * bandwidth
     *                 is an extremely high priority, the policyGet call
     * should be used
     *                 instead of this call.
     *                 <p>
     *                 See the policyGet operation for access restrictions
     * and likely
     *                 faults.
     */
    public PINSpecInfo pinSpecGet(PinSpecGetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Return the named Password policy for the Entrust IdentityGuard
     * Server.
     *                 If the given policy name is null, the policy flagged
     * as
     *                 the default is returned. Unless conserving network
     * bandwidth is
     *                 an extremely high priority, the policyGet call should
     * be used
     *                 instead of this call.
     *                 <p>
     *                 See the policyGet operation for access restrictions
     * and likely
     *                 faults.
     */
    public PasswordRulesInfo passwordRulesGet(com.good.adapters.entrust.stubs.PasswordRulesGetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Returns all possible permissions that may appear in a permission
     * list in a role.
     *                 <p>
     *                 This call is not restricted by role permissions.
     */
    public PermissionsList permissionList(NameValue[] parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Return the role definitions for the logged in administrator.
     * <p>
     *                 This call is not restricted by role permissions.
     *                 <p>
     *                 Any parameters passed to this
     *                 call are ignored, but null is not an acceptable value.
     * A zero-length array is acceptable.
     */
    public RoleInfoList ownRoleGet(NameValue[] parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Create a new role.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the roleCreate
     *                 permission and the special "all" flags for the list
     * of policies,
     *                 groups and roles that it grants access to.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if the
     * caller's
     *                 roles do not have the properties described above.
     *                 2. A fault with an OBJECT_EXIST error code, if a role
     * with the
     *                 given name already exists.
     *                 3. A fault with an OBJECT_NOT_EXIST error code, if
     * the given
     *                 policy, group or role lists name a policy, group,
     * or role,
     *                 respectively, that does not exist.
     *                 4. A fault with an INVALID_ARGUMENT error code, if
     * any of
     *                 the permissions in the permission list are not valid,
     * or
     *                 the permissions have unsatisfied dependencies (for
     * example, if
     *                 userSet is specified without userGet).
     */
    public void roleCreate(RoleCreateCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Delete the named role from the Entrust IdentityGuard Server.
     * Roles may only be deleted when they are no longer assigned
     *                 to any users, and roles that are flagged as being
     * built-in
     *                 system roles can never be deleted. References to deleted
     * roles
     *                 are automatically removed from any other roles that
     * may have
     *                 granted access to them.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the
     *                 roleDelete permission, and a role list that grants
     * access to
     *                 the role being deleted.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if the
     * caller's
     *                 roles do not have roleDelete permission, the role
     * is still assigned
     *                 to a user, or the role to delete is a built-in system
     * role.
     *                 2. A fault with an OBJECT_NOT_EXIST error code, if
     * the role
     *                 does not exist, or access to the role is not permitted
     * by the criteria described above.
     */
    public void roleDelete(RoleDeleteCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Returns the role information for a named role.
     *                 <p>
     *                 The policy is only returned if one or more of the
     * following
     *                 criteria are met:
     *                 1. The caller has a role that grants access to the
     * role to
     *                 retrieve via the role's role list. 2. It is one of
     * the roles assigned to the administrator making this call.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with an OBJECT_NOT_EXIST error code, if
     * the role
     *                 does not exist or access to the role is not permitted
     * by the criteria described above.
     */
    public RoleInfo roleGet(RoleGetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Updates a role definition.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the roleSet
     *                 permission and the special "all" flags for the list
     * of policies,
     *                 groups and roles that it grants access to.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if the
     * caller's
     *                 roles do not have the properties described above.
     *                 2. A fault with an OBJECT_EXIST error code, if the
     * role is
     *                 being renamed and a role with the new name already
     * exists.
     *                 3. A fault with an OBJECT_NOT_EXIST error code, if
     * the role
     *                 to update does not exist, access to the role to update
     * is not
     *                 granted, or if the given
     *                 policy, group or role lists name a policy, group,
     * or role,
     *                 respectively, that does not exist.
     *                 4. A fault with an INVALID_ARGUMENT error code, if
     * any of
     *                 the permissions in the permission list are not valid,
     * or
     *                 the permissions have unsatisfied dependencies (for
     * example, if
     *                 userSet is specified without userGet).
     */
    public void roleSet(RoleSetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Returns the role information for roles matching the given
     *                 search filter.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the roleList
     *                 permission, and the returned list is the list of all
     * roles matching the search filter that the caller's roles with
     *                 roleList permission grant access to via their role
     * list.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if the
     * caller's
     *                 roles do not have roleList.
     */
    public RoleInfoList roleList(RoleListCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Create a new group.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the groupCreate
     *                 permission and the special "all" flag for the group
     * list.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if the
     * caller's
     *                 roles do not have the properties described above.
     *                 2. A fault with an OBJECT_EXIST error code, if a group
     * with the
     *                 given name already exists.
     *                 3. A fault with an OBJECT_NOT_EXIST error code, if
     * repositories
     *                 are specified but have not been defined.
     */
    public void groupCreate(GroupCreateCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Deletes a group. Groups can only be deleted when there a no
     * users,
     *                 preproduced cards, or unassigned tokens in the group.
     * The group
     *                 flagged as the default group can never be deleted.
     * References to deleted groups are automatically removed from
     *                 any role that may have granted access to them.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the groupDelete
     *                 permission and a group list that grants access to
     * the group being
     *                 deleted.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if the
     * caller does
     *                 not have a role with groupDelete permission, users,
     * pre-produced
     *                 cards or unassigned tokens are still assigned to the
     * group,
     *                 or the group to delete is the group flagged as default.
     * 2. A fault with an OBJECT_NOT_EXIST error code, if the group
     *                 does not exist, or access to the group is not permitted
     * by the criteria described above.
     */
    public void groupDelete(GroupDeleteCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Returns the group information for the named group.
     *                 If the given name group name is null, the group flagged
     * as
     *                 the default is returned.
     *                 <p>
     *                 The group is only returned if one or more of the following
     * criteria are met:
     *                 1. The caller has a role that grants access to the
     * group to
     *                 retrieve via the role's group list. 2. It is the group
     * of the administrator making this call.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if the
     * group name
     *                 is null and the caller's roles do not allow access
     * to the
     *                 group flagged as the default.
     *                 2. A fault with an OBJECT_NOT_EXIST error code, if
     * the group
     *                 does not exist or access to the group is not permitted
     * by the criteria described above.
     */
    public GroupInfo groupGet(GroupGetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Updates a group definition.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the groupSet
     *                 permission and a group list that grants access to
     * the group
     *                 being updated.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have groupSet permission.
     *                 2. A fault with an OBJECT_NOT_EXIST error code, if
     * the group
     *                 does not exist, access to the group is not permitted
     * by the role criteria described above, or repositories are
     *                 specified that do not exist.
     *                 3. A fault with an OBJECT_EXIST error code, if the
     * group
     *                 is being renamed but a group with the new name already
     * exists.
     */
    public void groupSet(GroupSetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Returns a list of groups matching a search filter.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the groupList
     *                 permission, and the returned list of groups is the
     * list of all
     *                 groups matching the filter that the user's roles with
     * groupList
     *                 permission grant access to via their group lists.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have groupList permission.
     */
    public GroupInfoList groupList(GroupListCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Return information about all users that match the given filter.
     * <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 managedCaUserList permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the managedCaUserList permission.
     */
    public ManagedCaUserInfo[] managedCaUserList(com.good.adapters.entrust.stubs.ManagedCaUserListCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Return the latest CA certificate belonging to the named Managed
     * CA.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 ManagedCaCertificateList permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the ManagedCaCertificateList permission.
     */
    public CertificateResponse[] managedCaCertificateList(com.good.adapters.entrust.stubs.ManagedCaCertificateListCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Return the latest encryption certificate for the SCEP RA identity
     * 
     *                 belonging to the named Managed CA.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 managedCaScepRaEncryptionCertificateGet permission.
     * <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the managedCaScepRaEncryptionCertificateGet
     * 
     *                 permission.
     *                 2. A fault with an OBJECT_NOT_EXIST error code, if
     * the SCEP RA
     *                 encryption certificate does not exist.
     */
    public CertificateResponse managedCaScepRaEncryptionCertificateGet(com.good.adapters.entrust.stubs.ManagedCaScepRaEncryptionCertificateGetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Return all of the certificates for the SCEP RA identity 
     *                 belonging to the named Managed CA.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 managedCaScepRaCertificateList permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the managedCaScepRaCertificateList
     * 
     *                 permission.
     *                 2. A fault with an OBJECT_NOT_EXIST error code, if
     * the SCEP RA
     *                  certificates do not exist.
     */
    public CertificateResponse[] managedCaScepRaCertificateList(com.good.adapters.entrust.stubs.ManagedCaScepRaCertificateListCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Decrypts and returns the supplied encrypted data using the
     * SCEP RA 
     *                 identity encryption certificate linked to the named
     * Managed CA.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 managedCaScepRaDecrypt permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the managedCaScepRaDecrypt permission.
     */
    public DecryptedDataInfo managedCaScepRaDecryptData(com.good.adapters.entrust.stubs.ManagedCaScepRaDecryptDataCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Signs and returns the signature for the supplied data and attributes
     * using the SCEP RA signing key linked to the named Managed CA.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 managedCaScepRaSignContent permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the managedCaScepRaSignContent
     * permission.
     */
    public com.good.adapters.entrust.stubs.ScepRaSignContentResult managedCaScepRaSignContent(com.good.adapters.entrust.stubs.ManagedCaScepRaSignContentCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Return the new one-time use registration password. Only one
     * outstanding 
     *                 password can exist at one time.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have 
     *                 both the userGet and userSet permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userGet and userSet permission.
     * 2. A fault with a USER_NOT_EXIST error code, if the user does
     *                 not exist.
     */
    public com.good.adapters.entrust.stubs.UserRegistrationPasswordInfo userRegistrationPasswordGet(com.good.adapters.entrust.stubs.UserRegistrationPasswordGetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Return whether the named password can be successfully authenticated.
     * 
     *                 Successful authentication includes supplying the correct
     * password
     *                 within a policy-specified validity period.
     *                 <p>
     *                 Irregardless of the outcome, the one-time use registration
     * password
     *                 is always removed after this call.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have 
     *                 both the userGet and userSet permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userGet and userSet permission.
     * 2. A fault with a USER_NOT_EXIST error code, if the user does
     *                 not exist.
     */
    public com.good.adapters.entrust.stubs.UserRegistrationPasswordResponse userRegistrationPasswordAuthenticate(com.good.adapters.entrust.stubs.UserRegistrationPasswordAuthenticateCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Return the new one-time use registration password. Only one
     * outstanding 
     *                 password can exist at one time.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have 
     *                 both the userGet and userSet permission.
     *                 <p>
     *                 The supplied digital id configuration will be asociated
     * with the
     *                 registration password.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userGet and userSet permission.
     * 2. A fault with a USER_NOT_EXIST error code, if the user does
     *                 not exist.
     */
    public com.good.adapters.entrust.stubs.UserRegistrationPasswordStoredDigitalIdInfoInfo userRegistrationPasswordStoredDigitalIdInfoGet(com.good.adapters.entrust.stubs.UserRegistrationPasswordStoredDigitalIdInfoGetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Return whether the named password can be successfully authenticated.
     * 
     *                 Successful authentication includes supplying the correct
     * password
     *                 within a policy-specified validity period.
     *                 <p>
     *                 Irregardless of the outcome, the one-time use registration
     * password
     *                 is always removed after this call.
     *                 <p>
     *                 The fixed digital id configuration will be returned
     * with a
     *                 successfull response.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have 
     *                 both the userGet and userSet permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userGet and userSet permission.
     * 2. A fault with a USER_NOT_EXIST error code, if the user does
     *                 not exist.
     */
    public com.good.adapters.entrust.stubs.UserRegistrationPasswordStoredDigitalIdInfoResponse userRegistrationPasswordStoredDigitalIdInfoAuthenticate(com.good.adapters.entrust.stubs.UserRegistrationPasswordStoredDigitalIdInfoAuthenticateCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Create a new Smart Credential Definition.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the smartCredentialDefinitionCreate
     *                 permission and the special "all" flag for the Smart
     * Credential Definition list.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if the
     * caller's
     *                 roles do not have the properties described above.
     *                 2. A fault with an OBJECT_EXIST error code, if a Smart
     * Credential Definition with the
     *                 given name already exists.
     */
    public void smartCredentialDefinitionCreate(com.good.adapters.entrust.stubs.SmartCredentialDefinitionCreateCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Deletes a Smart Credential Definition. Smart Credential Definitions
     * can only be
     *                 deleted when there a no user Smart Credentials or
     * policies that
     *                 refer to the Smart Credential Definition.
     *                 References to deleted Smart Credential Definitions
     * are automatically removed from
     *                 any role that may have granted access to them.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the smartCredentialDefinitionDelete
     *                 permission and a Smart Credential Definition list
     * that grants access to the Smart Credential Definition being
     *                 deleted.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if the
     * caller does
     *                 not have a role with smartCredentialDefinitionDelete
     * permission or user Smart Credentials or policies still refer to the
     * Smart Credential Definition.
     *                 2. A fault with an OBJECT_NOT_EXIST error code, if
     * the Smart Credential
     *                 Definition does not exist, or access to the Definition
     * is not permitted
     *                 by the criteria described above.
     */
    public void smartCredentialDefinitionDelete(com.good.adapters.entrust.stubs.SmartCredentialDefinitionDeleteCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Returns the Smart Credential Definition information for the
     * named Smart Credential Definition.
     *                 <p>
     *                 The Smart Credential Definition is only returned if
     * 
     *                 the caller has a role that grants access to the Smart
     * Credential Definition to
     *                 retrieve via the role's Smart Credential Definition
     * list.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with an OBJECT_NOT_EXIST error code, if
     * the Smart Credential
     *                 Definition does not exist or access to the Smart Credential
     * Definition is not permitted
     *                 by the criteria described above.
     */
    public com.good.adapters.entrust.stubs.SmartCredentialDefinitionInfo smartCredentialDefinitionGet(com.good.adapters.entrust.stubs.SmartCredentialDefinitionGetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Returns the Smart Credential Definition Template information
     * for the named Smart Credential Definition Template.
     *                 <p>
     *                 The administrator must have the smartCredentialDefinitionGet
     * permission to call this method.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with an OBJECT_NOT_EXIST error code, if
     * the Smart
     *                 Credential Definition Template does not exist.
     */
    public com.good.adapters.entrust.stubs.SmartCredentialDefinitionInfo smartCredentialDefinitionTemplateGet(com.good.adapters.entrust.stubs.SmartCredentialDefinitionTemplateGetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Updates a Smart Credential Definition definition.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the smartCredentialDefinitionSet
     *                 permission and a Smart Credential Definition list
     * that grants access to the Smart Credential Definition
     *                 being updated.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have smartCredentialDefinitionSet permission.
     * 2. A fault with an OBJECT_NOT_EXIST error code, if the Smart Credential
     * Definition does not exist or access to the Smart Credential Definition
     * is not permitted
     *                 by the role criteria described above.
     *                 3. A fault with an OBJECT_EXIST error code, if the
     * Smart Credential Definition
     *                 is being renamed but a Smart Credential Definition
     * with the new name already
     *                 exists.
     */
    public void smartCredentialDefinitionSet(com.good.adapters.entrust.stubs.SmartCredentialDefinitionSetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Returns a list of Smart Credential Definitions.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the smartCredentialDefinitionList
     *                 permission, and the returned list of Smart Credential
     * Definitions is the list of all
     *                 Smart Credential Definitions that the user's roles
     * with smartCredentialDefinitionList
     *                 permission grant access to via their Smart Credential
     * Definition lists.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have smartCredentialDefinitionList
     * permission.
     */
    public com.good.adapters.entrust.stubs.SmartCredentialDefinitionInfoList smartCredentialDefinitionList(com.good.adapters.entrust.stubs.SmartCredentialDefinitionListCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Returns a list of Smart Credential Definition Templates.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the
     *                 smartCredentialDefinitionList permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have smartCredentialDefinitionList
     * permission.
     */
    public com.good.adapters.entrust.stubs.SmartCredentialDefinitionInfoList smartCredentialDefinitionTemplateList(com.good.adapters.entrust.stubs.SmartCredentialDefinitionTemplateListCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Create a new Smart Credential Variable for a definition.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the smartCredentialDefinitionSet
     *                 permission and access to the smart credential definition
     * in
     *                 the administrator's role.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if the
     * caller's
     *                 roles do not have the properties described above.
     *                 2. A fault with an OBJECT_EXIST error code, if a Smart
     * Credential Variable with the
     *                 given name already exists.
     *                 2. A fault with an OBJECT_NOT_EXIST error code, if
     * the specified Smart Credential Definition 
     *                 does not exist.
     */
    public void smartCredentialVariableCreate(com.good.adapters.entrust.stubs.SmartCredentialVariableCreateCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Deletes a Smart Credential Variable for a given definition.
     * <p>
     *                 Callers of this operation must have a role that has
     * the smartCredentialDefinitionSet
     *                 permission and a Smart Credential Definition list
     * that grants access to the Smart Credential Definition being
     *                 modified.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if the
     * caller does
     *                 not have a role with smartCredentialDefinitionSet
     * permission.
     *                 2. A fault with an OBJECT_NOT_EXIST error code, if
     * the Smart Credential
     *                 Definition does not exist, or access to the Definition
     * is not permitted
     *                 by the criteria described above or the specified variable
     * does not exist.
     */
    public void smartCredentialVariableDelete(com.good.adapters.entrust.stubs.SmartCredentialVariableDeleteCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Updates a Smart Credential Variable for a Smart Credential
     *                 definition.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the smartCredentialDefinitionSet
     *                 permission and a Smart Credential Definition list
     * that grants access to the Smart Credential Definition
     *                 being updated.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have smartCredentialDefinitionSet permission.
     * 2. A fault with an OBJECT_NOT_EXIST error code, if the Smart Credential
     * Definition does not exist or access to the Smart Credential Definition
     * is not permitted
     *                 by the role criteria described above or the specified
     * variable
     *                 does not exist.
     */
    public void smartCredentialVariableSet(com.good.adapters.entrust.stubs.SmartCredentialVariableSetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Returns the Smart Credential Delivery information for the named
     * Smart Credential Delivery.
     *                 <p>
     *                 The Smart Credential Delivery is only returned if
     * 
     *                 the caller has a role with the smartCredentialDeliveryGet
     * permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with an OBJECT_NOT_EXIST error code, if
     * the Smart Credential
     *                 Delivery does not exist.
     *                 2. A fault with an NOT_PERMITTED error code, if the
     * administrator
     *                 does not have the required permission.
     */
    public com.good.adapters.entrust.stubs.SmartCredentialDeliveryInfo smartCredentialDeliveryGet(com.good.adapters.entrust.stubs.SmartCredentialDeliveryGetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Returns a list of Smart Credential Deliveries.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the smartCredentialDeliveryList
     *                 permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have smartCredentialDeliveryList permission.
     */
    public com.good.adapters.entrust.stubs.SmartCredentialDeliveryInfoList smartCredentialDeliveryList(NameValue[] parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Returns the User Delivery information for the named User Delivery.
     * <p>
     *                 The User Delivery is only returned if 
     *                 the caller has a role with the userDeliveryGet
     *                 permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with an OBJECT_NOT_EXIST error code, if
     * the User
     *                 Delivery does not exist.
     *                 2. A fault with an NOT_PERMITTED error code, if the
     * administrator
     *                 does not have the required permission.
     */
    public UserDeliveryInfo userDeliveryGet(com.good.adapters.entrust.stubs.UserDeliveryGetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Returns a list of User Deliveries.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the userDeliveryList
     *                 permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have userDeliveryList permission.
     */
    public UserDeliveryInfoList userDeliveryList(NameValue[] parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Create a new Smart Credential Applet.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the smartCredentialAppletCreate
     *                 permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if one
     * of the caller's
     *                 roles does not have the smartCredentialAppletCreate
     * permission.
     *                 2. A fault with an OBJECT_EXIST error code, if a Smart
     * Credential Applet with the
     *                 given name already exists.
     */
    public void smartCredentialAppletCreate(com.good.adapters.entrust.stubs.SmartCredentialAppletCreateCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Deletes a Smart Credential Applet. Smart Credential Applets
     * can only be
     *                 deleted when there a no Smart Credential Definitions
     * that
     *                 refer to the Smart Credential Applet.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the smartCredentialAppletDelete
     *                 permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if the
     * caller does
     *                 not have a role with smartCredentialAppletDelete permission
     * or user Smart Credentials or policies still refer to the Smart Credential
     * Applet.
     *                 2. A fault with an OBJECT_NOT_EXIST error code, if
     * the Smart Credential
     *                 Applet does not exist, or access to the Applet is
     * not permitted
     *                 by the criteria described above.
     */
    public void smartCredentialAppletDelete(com.good.adapters.entrust.stubs.SmartCredentialAppletDeleteCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Returns the Smart Credential Applet information for the named
     * Smart Credential Applet.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the smartCredentialAppletGet
     *                 permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if the
     * caller does
     *                 not have a role with smartCredentialAppletGet permission.
     * 2. A fault with an OBJECT_NOT_EXIST error code, if the Smart Credential
     * Applet does not exist or access to the Smart Credential Applet is
     * not permitted
     *                 by the criteria described above.
     */
    public com.good.adapters.entrust.stubs.SmartCredentialAppletInfo smartCredentialAppletGet(com.good.adapters.entrust.stubs.SmartCredentialAppletGetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Updates a Smart Credential Applet definition.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the smartCredentialAppletSet
     *                 permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have smartCredentialAppletSet permission.
     * 2. A fault with an OBJECT_NOT_EXIST error code, if the Smart Credential
     * Applet does not exist or access to the Smart Credential Applet is
     * not permitted
     *                 by the role criteria described above.
     *                 3. A fault with an OBJECT_EXIST error code, if the
     * Smart Credential Applet
     *                 is being renamed but a Smart Credential Applet with
     * the new name already
     *                 exists.
     */
    public void smartCredentialAppletSet(com.good.adapters.entrust.stubs.SmartCredentialAppletSetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Returns a list of Smart Credential Applets.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the smartCredentialAppletList
     *                 permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have smartCredentialAppletList permission.
     */
    public com.good.adapters.entrust.stubs.SmartCredentialAppletInfoList smartCredentialAppletList(com.good.adapters.entrust.stubs.SmartCredentialAppletListCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Returns the Smart Credential Applet Template information for
     * the named Smart Credential Applet Template.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the
     *                 smartCredentialAppletGet permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if the
     * caller does
     *                 not have a role with smartCredentialAppletGet permission.
     * 2. A fault with an OBJECT_NOT_EXIST error code, if the Smart Credential
     * Applet Template does not exist or access to the Smart Credential Applet
     * Template is not permitted
     *                 by the criteria described above.
     */
    public com.good.adapters.entrust.stubs.SmartCredentialAppletInfo smartCredentialAppletTemplateGet(com.good.adapters.entrust.stubs.SmartCredentialAppletTemplateGetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Returns a list of Smart Credential Applet Templates.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the
     *                 smartCredentialAppletTemplateList permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have smartCredentialAppletList permission.
     */
    public com.good.adapters.entrust.stubs.SmartCredentialAppletInfoList smartCredentialAppletTemplateList(com.good.adapters.entrust.stubs.SmartCredentialAppletTemplateListCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Create a new PACS
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the pacsCreate
     *                 permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if one
     * of the caller's
     *                 roles does not have the pacsCreate permission.
     *                 2. A fault with an OBJECT_EXIST error code, if a PACS
     * with the
     *                 given name already exists.
     */
    public void pacsCreate(PACSCreateCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Deletes a PACS. PACS can only be
     *                 deleted when there a no Smart Credential Definitions
     * that
     *                 refer to the PACS.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the pacsDelete
     *                 permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if the
     * caller does
     *                 not have a role with pacsDelete permission or a Smart
     * Credential Definition still refers to the PACS.
     *                 2. A fault with an OBJECT_NOT_EXIST error code, if
     * the PACS
     *                 does not exist, or access to the PACS is not permitted
     * by the criteria described above.
     */
    public void pacsDelete(PACSDeleteCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Returns the PACS information for the named PACS.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the pacsGet
     *                 permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if the
     * caller does
     *                 not have a role with pacsGet permission.
     *                 2. A fault with an OBJECT_NOT_EXIST error code, if
     * the PACS
     *                 does not exist or access to the PACS is not permitted
     * by the criteria described above.
     */
    public PACSInfo pacsGet(PACSGetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Updates a PACS.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the pacsSet
     *                 permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the pacsSet permission.
     *                 2. A fault with an OBJECT_NOT_EXIST error code, if
     * the PACS
     *                 does not exist or access to the PACS is not permitted
     * by the role criteria described above.
     *                 3. A fault with an OBJECT_EXIST error code, if the
     * PACS
     *                 is being renamed but a PACS with the new name already
     * exists.
     */
    public void pacsSet(PACSSetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Returns a list of PACS.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the pacsList
     *                 permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have pacsList permission.
     */
    public PACSInfoList pacsList(PACSListCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Create a new Proxy
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the proxyCreate
     *                 permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if one
     * of the caller's
     *                 roles does not have the proxyCreate permission.
     *                 2. A fault with an OBJECT_EXIST error code, if a Proxy
     * with the
     *                 given name already exists.
     */
    public void proxyCreate(ProxyCreateCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Deletes a Proxy. Proxy can only be
     *                 deleted when there a no Smart Credential Definitions
     * that
     *                 refer to the Proxy.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the proxyDelete
     *                 permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if the
     * caller does
     *                 not have a role with proxyDelete permission or a Smart
     * Credential Definition still refers to the Proxy.
     *                 2. A fault with an OBJECT_NOT_EXIST error code, if
     * the Proxy
     *                 does not exist, or access to the Proxy is not permitted
     * by the criteria described above.
     */
    public void proxyDelete(ProxyDeleteCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Returns the Proxy information for the named Proxy.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the proxyGet
     *                 permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if the
     * caller does
     *                 not have a role with proxyGet permission.
     *                 2. A fault with an OBJECT_NOT_EXIST error code, if
     * the Proxy
     *                 does not exist or access to the Proxy is not permitted
     * by the criteria described above.
     */
    public ProxyInfo proxyGet(ProxyGetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Updates a Proxy.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the proxySet
     *                 permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the proxySet permission.
     *                 2. A fault with an OBJECT_NOT_EXIST error code, if
     * the Proxy
     *                 does not exist or access to the Proxy is not permitted
     * by the role criteria described above.
     *                 3. A fault with an OBJECT_EXIST error code, if the
     * Proxy
     *                 is being renamed but a Proxy with the new name already
     * exists.
     */
    public void proxySet(ProxySetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Returns a list of Proxy.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the proxyList
     *                 permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have proxyList permission.
     */
    public ProxyInfoList proxyList(ProxyListCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Returns information for the named Risk Engine.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the riskEngineGet
     *                 permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if the
     * caller does
     *                 not have a role with riskEngineGet permission.
     *                 2. A fault with an OBJECT_NOT_EXIST error code, if
     * the Risk
     *                 Engine does not exist or access to the Risk Engine
     * is not
     *                 permitted by the criteria described above.
     */
    public RiskEngineInfo riskEngineGet(RiskEngineGetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Returns a list of risk engines.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the
     *                 riskEngineList permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have riskEngineList permission.
     */
    public RiskEngineInfoList riskEngineList(NameValue[] parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Create a new Smart Credential Graphic.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the smartCredentialGraphicCreate
     *                 permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if one
     * of the caller's
     *                 roles does not have the smartCredentialGraphicCreate
     * permission.
     *                 2. A fault with an OBJECT_EXIST error code, if a Smart
     * Credential Graphic with the
     *                 given name already exists.
     */
    public void smartCredentialGraphicCreate(com.good.adapters.entrust.stubs.SmartCredentialGraphicCreateCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Deletes a Smart Credential Graphic. Smart Credential Graphics
     * can only be
     *                 deleted when there a no Smart Credential Definitions
     * that
     *                 refer to the Smart Credential Graphic.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the smartCredentialGraphicDelete
     *                 permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if the
     * caller does
     *                 not have a role with smartCredentialGraphicDelete
     * permission or user Smart Credentials or policies still refer to the
     * Smart Credential Graphic.
     *                 2. A fault with an OBJECT_NOT_EXIST error code, if
     * the Smart Credential
     *                 Graphic does not exist, or access to the Graphic is
     * not permitted
     *                 by the criteria described above.
     */
    public void smartCredentialGraphicDelete(com.good.adapters.entrust.stubs.SmartCredentialGraphicDeleteCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Returns the Smart Credential Graphic information for the named
     * Smart Credential Graphic.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the smartCredentialGraphicGet
     *                 permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if the
     * caller does
     *                 not have a role with smartCredentialGraphicGet permission.
     * 2. A fault with an OBJECT_NOT_EXIST error code, if the Smart Credential
     * Graphic does not exist or access to the Smart Credential Graphic is
     * not permitted
     *                 by the criteria described above.
     */
    public com.good.adapters.entrust.stubs.SmartCredentialGraphicInfo smartCredentialGraphicGet(com.good.adapters.entrust.stubs.SmartCredentialGraphicGetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Updates a Smart Credential Graphic definition.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the smartCredentialGraphicSet
     *                 permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have smartCredentialGraphicSet permission.
     * 2. A fault with an OBJECT_NOT_EXIST error code, if the Smart Credential
     * Graphic does not exist or access to the Smart Credential Graphic is
     * not permitted
     *                 by the role criteria described above.
     *                 3. A fault with an OBJECT_EXIST error code, if the
     * Smart Credential Graphic
     *                 is being renamed but a Smart Credential Graphic with
     * the new name already
     *                 exists.
     */
    public void smartCredentialGraphicSet(com.good.adapters.entrust.stubs.SmartCredentialGraphicSetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Returns a list of Smart Credential Graphics.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the smartCredentialGraphicList
     *                 permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have smartCredentialGraphicList permission.
     */
    public com.good.adapters.entrust.stubs.SmartCredentialGraphicInfoList smartCredentialGraphicList(com.good.adapters.entrust.stubs.SmartCredentialGraphicListCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Create a new Digital Id Config.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the digitalIdConfigCreate
     *                 permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if one
     * of the caller's
     *                 roles does not have the digitalIdConfigCreate permission.
     * 2. A fault with an OBJECT_EXIST error code, if a Smart Credential
     * Graphic with the
     *                 given name already exists.
     */
    public void digitalIdConfigCreate(com.good.adapters.entrust.stubs.DigitalIdConfigCreateCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Deletes a Digital Id Config. Digital Id Config can only be
     *                 deleted when there a no Smart Credential Definition
     * that
     *                 refer to the Digital Id Config.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the digitalIdConfigDelete
     *                 permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if the
     * caller does
     *                 not have a role with digitalIdConfigDelete permission
     * or user SmartCredential Definitions still refer to the Digital Id
     * Config.
     *                 2. A fault with an OBJECT_NOT_EXIST error code, if
     * the Digital Id Config does not exist, or access to the Digital Id
     * Config is not permitted
     *                 by the criteria described above.
     */
    public void digitalIdConfigDelete(com.good.adapters.entrust.stubs.DigitalIdConfigDeleteCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Returns the Digital Id Config information for the named Digital
     * Id Config.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the digitalIdConfigGet
     *                 permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if the
     * caller does
     *                 not have a role with digitalIdConfigGet permission.
     * 2. A fault with an OBJECT_NOT_EXIST error code, if the Digital Id
     * Config does not exist or access to the Digital Id Config is not permitted
     * by the criteria described above.
     */
    public DigitalIdConfigInfo digitalIdConfigGet(com.good.adapters.entrust.stubs.DigitalIdConfigGetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Updates a Digital Id Config definition.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the digitalIdConfigSet
     *                 permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have digitalIdConfigSet permission.
     * 2. A fault with an OBJECT_NOT_EXIST error code, if the Digital Id
     * Config does not exist or access to the Digital Id Config is not permitted
     * by the role criteria described above.
     *                 3. A fault with an OBJECT_EXIST error code, if the
     * Digital Id Config
     *                 is being renamed but a Digital Id Config with the
     * new name already
     *                 exists.
     */
    public void digitalIdConfigSet(com.good.adapters.entrust.stubs.DigitalIdConfigSetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Returns a list of Digital Id Configs.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the digitalIdConfigList
     *                 permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have digitalIdConfigList permission.
     */
    public com.good.adapters.entrust.stubs.DigitalIdConfigInfoList digitalIdConfigList(com.good.adapters.entrust.stubs.DigitalIdConfigListCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Returns a list of Digital Id Config Templates.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the digitalIdConfigList
     *                 permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have digitalIdConfigList permission.
     */
    public com.good.adapters.entrust.stubs.DigitalIdConfigInfoList digitalIdConfigTemplateList(com.good.adapters.entrust.stubs.DigitalIdConfigTemplateListCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Create a new Smart Credential Layout.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the smartCredentialLayoutCreate
     *                 permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if one
     * of the caller's
     *                 roles does not have the smartCredentialLayoutCreate
     * permission.
     *                 2. A fault with an OBJECT_EXIST error code, if a Smart
     * Credential Layout with the
     *                 given name already exists.
     */
    public void smartCredentialLayoutCreate(com.good.adapters.entrust.stubs.SmartCredentialLayoutCreateCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Deletes a Smart Credential Layout. Smart Credential Layouts
     * can only be
     *                 deleted when there a no Smart Credential Definitions
     * that
     *                 refer to the Smart Credential Layout.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the smartCredentialLayoutDelete
     *                 permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if the
     * caller does
     *                 not have a role with smartCredentialLayoutDelete permission
     * or user Smart Credentials or policies still refer to the Smart Credential
     * Layout.
     *                 2. A fault with an OBJECT_NOT_EXIST error code, if
     * the Smart Credential
     *                 Layout does not exist, or access to the Layout is
     * not permitted
     *                 by the criteria described above.
     */
    public void smartCredentialLayoutDelete(com.good.adapters.entrust.stubs.SmartCredentialLayoutDeleteCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Returns the Smart Credential Layout information for the named
     * Smart Credential Layout.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the smartCredentialLayoutGet
     *                 permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if the
     * caller does
     *                 not have a role with smartCredentialLayoutGet permission.
     * 2. A fault with an OBJECT_NOT_EXIST error code, if the Smart Credential
     * Layout does not exist or access to the Smart Credential Layout is
     * not permitted
     *                 by the criteria described above.
     */
    public com.good.adapters.entrust.stubs.SmartCredentialLayoutInfo smartCredentialLayoutGet(com.good.adapters.entrust.stubs.SmartCredentialLayoutGetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Returns the Smart Credential Layout Template information for
     * the named Smart Credential Layout Template.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the
     *                 smartCredentialLayoutGet permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if the
     * caller does
     *                 not have a role with smartCredentialLayoutGet permission.
     * 2. A fault with an OBJECT_NOT_EXIST error code, if the Smart
     *                 Credential Layout Template does not exist.
     */
    public com.good.adapters.entrust.stubs.SmartCredentialLayoutInfo smartCredentialLayoutTemplateGet(com.good.adapters.entrust.stubs.SmartCredentialLayoutTemplateGetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Updates a Smart Credential Layout definition.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the smartCredentialLayoutSet
     *                 permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have smartCredentialLayoutSet permission.
     * 2. A fault with an OBJECT_NOT_EXIST error code, if the Smart Credential
     * Layout does not exist or access to the Smart Credential Layout is
     * not permitted
     *                 by the role criteria described above.
     *                 3. A fault with an OBJECT_EXIST error code, if the
     * Smart Credential Layout
     *                 is being renamed but a Smart Credential Layout with
     * the new name already
     *                 exists.
     */
    public void smartCredentialLayoutSet(com.good.adapters.entrust.stubs.SmartCredentialLayoutSetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Returns a list of Smart Credential Layouts.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the smartCredentialLayoutList
     *                 permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have smartCredentialLayoutList permission.
     */
    public com.good.adapters.entrust.stubs.SmartCredentialLayoutInfoList smartCredentialLayoutList(com.good.adapters.entrust.stubs.SmartCredentialLayoutListCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Returns a list of Smart Credential Layout Templates.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the
     *                 smartCredentialLayoutList permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have smartCredentialLayoutList permission.
     */
    public com.good.adapters.entrust.stubs.SmartCredentialLayoutInfoList smartCredentialLayoutTemplateList(com.good.adapters.entrust.stubs.SmartCredentialLayoutTemplateListCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Create a new Smart Credential Print Module.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the smartCredentialPrintModuleCreate
     *                 permission and the special "all" flag for the Smart
     * Credential Print Module list.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if the
     * caller's
     *                 roles do not have the properties described above.
     *                 2. A fault with an OBJECT_EXIST error code, if a Smart
     * Credential Print Module with the
     *                 given name already exists.
     */
    public void smartCredentialPrintModuleCreate(com.good.adapters.entrust.stubs.SmartCredentialPrintModuleCreateCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Deletes a Smart Credential Print Module. Smart Credential Print
     * Modules can only be
     *                 deleted when there a no user Smart Credentials or
     * policies that
     *                 refer to the Smart Credential Print Module.
     *                 References to deleted Smart Credential Print Modules
     * are automatically removed from
     *                 any role that may have granted access to them.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the smartCredentialPrintModuleDelete
     *                 permission and a Smart Credential Print Module list
     * that grants access to the Smart Credential Print Module being
     *                 deleted.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if the
     * caller does
     *                 not have a role with smartCredentialPrintModuleDelete
     * permission or user Smart Credentials or policies still refer to the
     * Smart Credential Print Module.
     *                 2. A fault with an OBJECT_NOT_EXIST error code, if
     * the Smart Credential
     *                 PrintModule does not exist, or access to the PrintModule
     * is not permitted
     *                 by the criteria described above.
     */
    public void smartCredentialPrintModuleDelete(com.good.adapters.entrust.stubs.SmartCredentialPrintModuleDeleteCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Returns the Smart Credential Print Module information for the
     * named Smart Credential Print Module.
     *                 <p>
     *                 The Smart Credential Print Module is only returned
     * if 
     *                 the caller has a role that grants access to the Smart
     * Credential Print Module to
     *                 retrieve via the role's Smart Credential Print Module
     * list.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with an OBJECT_NOT_EXIST error code, if
     * the Smart Credential
     *                 PrintModule does not exist or access to the Smart
     * Credential Print Module is not permitted
     *                 by the criteria described above.
     */
    public com.good.adapters.entrust.stubs.SmartCredentialPrintModuleInfo smartCredentialPrintModuleGet(com.good.adapters.entrust.stubs.SmartCredentialPrintModuleGetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Updates a Smart Credential Print Module definition.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the smartCredentialPrintModuleSet
     *                 permission and a Smart Credential Print Module list
     * that grants access to the Smart Credential Print Module
     *                 being updated.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have smartCredentialPrintModuleSet
     * permission.
     *                 2. A fault with an OBJECT_NOT_EXIST error code, if
     * the Smart Credential
     *                 PrintModule does not exist or access to the Smart
     * Credential Print Module is not permitted
     *                 by the role criteria described above.
     *                 3. A fault with an OBJECT_EXIST error code, if the
     * Smart Credential Print Module
     *                 is being renamed but a Smart Credential Print Module
     * with the new name already
     *                 exists.
     */
    public void smartCredentialPrintModuleSet(com.good.adapters.entrust.stubs.SmartCredentialPrintModuleSetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Returns a list of Smart Credential Print Modules.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the smartCredentialPrintModuleList
     *                 permission, and the returned list of Smart Credential
     * Print Modules is the list of all
     *                 Smart Credential Print Modules that the user's roles
     * with smartCredentialPrintModuleList
     *                 permission grant access to via their Smart Credential
     * Print Module lists.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have smartCredentialPrintModuleList
     * permission.
     */
    public com.good.adapters.entrust.stubs.SmartCredentialPrintModuleInfoList smartCredentialPrintModuleList(NameValue[] parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Wipe cards at a Smart Credential Print Module.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the
     *                 smartCredentialPrintModuleWipe permission and access
     * to the
     *                 specified Smart Credential Print Module.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if the
     * caller's
     *                 roles do not have the properties described above.
     *                 2. A fault with an OBJECT_NOT_EXIST error code, if
     * the
     *                 specified Smart Credential Print Module does not exist.
     * 3. A fault with a NOT_SUPPORTED error code, if the specified
     *                 wipe operation is not supported by the print module.
     */
    public void smartCredentialPrintModuleWipe(com.good.adapters.entrust.stubs.SmartCredentialPrintModuleWipeCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Returns information about a single repository.
     *                 <p>
     *                 To call this operation,
     *                 one of the caller's roles must have the repositoryList
     * permission,
     *                 or the repository named in the call must be assigned
     * a group that
     *                 the caller is granted access to through their roles.
     * <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with an OBJECT_NOT_EXIST error code, if
     * the given
     *                 repository does not exist, or access to the repository
     * is not
     *                 permitted by the role criteria described above.
     */
    public RepositoryInfo repositoryGet(RepositoryGetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Returns information about all repositories that are defined.
     * <p>
     *                 To call this operation, one of the caller's roles
     * must have the
     *                 repositoryList permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the repositoryList permission.
     * <p>
     *                 Any parameters passed to this call are ignored, but
     * null is not
     *                 an acceptable value. A zero-length array is acceptable.
     */
    public RepositoryInfoList repositoryList(NameValue[] parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Create a new user with the given user ID. Administrators are
     * created with this call by providing an administrative role for
     *                 the user.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userCreate permission and a group list that grants
     * access to the
     *                 group in which the user is being created. If roles
     * are being
     *                 assigned to the user, one of the caller's roles with
     * userCreate
     *                 permission and correct group list must also have userSetRole
     * permission. If shared secrets, question
     *                 and answer pairs, or authentication secrets are being
     * assigned
     *                 to the user, one of the role with userCreate permission
     * must have
     *                 userSetSecret, userSetQa, or userSetAuthSecret permissions,
     * respectively.
     *                 If any of the user's location history settings are
     * provided,
     *                 e.g. the checkVelocity flag, one of the roles with
     * userCreate permission must have
     *                 userLocationHistoryOverridePolicy permission.
     *                 If any of the user's expected location settings are
     * provided,
     *                 one of the roles with userCreate permission must also
     * have
     *                 userSetExpectedLocations permission.
     *                 If the number of days before the user can activation
     * expires is
     *                 provided, one of the roles with userCreate permission
     * must also have
     *                 userActivationPeriodOverridePolicy permission.
     *                 If contact information for the user is provided, 
     *                 one of the roles with userCreate permission must also
     * have
     *                 userContactInfoSet permission.
     *                 If the OTPDeliveryEnabled flag is provided, 
     *                 one of the roles with userCreate permission must also
     * have
     *                 userOtpOverridePolicy permission.
     *                 If the partition the user would be assigned to is
     * being 
     *                 overridden, one of the roles with userCreate
     *                 permission must also have userSetPartition permission.
     * <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the permissions described above.
     * 2. A fault with an OBJECT_NOT_EXIST error code, if the group
     *                 the user is being assigned to does not exist, or is
     * not
     *                 accessible to the caller; if the roles being assigned
     * to the
     *                 user do not exist or are not accessible to the caller.
     * 3. A fault with a USER_EXIST error code, if a user with the
     *                 given user ID already exists with the same user ID
     * or an alias
     *                 matching the given user ID, or any of the new user's
     * aliases match
     *                 the user ID or aliases of another user.
     *                 4. A fault with an INVALID_ARGUMENT error code: if
     * any of the given
     *                 arguments are contradictory, e.g. if the usePolicyForCheckVelocity
     * flag
     *                 is TRUE and the checkVelocity flag is TRUE; if any
     * of the
     *                 given contact information are not valid; if any of
     * the shared secret,
     *                 Q/A pairs or authentication secret collections are
     * provided and the collection
     *                 exceeds the maximum number or size allowed for these
     * collections
     *                 as defined in policy.
     */
    public void userCreate(UserCreateCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Delete a user, and all information (cards, authentication secrets,
     * and so on)
     *                 associated with that user. The only exception is that
     * if
     *                 the flag autoUnassignToken in the policy assigned
     * to the user's
     *                 group is true, the user's tokens are automatically
     * unassigned when the user is being deleted.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userDelete permission and a group list that grants
     * access to the
     *                 user's group. Additionally, if the user is an administrator,
     * one
     *                 of these roles must also have a role list that grants
     * access to
     *                 all of the administrator's roles.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userDelete permission, or
     * none of the
     *                 roles that would grant access to the user information
     * through
     *                 the userGet call have userDelete permission.
     *                 2. A fault with a USER_NOT_EXIST error code, if the
     * user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     */
    public void userDelete(UserDeleteCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Deliver a user to a specified contact using the specified
     *                 delivery mechanism.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userDeliver permission and a group list that grants
     * access to the
     *                 user's group. Additionally, if the user is an administrator,
     * one
     *                 of these roles must also have a role list that grants
     * access to
     *                 all of the administrator's roles.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userDeliver permission, or
     * none of the
     *                 roles that would grant access to the user information
     * through
     *                 the userGet call have userDelete permission.
     *                 2. A fault with a USER_NOT_EXIST error code, if the
     * user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     */
    public void userDeliver(UserDeliverCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Return information about the user with the given user ID.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userGet permission and a group list that grants access
     * to the
     *                 user's group. Additionally, if the user is an administrator,
     * one
     *                 of these roles must also have a role list that grants
     * access to
     *                 all of the administrator's roles. Even if a user has
     * certain attributes and
     *                 these attributes are requested with the UserGetParms
     * parameter,
     *                 they may not be returned if the caller's role(s) that
     * grant access
     *                 to the user do not have certain permissions. The user's
     * shared
     *                 secrets are only returned if the one of these roles
     * has
     *                 userGetSecret permission.
     *                 The questions from the user's question/answer pairs
     * are only
     *                 returned if one these roles has userGetQA permission.
     * The user's machine secrets are only returned if one these roles
     *                 has userMachineSecretGet permission.
     *                 The user's OTP information is only returned if one
     * these roles
     *                 has userOtpGet permission. The user's actual OTP value
     * is only
     *                 returned if one these roles has userOtpView permission.
     * The user's PVN information is only returned if one these roles
     *                 has userPvnGet permission. The user's actual PVN value
     * is only
     *                 returned if one these roles has userPvnView permission
     * and the
     *                 PVN is set to allow viewing by administrators.
     *                 The user's password information is only returned if
     * one these roles
     *                 has userPasswordGet permission. The user's actual
     * password value is only
     *                 returned if one these roles has userPasswordView permission
     * and
     *                 a retrievable version of the password has been stored.
     * The user's contact information is only returned if one these roles
     * has userContactInfoGet permission.
     *                 The user's Temporary PIN information is only returned
     * if one
     *                 these roles has userPinGet permission. The user's
     * actual
     *                 temporary PIN value is only returned if one these
     * roles has
     *                 userPinView permission.
     *                 The user's cards are only returned if one these roles
     * has userCardGet permission. The card grids are only returned if
     *                 one these roles has userCardView permission.
     *                 The user's tokens are only returned if one these roles
     * has userTokenGet permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userGet permission.
     *                 2. A fault with a USER_NOT_EXIST error code, if the
     * user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     */
    public UserInfo userGet(UserGetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Set a variety of information about the given user, including
     * user ID, aliases, authentication secrets, expected locations,
     *                 contact information, and more.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userSet permission and a group list that grants access
     * to the
     *                 user's group. Additionally, if the user being updated
     * is an administrator, one
     *                 of these roles must also have a role list that grants
     * access to
     *                 all of the administrator's roles.
     * 
     *                 If the user's group is being changed, one of the caller's
     * roles with userSet permission and correct group list must
     *                 also have a group list that grants access to the user's
     * new
     *                 group.
     * 
     *                 If new roles are being assigned to the user, one of
     * the caller's
     *                 roles with userSet permission and correct group list
     * must
     *                 also have userSetRole permission and have a role list
     * that grants
     *                 access to all of the user's new roles.
     * 
     *                 If the user's lockout count is being reset
     *                 (e.g., if the UserParms clearlockout flag is TRUE),
     * one of the roles
     *                 with userSet permission must have userUnlock permission.
     * 
     *                 If the user's state is being changed, one of the roles
     * with userSet permission must have userSetState permission.
     * 
     *                 If shared secrets, question and answer pairs, or authentication
     * secrets are being changed 
     *                 or assigned to the user, one of the roles with userSet
     * permission must have
     *                 userSetSecret, userSetQa, or userSetAuthSecret permissions,
     * respectively.
     *                 
     *                 If machine secrets are being deleted, one of the roles
     * with userSet permission must have
     *                 userMachineSecretDelete permission.
     * 
     *                 If any of the settings affecting the user's location
     * history
     *                 size or location history checking are non-nil, one
     * of the roles
     *                 with userSet permission must have userLocationHistoryOverridePolicy
     * permission.
     * 
     *                 If any of the user's location history entries are
     * being removed,
     *                 one of the roles with userSet permission must have
     * userDeleteLocationHistory permission.
     * 
     *                 If any of the user's expected location settings are
     * provided,
     *                 one of the roles with userSet permission must also
     * have
     *                 userSetExpectedLocations permission.
     * 
     *                 If the number of days before the user can activation
     * expires is
     *                 provided, one of the roles with userSet permission
     * must also have
     *                 userActivationPeriodOverridePolicy permission.
     * 
     *                 If contact information for the user is being added
     * or modified,
     *                 provided, one of the roles with userSet permission
     * must also have
     *                 userContactInfoSet permission.
     * 
     *                 If the OTPDeliveryEnabled flag is provided, 
     *                 one of the roles with userSet permission must also
     * have
     *                 userOtpOverridePolicy permission.
     * 
     *                 If the partition the user is currently assigned to
     * is being
     *                 changed, one of the roles with userSet
     *                 permission must also have userSetPartition permission.
     * <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the permissions described above.
     * 2. A fault with a USER_NOT_EXIST error code, if the user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with an OBJECT_NOT_EXIST error code, if
     * the group
     *                 the user is being re-assigned to does not exist, or
     * is not
     *                 accessible to the caller; if the roles being assigned
     * to the
     *                 user do not exist or are not accessible to the caller.
     * 4. A fault with a USER_EXIST error code, if the user is being renamed
     * or assigned new aliases, and a user with the given user ID
     *                 already exists with the same user ID or an alias
     *                 matching the given user ID, or any of the user's new
     * aliases match
     *                 the user ID or aliases of another user.
     *                 5. A fault with an INVALID_ARGUMENT error code: if
     * any of the given
     *                 arguments are contradictory, e.g. if the usePolicyForCheckVelocity
     * flag
     *                 is TRUE and the checkVelocity flag is TRUE; if any
     * of the
     *                 given contact information are not valid; if any of
     * the shared secret,
     *                 Q/A pairs or authentication secret collections are
     * provided and the collection
     *                 exceeds the maximum number or size allowed for these
     * collections
     *                 as defined in policy.
     */
    public void userSet(UserSetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Return information about all users that match the given filter.
     * The returned list will be ordered by the order in which the
     *                 users were created.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userList permission. Users matching the filter are
     * only
     *                 returned if they are accessible to the caller using
     * the roles
     *                 with userList permission and the access rules described
     * for the
     *                 userGet operation. User information returned (cards,
     * tokens, etc.)
     *                 is also subject to the rules described for the userGet
     * operation.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userList permission.
     *                 2. A fault with an OBJECT_NOT_EXIST error code, if
     * any of the
     *                 groups, roles, or token vendor IDs specified in the
     * search
     *                 filter do not exist, or access to them is not granted
     * by
     *                 the user's roles with userList permission.
     */
    public UserListResult userList(UserListCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Return lockout information about the user with the given user
     * ID.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userGet permission and a group list that grants access
     * to the
     *                 user's group. Additionally, if the user is an administrator,
     * one
     *                 of these roles must also have a role list that grants
     * access to
     *                 all of the administrator's roles.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userGet permission.
     *                 2. A fault with a USER_NOT_EXIST error code, if the
     * user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     */
    public UserLockoutInfo userLockoutGet(com.good.adapters.entrust.stubs.UserLockoutGetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Set lockout information for the given user.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userUnlock permission and a group list that grants
     * access to the
     *                 user's group. Additionally, if the user being updated
     * is an administrator, one
     *                 of these roles must also have a role list that grants
     * access to
     *                 all of the administrator's roles.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the permissions described above.
     * 2. A fault with a USER_NOT_EXIST error code, if the user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with an INVALID_ARGUMENT error code: if
     * any of the
     *                 given arguments are invalid.
     */
    public void userLockoutSet(com.good.adapters.entrust.stubs.UserLockoutSetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Returns the LDAP users that are not yet Entrust IdentityGuard
     * users and
     *                  that match the given filter.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the
     *                 userEnrollList permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userEnrollList permission.
     */
    public UserEnrollListResult userEnrollList(com.good.adapters.entrust.stubs.UserEnrollListCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Return a list of the delivery configurations for the Entrust
     * IdentityGuard Server.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userContactInfoGet permission.
     *                 <p>
     *                 Any parameters passed to this call are ignored, but
     * null is not
     *                 an acceptable value. A zero-length array is acceptable.
     */
    public DeliveryConfigInfoList deliveryConfigList(NameValue[] parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Create a new contact information entry for the given user.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userContactInfoSet permission and a group list that
     * grants access to the
     *                 user's group. Additionally, if the user is an administrator,
     * one
     *                 of these roles must also have a role list that grants
     * access to
     *                 all of the administrator's roles.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userContactInfoSet permission,
     * or none of the
     *                 roles that would grant access to the user information
     * through
     *                 the userGet call have userContactInfoSet permission.
     * 2. A fault with a USER_NOT_EXIST error code, if the user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     *                 4. A fault with an INVALID_ARGUMENT error code, if
     * the specified
     *                 delivery configuration is not valid, if contact information
     * with
     *                 the given label already exists, the value given for
     * the
     *                 contact information is not valid, or an attempt is
     * made to
     *                 flag multiple contact information as the default.
     */
    public void userContactInfoCreate(com.good.adapters.entrust.stubs.UserContactInfoCreateCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Delete contact information entries with the given labels from
     * the
     *                 given user.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userContactInfoSet permission and a group list that
     * grants access to the
     *                 user's group. Additionally, if the user is an administrator,
     * one
     *                 of these roles must also have a role list that grants
     * access to
     *                 all of the administrator's roles.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userContactInfoSet permission,
     * or none of the
     *                 roles that would grant access to the user information
     * through
     *                 the userGet call have userContactInfoSet permission.
     * 2. A fault with a USER_NOT_EXIST error code, if the user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     *                 4. A fault with a CONTACTINFO_NOT_EXIST error code,
     * if the
     *                 specified contact information does not exist.
     */
    public int userContactInfoDelete(com.good.adapters.entrust.stubs.UserContactInfoDeleteCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Get the contact information of the given user, optionally returning
     * only entries with the selected labels.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userContactInfoGet permission and a group list that
     * grants access to the
     *                 user's group. Additionally, if the user is an administrator,
     * one
     *                 of these roles must also have a role list that grants
     * access to
     *                 all of the administrator's roles.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userContactInfoGet permission,
     * or none of the
     *                 roles that would grant access to the user information
     * through
     *                 the userGet call have userContactInfoGet permission.
     * 2. A fault with a USER_NOT_EXIST error code, if the user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     */
    public ContactInfo[] userContactInfoGet(com.good.adapters.entrust.stubs.UserContactInfoGetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Update contact information for the given user.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userContactInfoSet permission and a group list that
     * grants access to the
     *                 user's group. Additionally, if the user is an administrator,
     * one
     *                 of these roles must also have a role list that grants
     * access to
     *                 all of the administrator's roles.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userContactInfoSet permission,
     * or none of the
     *                 roles that would grant access to the user information
     * through
     *                 the userGet call have userContactInfoSet permission.
     * 2. A fault with a USER_NOT_EXIST error code, if the user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     *                 4. A fault with an INVALID_ARGUMENT error code, if
     * the specified
     *                 delivery configuration for any of the contact information
     * objects
     *                 is not valid, if contact information with the given
     * label
     *                 already exists, if the value given for the contact
     * information
     *                 is not valid, or an attempt is made to flag multiple
     * contact
     *                 information as the default.
     */
    public void userContactInfoSet(com.good.adapters.entrust.stubs.UserContactInfoSetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Create a Temporary PIN for the given user.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userPinCreate permission and a group list that grants
     * access to the
     *                 user's group. Additionally, if the user is an administrator,
     * one
     *                 of these roles must also have a role list that grants
     * access to
     *                 all of the administrator's roles. If either of the
     * temporary
     *                 PIN lifetime or the maximum number of uses is specified,
     * one
     *                 of these roles must have userPinOverridePolicy permission
     * too.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the permissions described above.
     * 2. A fault with a USER_NOT_EXIST error code, if the user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     *                 4. A fault with a PIN_EXIST error code, if the user
     * already has
     *                 a temporary PIN and the Force flag was not set to
     * true in
     *                 the call.
     *                 5. A fault with an INVALID_ARGUMENT error code, if
     * the temporary
     *                 PIN lifetime is outside the acceptable range.
     */
    public void userPINCreate(UserPINCreateCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Delete the temporary PIN of the given user.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userPinDelete permission and a group list that grants
     * access to the
     *                 user's group. Additionally, if the user is an administrator,
     * one
     *                 of these roles must also have a role list that grants
     * access to
     *                 all of the administrator's roles.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userPinDelete permission.
     *                 2. A fault with a USER_NOT_EXIST error code, if the
     * user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     *                 4. A fault with a PIN_NOT_EXIST error code, if the
     * user
     *                 does not have a temporary PIN.
     */
    public void userPINDelete(UserPINDeleteCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Deliver the temporary PIN of the given user to the specified
     * contact using the specified delivery mechanism.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userPinDeliver permission and a group list that grants
     * access to the
     *                 user's group. Additionally, if the user is an administrator,
     * one
     *                 of these roles must also have a role list that grants
     * access to
     *                 all of the administrator's roles.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userPinDeliver permission.
     * 2. A fault with a USER_NOT_EXIST error code, if the user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     *                 4. A fault with a PIN_NOT_EXIST error code, if the
     * user
     *                 does not have a temporary PIN.
     */
    public void userPINDeliver(com.good.adapters.entrust.stubs.UserPINDeliverCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Get information about the temporary PIN of the given user.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userPinGet permission and a group list that grants
     * access to the
     *                 user's group. Additionally, if the user is an administrator,
     * one
     *                 of these roles must also have a role list that grants
     * access to
     *                 all of the administrator's roles. If one of these
     * roles has
     *                 the userPinView permission then the actual temporary
     * PIN value
     *                 is returned along with the information about the PIN.
     * Otherwise,
     *                 the temporary PIN value is not returned.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userPinGet permission.
     *                 2. A fault with a USER_NOT_EXIST error code, if the
     * user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     *                 4. A fault with a PIN_NOT_EXIST error code, if the
     * user
     *                 does not have a temporary PIN.
     */
    public UserPINInfo userPINGet(UserPINGetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Update information about the temporary PIN of the given user.
     * <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userPinSet permission and a group list that grants
     * access to the
     *                 user's group. Additionally, if the user is an administrator,
     * one
     *                 of these roles must also have a role list that grants
     * access to
     *                 all of the administrator's roles. If either of the
     * temporary
     *                 PIN lifetime or the maximum number of uses is specified,
     * one
     *                 of these roles must have userPinOverridePolicy permission
     * too.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the permissions described above.
     * 2. A fault with a USER_NOT_EXIST error code, if the user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     *                 4. A fault with a PIN_NOT_EXIST error code, if the
     * user
     *                 does not have a temporary PIN.
     *                 5. A fault with an INVALID_ARGUMENT error code, if
     * the temporary
     *                 PIN lifetime is outside the acceptable range.
     */
    public void userPINSet(UserPINSetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Create a machine secret for the given user.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userMachineSecretCreate permission and a group list
     * that
     *                 grants access to the user's group. Additionally, if
     * the user
     *                 is an administrator, one of these roles must also
     * have a role
     *                 list that grants access to all of the administrator's
     * roles.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userMachineSecretCreate permission.
     * 2. A fault with a USER_NOT_EXIST error code, if the user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     *                 4. A fault with an OBJECT_EXIST error code, if the
     * user
     *                 already has a machine secret with the given machine
     * nonce.
     *                 5. A fault with an INVALID_ARGUMENT error code, if
     * the user's
     *                 machine secrets would exceed the maximum number or
     * size, as
     *                 defined by policy.
     */
    public MachineSecretInfo userMachineSecretCreate(com.good.adapters.entrust.stubs.UserMachineSecretCreateCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Delete the specified machine secret of the given user.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userMachineSecretDelete permission and a group list
     * that
     *                 grants access to the user's group. Additionally, if
     * the user
     *                 is an administrator, one of these roles must also
     * have a role
     *                 list that grants access to all of the administrator's
     * roles.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userMachineSecretDelete permission.
     * 2. A fault with a USER_NOT_EXIST error code, if the user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     *                 4. A fault with an OBJECT_NOT_EXIST error code, if
     * the user
     *                 does not have a machine secret with the specified
     * machine nonce.
     */
    public void userMachineSecretDelete(com.good.adapters.entrust.stubs.UserMachineSecretDeleteCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Get information about the specified machine secret of the
     *                 given user.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userMachineSecretGet permission and a group list that
     * grants
     *                 access to the user's group. Additionally, if the user
     * is an
     *                 administrator, one of these roles must also have a
     * role list
     *                 that grants access to all of the administrator's roles.
     * <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userMachineSecretGet permission.
     * 2. A fault with a USER_NOT_EXIST error code, if the user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     *                 4. A fault with an OBJECT_NOT_EXIST error code, if
     * the user
     *                 does not have a machine secret with the given nonce.
     */
    public MachineSecretInfo userMachineSecretGet(com.good.adapters.entrust.stubs.UserMachineSecretGetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Update information about the specified machine secret of the
     * given user.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userMachineSecretSet permission and a group list that
     * grants
     *                 access to the user's group. Additionally, if the user
     * is an
     *                 administrator, one of these roles must also have a
     * role list
     *                 that grants access to all of the administrator's roles.
     * <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userMachineSecretSet permission.
     * 2. A fault with a USER_NOT_EXIST error code, if the user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     *                 4. A fault with an OBJECT_NOT_EXIST error code, if
     * the user
     *                 does not have a machine secret with the given machine
     * nonce.
     *                 5. A fault with an INVALID_ARGUMENT error code, if
     * the size
     *                 of the user's machine secrets would exceed the maximum
     * size
     *                 allowed by policy.
     */
    public void userMachineSecretSet(com.good.adapters.entrust.stubs.UserMachineSecretSetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * List all of the machine secrets for the given user.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userMachineSecretGet permission and a group list that
     * grants
     *                 access to the user's group. Additionally, if the user
     * is an
     *                 administrator, one of these roles must also have a
     * role list
     *                 that grants access to all of the administrator's roles.
     * <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userMachineSecretGet permission.
     * 2. A fault with a USER_NOT_EXIST error code, if the user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     */
    public MachineSecretInfo[] userMachineSecretList(com.good.adapters.entrust.stubs.UserMachineSecretListCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Create a preference for the given user.
     *                 <p>
     *                 An administrator can only perform this operation on
     * their
     *                 own user.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if the
     * caller
     *                 is not performing this operation on their self.
     *                 2. A fault with a USER_NOT_EXIST error code, if the
     * user does
     *                 not exist.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     *                 4. A fault with an OBJECT_EXIST error code, if the
     * user
     *                 already has a preference with the given name.
     *                 5. A fault with an INVALID_ARGUMENT error code, if
     * the specified
     *                 preference is too large or the user has too many preferences
     * as defined by policy.
     */
    public void userPreferenceCreate(com.good.adapters.entrust.stubs.UserPreferenceCreateCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Delete the specified preference from the given user.
     *                 <p>
     *                 An administrator can only perform this operation on
     * their
     *                 own userId.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if the
     * caller is not performing this operation on their own userId.
     *                 2. A fault with a USER_NOT_EXIST error code, if the
     * specified
     *                 user does not exist.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     *                 4. A fault with an OBJECT_NOT_EXIST error code, if
     * the user
     *                 does not have a preference with the specified name.
     */
    public void userPreferenceDelete(com.good.adapters.entrust.stubs.UserPreferenceDeleteCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Get the preference with the specified name for the
     *                 given user.
     *                 <p>
     *                 An administrator can only perform this operation on
     * their
     *                 own userId.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if the
     * caller
     *                 is performing this operation on another user.
     *                 2. A fault with a USER_NOT_EXIST error code, if the
     * user does
     *                 not exist.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     *                 4. A fault with an OBJECT_NOT_EXIST error code, if
     * the user
     *                 does not have a preference with the given name.
     */
    public NameValue userPreferenceGet(com.good.adapters.entrust.stubs.UserPreferenceGetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Update the value of the specified preference of the
     *                 given user.
     *                 <p>
     *                 An administrator can only perform this operation on
     * their
     *                 own userId.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if the
     * administrator is performing this operation on another user.
     *                 2. A fault with a USER_NOT_EXIST error code, if the
     * user does
     *                 not exist.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     *                 4. A fault with an OBJECT_NOT_EXIST error code, if
     * the user
     *                 does not have a preference with the given name.
     *                 5. A fault with an INVALID_ARGUMENT error code, if
     * the size
     *                 of the new value exceeds the size allowed by policy.
     */
    public void userPreferenceSet(com.good.adapters.entrust.stubs.UserPreferenceSetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * List all of the preferences for the given user.
     *                 <p>
     *                 An administrator can only perform this operation on
     * their
     *                 own userId.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if the
     * caller
     *                 is performing this operation on another user.
     *                 2. A fault with a USER_NOT_EXIST error code, if the
     * user does
     *                 not exist.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     */
    public NameValue[] userPreferenceList(com.good.adapters.entrust.stubs.UserPreferenceListCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Create one-time passwords (OTP) for the given user and return
     * them.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userOtpCreate permission and a group list that grants
     * access to the
     *                 user's group. Additionally, if the user is an administrator,
     * one
     *                 of these roles must also have a role list that grants
     * access to
     *                 all of the administrator's roles. If the OTP
     *                 lifetime is specified, one of these roles must have
     * userOtpOverridePolicy permission too. The actual OTP value,
     *                 as opposed to just information about the OTP, is only
     * returned
     *                 if one of these roles has the userOtpView permission.
     * <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the permissions described above.
     * 2. A fault with a USER_NOT_EXIST error code, if the user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     *                 4. A fault with an OBJECT_EXIST error code, if the
     * user already
     *                 has an OTP and the Force flag was not set to true
     * in
     *                 the call.
     *                 5. A fault with an INVALID_ARGUMENT error code, if
     * the OTP
     *                 lifetime is outside the acceptable range.
     */
    public UserOTPInfo[] userOTPCreate(UserOTPCreateCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Delete the specified one-time passwords (OTPs) of the given
     * user.  This operation will return the number of OTPs deleted.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must
     *                 have the userOtpDelete permission and a group list
     * that grants
     *                 access to the user's group. Additionally, if the user
     * is an
     *                 administrator, one of these roles must also have a
     * role list
     *                 that grants access to all of the administrator's roles.
     * <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userOtpDelete permission.
     *                 2. A fault with a USER_NOT_EXIST error code, if the
     * user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     *                 4. A fault with an OBJECT_NOT_EXIST error code, if
     * the user
     *                 does not have the specified OTPs.
     */
    public int userOTPDelete(UserOTPDeleteCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Deliver the one-time password (OTP) for the given user to the
     * specified contact information entry.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userOtpDeliver permission and a group list that grants
     * access
     *                 to the user's group. Additionally, if the user is
     * an
     *                 administrator, one of these roles must also have a
     * role
     *                 list that grants access to all of the administrator's
     * roles.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the permissions described above,
     * or if
     *                 OTP delivery is not enabled for the user.
     *                 2. A fault with a USER_NOT_EXIST error code, if the
     * user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     *                 4. A fault with a CONTACTINFO_NOT_EXIST error code,
     * if the user
     *                 does not have a contact information entry with the
     * specified
     *                 name.
     */
    public UserOTPDeliverResult userOTPDeliver(com.good.adapters.entrust.stubs.UserOTPDeliverCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Get information about the one-time passwords (OTP) of the given
     * user that match the given filter.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must
     *                 have the userOtpGet permission and a group list that
     * grants
     *                 access to the
     *                 user's group. Additionally, if the user is an administrator,
     * one
     *                 of these roles must also have a role list that grants
     * access to
     *                 all of the administrator's roles. If one of these
     * roles has
     *                 the userOtpView permission then the actual OTP value
     * is returned along with the information about the OTP. Otherwise,
     *                 only information about the OTP is returned, but not
     * the OTP 
     *                 value itself.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userOtpGet permission.
     *                 2. A fault with a USER_NOT_EXIST error code, if the
     * user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     *                 4. A fault with a OBJECT_NOT_EXIST error code, if
     * the user
     *                 does not have the specified OTPs.
     */
    public UserOTPInfo[] userOTPGet(UserOTPGetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Modify information about the one-time passwords (OTP) of the
     * given user that match the given filter.  This operation will
     *                 return the number of OTPs modified.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must
     *                 have the userOtpSet permission and a group list that
     * grants
     *                 access to the
     *                 user's group. Additionally, if the user is an administrator,
     * one
     *                 of these roles must also have a role list that grants
     * access to
     *                 all of the administrator's roles.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userOtpSet permission.
     *                 2. A fault with a USER_NOT_EXIST error code, if the
     * user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     *                 4. A fault with a OBJECT_NOT_EXIST error code, if
     * the user
     *                 does not have the specified OTPs.
     */
    public int userOTPSet(UserOTPSetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Create a password for the given user. Will fail if the user
     * already has a password.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userPasswordCreate permission and a group list that
     * grants access to the
     *                 user's group. Additionally, if the user is an administrator,
     * one
     *                 of these roles must also have a role list that grants
     * access to
     *                 all of the administrator's roles. If the password
     * 
     *                 lifetime is specified, one of these roles must have
     * userPasswordOverridePolicy permission too.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the permissions described above.
     * 2. A fault with a USER_NOT_EXIST error code, if the user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     *                 4. A fault with an OBJECT_EXIST error code, if the
     * user already
     *                 has a password.
     *                 5. A fault with an INVALID_ARGUMENT error code, if
     * the 
     *                 auto-generate flag is set to true and a password is
     * supplied
     *                 in the parameters.
     */
    public void userPasswordCreate(com.good.adapters.entrust.stubs.UserPasswordCreateCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Modify a password for the given user. Will fail if the user
     * has no existing password.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userPasswordSet permission and a group list that grants
     * access to the
     *                 user's group. Additionally, if the user is an administrator,
     * one
     *                 of these roles must also have a role list that grants
     * access to
     *                 all of the administrator's roles. If  the password
     * lifetime is specified, one of these roles must have
     *                 userPasswordOverridePolicy permission too.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the permissions described above.
     * 2. A fault with a USER_NOT_EXIST error code, if the user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     *                 4. A fault with an OBJECT_NOT_EXIST error code, if
     * the user
     *                 does not have a password.
     *                 5. A fault with an INVALID_ARGUMENT error code, if
     * the 
     *                 auto-generate flag is set to true and a password is
     * supplied
     *                 in the parameters.
     */
    public void userPasswordSet(com.good.adapters.entrust.stubs.UserPasswordSetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Get the password for the given user.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userPasswordGet permission and a group list that grants
     * access to the
     *                 user's group. Additionally, if the user is an administrator,
     * one
     *                 of these roles must also have a role list that grants
     * access to
     *                 all of the administrator's roles. If one of these
     * roles has
     *                 the userPasswordView permission and a retrievable
     * version
     *                 of the password is stored then the actual password
     * value
     *                 is returned along with the information about it. Otherwise,
     * only information about the password, but not the actual password,
     *                 is returned.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the permissions described above.
     * 2. A fault with a USER_NOT_EXIST error code, if the user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     *                 4. A fault with an OBJECT_NOT_EXIST error code, if
     * the user
     *                 does not have a password.
     */
    public UserPasswordInfo userPasswordGet(com.good.adapters.entrust.stubs.UserPasswordGetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * List all the passwords for the given user.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userPasswordGet permission and a group list that grants
     * access to the
     *                 user's group. Additionally, if the user is an administrator,
     * one
     *                 of these roles must also have a role list that grants
     * access to
     *                 all of the administrator's roles. If one of these
     * roles has
     *                 the userPasswordView permission and a retrievable
     * version
     *                 of the password is stored then the actual password
     * value
     *                 is returned along with the information about it. Otherwise,
     * only information about the password, but not the actual password,
     *                 is returned.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the permissions described above.
     * 2. A fault with a USER_NOT_EXIST error code, if the user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     */
    public UserPasswordInfo[] userPasswordList(com.good.adapters.entrust.stubs.UserPasswordListCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Delete the password for the given user.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userPasswordDelete permission and a group list that
     * grants access to the
     *                 user's group. Additionally, if the user is an administrator,
     * one
     *                 of these roles must also have a role list that grants
     * access to
     *                 all of the administrator's roles.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userPasswordDelete permission.
     * 2. A fault with a USER_NOT_EXIST error code, if the user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     *                 4. A fault with an OBJECT_NOT_EXIST error code, if
     * the user
     *                 does not have a password.
     */
    public void userPasswordDelete(com.good.adapters.entrust.stubs.UserPasswordDeleteCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Deliver the password for the given user.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userPasswordDeliver permission and a group list that
     * grants access to the
     *                 user's group. Additionally, if the user is an administrator,
     * one
     *                 of these roles must also have a role list that grants
     * access to
     *                 all of the administrator's roles.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userPasswordDeliver permission.
     * 2. A fault with a USER_NOT_EXIST error code, if the user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     *                 4. A fault with an OBJECT_NOT_EXIST error code, if
     * the user
     *                 does not have a password, the specified user delivery
     * 
     *                 mechanism does not exist or the specified contact
     * does not
     *                 exist.
     *                 5. A fault with an INVALID_ARGUMENT error code, if
     * the 
     *                 specified user delivery mechanism does not support
     * passwords
     *                 or the delivery type of specified user delivery mechanism
     * does
     *                 not match the specified contact.
     */
    public void userPasswordDeliver(com.good.adapters.entrust.stubs.UserPasswordDeliverCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Create the personal verification number (PVN) for the given
     * user.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userPvnCreate permission and a group list that grants
     * access to the
     *                 user's group. Additionally, if the user is an administrator,
     * one
     *                 of these roles must also have a role list that grants
     * access to
     *                 all of the administrator's roles.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userPvnCreate permission.
     *                 2. A fault with a USER_NOT_EXIST error code, if the
     * user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     *                 4. A fault with an OBJECT_EXIST error code, if the
     * user already has
     *                 a PVN.
     *                 5. A fault with an INVALID_ARGUMENT error code, if
     * neither the
     *                 PVN is specified nor the auto-generate flag is set
     * to true, or if
     *                 both the PVN is specified and the auto-generate flag
     * is set to
     *                 true, if the specified PVN contains non-numeric characters,
     * or the PVN specified is not the length specified by the
     *                 user's policy.
     *                 6. A fault with a PVN_CHANGE_REQUIRED error code,
     * if the change
     *                 required flag is set to false but the policy dictates
     * that a
     *                 PVN must be changed when it is first used.
     */
    public void userPVNCreate(UserPVNCreateCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Update the personal verification number (PVN) for the given
     * user.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userPvnSet permission and a group list that grants
     * access to the
     *                 user's group. Additionally, if the user is an administrator,
     * one
     *                 of these roles must also have a role list that grants
     * access to
     *                 all of the administrator's roles.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the permissions described above.
     * 2. A fault with a USER_NOT_EXIST error code, if the user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     *                 4. A fault with an OBJECT_NOT_EXIST error code, if
     * the user
     *                 does not have a PVN.
     *                 5. A fault with an INVALID_ARGUMENT error code, if
     * the "change
     *                 required" flag is not specified and neither the
     *                 PVN is specified nor the auto-generate flag is set
     * to true, if
     *                 both the PVN is specified and the auto-generate flag
     * is set to
     *                 true, if the specified PVN contains non-numeric characters,
     * or the length of the PVN specified is not the same as the PVN
     *                 length specified by the user's policy.
     *                 6. A fault with a PVN_INVALID error code, if both
     * a new PVN
     *                 value and the old PVN are specified, and the old PVN
     * is not
     *                 the correct value.
     *                 7. A fault with a PVN_CHANGE_REQUIRED error code,
     * if the change
     *                 required flag is set to false but the policy dictates
     * that a
     *                 PVN must be changed when it is first used.
     */
    public void userPVNSet(UserPVNSetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Delete the personal verification number (PVN) for the given
     * user.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userPvnDelete permission and a group list that grants
     * access to the
     *                 user's group. Additionally, if the user is an administrator,
     * one
     *                 of these roles must also have a role list that grants
     * access to
     *                 all of the administrator's roles.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userPvnDelete permission.
     *                 2. A fault with a USER_NOT_EXIST error code, if the
     * user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     *                 4. A fault with an OBJECT_NOT_EXIST error code, if
     * the user
     *                 does not have a PVN.
     */
    public void userPVNDelete(UserPVNDeleteCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Deliver the personal verification number (PVN) for the given
     * user.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userPvnDeliver permission and a group list that grants
     * access to the
     *                 user's group. Additionally, if the user is an administrator,
     * one
     *                 of these roles must also have a role list that grants
     * access to
     *                 all of the administrator's roles.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userPvnDeliver permission.
     * 2. A fault with a USER_NOT_EXIST error code, if the user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     *                 4. A fault with an OBJECT_NOT_EXIST error code, if
     * the user
     *                 does not have a PVN, the specified delivery mechanism
     * does
     *                 not exist or the specified contact does not exist.
     * 5. A fault with an INVALID_ARGUMENT error code, if the 
     *                 specified user delivery mechanism does not support
     * passwords
     *                 or the delivery type of specified user delivery mechanism
     * does
     *                 not match the specified contact.
     */
    public void userPVNDeliver(com.good.adapters.entrust.stubs.UserPVNDeliverCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Get information about the personal verification number (PVN)
     * of the given user.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userPvnGet permission and a group list that grants
     * access to the
     *                 user's group. Additionally, if the user is an administrator,
     * one
     *                 of these roles must also have a role list that grants
     * access to
     *                 all of the administrator's roles. If one of these
     * roles has
     *                 the userPvnView permission and the PVN was created
     * by the
     *                 administration service and has not yet been changed
     * by the user,
     *                 then the actual PVN value is returned along with the
     * information about the PVN. Otherwise, only information about the
     *                 PVN, but not the PVN value itself, is returned.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userPvnGet permission described
     * above.
     *                 2. A fault with a USER_NOT_EXIST error code, if the
     * user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     *                 4. A fault with an OBJECT_NOT_EXIST error code, if
     * the user
     *                 does not have a PVN.
     */
    public UserPVNInfo userPVNGet(UserPVNGetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Create a card for the given user. If the card serial number
     * is specified
     *                 in the UserCardParms parameter, the preproduced card
     * with the given serial number will
     *                 be assigned to the user; otherwise a new user card
     * will be created with
     *                 the next available serial number.
     *                 <p>
     *                 To call this operation and specify a serial number
     * of a card
     *                 to assign to the user, at least one of the caller's
     * roles must
     *                 have the userCardAssign permission. To call it to
     * create a
     *                 brand new card for the user, at least one of the caller's
     * roles must
     *                 have the userCardCreate permission. Additionally,
     * one of these
     *                 roles must have a group list that grants access to
     * the
     *                 user's group, and if the user is an administrator,
     * must also have a role list that grants access to
     *                 all of the administrator's roles. If either of the
     * card lifetime
     *                 or a supersede date for an existing card are specified,
     * one
     *                 of the roles meeting all the previous conditions must
     * have
     *                 userCardOverridePolicy permission too.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the permissions described above.
     * 2. A fault with a USER_NOT_EXIST error code, if the user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     *                 4. A fault with a CARD_EXIST error code, if the user
     * already has
     *                 a card in the PENDING or HOLD_PENDING states.
     *                 5. A fault with a CARD_NOT_EXIST error code, if a
     * card serial
     *                 number is supplied but that preproduced card does
     * not exist.
     *                 6. A fault with an INVALID_ARGUMENT error code, if
     * a card serial
     *                 number is supplied but that preproduced card does
     * not belong
     *                 to the same group as the user, or if the specified
     * card lifetime or
     *                 supersede dates are outside the acceptable range.
     *                 7. A fault with an INVALID_CARD_STATE error code,
     * if an attempt
     *                 is made to create a card in the CURRENT or HOLD state
     * when
     *                 the user already has a card in the CURRENT or HOLD
     * state.
     */
    public void userCardCreate(com.good.adapters.entrust.stubs.UserCardCreateCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Delete the cards for the given user that match the given filter,
     * and return the number of cards deleted.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userCardDelete permission and a group list that grants
     * access to the
     *                 user's group. Additionally, if the user is an administrator,
     * one
     *                 of these roles must also have a role list that grants
     * access to
     *                 all of the administrator's roles. Alternately, if
     * only cards in
     *                 the CANCELED state are being deleted, only
     *                 userCardDeleteCanceled permission is required, but
     * the role
     *                 list and group list requirements must still be met.
     * <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the permissions described above.
     * 2. A fault with a USER_NOT_EXIST error code, if the user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     *                 4. A fault with a CARD_NOT_EXIST error code, if none
     * of the user's
     *                 cards match the given filter.
     */
    public int userCardDelete(com.good.adapters.entrust.stubs.UserCardDeleteCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Deliver the card for the given user that matches the given
     *                 filter.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userCardDeliver permission and a group list that grants
     * access to the
     *                 user's group. Additionally, if the user is an administrator,
     * one
     *                 of these roles must also have a role list that grants
     * access to
     *                 all of the administrator's roles.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the permissions described above.
     * 2. A fault with a USER_NOT_EXIST error code, if the user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     *                 4. A fault with a CARD_NOT_EXIST error code, if none
     * of the
     *                 user's cards match the given filter.
     *                 5. A fault with an OBJECT_NOT_EXIST error code, if
     * the
     *                 specified delivery mechanism does not exist or the
     * specified
     *                 contact does not exist.
     *                 6. A fault with an INVALID_ARGUMENT error code, if
     * the 
     *                 specified user delivery mechanism does not support
     * grids
     *                 or the delivery type of specified user delivery mechanism
     * does
     *                 not match the specified contact.
     */
    public void userCardDeliver(com.good.adapters.entrust.stubs.UserCardDeliverCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Return cards for the given user that match the given filter.
     * <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userCardGet permission and a group list that grants
     * access to the
     *                 user's group. Additionally, if the user is an administrator,
     * one
     *                 of these roles must also have a role list that grants
     * access to
     *                 all of the administrator's roles. If one of these
     * roles has
     *                 the userCardView permission and the card grids are
     * requested in
     *                 the parameters, then the grids are
     *                 returned along with the card information. Otherwise,
     * the card grids are not returned.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userCardGet permission.
     *                 2. A fault with a USER_NOT_EXIST error code, if the
     * user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     */
    public UserCardInfo[] userCardGet(UserCardGetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Update cards for the given user that match the given filter,
     * returning the number of cards that were updated.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userCardSet permission and a group list that grants
     * access to the
     *                 user's group. Additionally, if the user is an administrator,
     * one
     *                 of these roles must also have a role list that grants
     * access to
     *                 all of the administrator's roles. If either of the
     * card
     *                 lifetime, supersede lifetime, challenge count or least
     * used
     *                 cell count are specified, one of the roles meeting
     * the previous
     *                 conditions must have userCardOverridePolicy permission
     * too.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the permissions described above.
     * 2. A fault with a USER_NOT_EXIST error code, if the user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     *                 4. A fault with an INVALID_ARGUMENT error code, if
     * the temporary
     *                 card lifetime or supersede lifetime is outside the
     * acceptable range.
     *                 5. A fault with an INVALID_CARD_STATE error code,
     * if an attempt
     *                 is made to move a card through an invalid state transition,
     * e.g.
     *                 change a CANCELED card to a state other than CANCELED,
     * or move
     *                 a CURRENT or HOLD card to the PENDING or HOLD_PENDING
     * state.
     *                 This error will also occur if an attempt is made to
     * put more
     *                 than one card in either of the CURRENT or HOLD states.
     */
    public int userCardSet(UserCardSetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Unassign the cards for the given user that match the given
     * filter,
     *                 returning the number of cards that were unassigned.
     * Unassigned cards are moved to the preproduced card list and can
     *                 be assigned to other users. Only
     *                 cards in the PENDING or HOLD_PENDING states that were
     * originally
     *                 preproduced cards can be unassigned.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userCardUnassign permission and a group list that
     * grants access to the
     *                 user's group. Additionally, if the user is an administrator,
     * one
     *                 of these roles must also have a role list that grants
     * access to
     *                 all of the administrator's roles.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the permissions described above.
     * 2. A fault with a USER_NOT_EXIST error code, if the user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     *                 4. A fault with an INVALID_CARD_STATE error code,
     * if an attempt
     *                 is made to unassign a card that was not originally
     * preproduced
     *                 or is not in the PENDING or HOLD_PENDING state.
     */
    public int userCardUnassign(com.good.adapters.entrust.stubs.UserCardUnassignCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * List cards that match the given search filter. The returned
     * list
     *                 of cards will not be in any particular order.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userCardList permission. Cards matching the filter
     * are only
     *                 returned if the user that owns them is accessible
     * to the caller using the roles
     *                 with userCardList permission and the access rules
     * described for the
     *                 userGet operation. Card grids are only returned if
     * the role granting
     *                 access to the user also has userCardView permission
     * and the
     *                 grids are requested in the parameters.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userCardList permission.
     *                 2. A fault with an OBJECT_NOT_EXIST error code, if
     * any of the
     *                 groups, roles, or token vendor IDs specified in the
     * search
     *                 filter do not exist, or access to them is not granted
     * by
     *                 the user's roles with userCardList permission.
     */
    public UserCardListResult userCardList(UserCardListCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Export cards that match the given search filter to a file on
     * the
     *                 server, returning the number of cards exported and
     * the file
     *                 they were exported to.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userCardExport permission. Cards matching the filter
     * are only
     *                 exported if the user that owns them is accessible
     * to the caller using the roles
     *                 with userCardExport permission and the access rules
     * described for the
     *                 userGet operation.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userCardList permission.
     *                 2. A fault with an OBJECT_NOT_EXIST error code, if
     * any of the
     *                 groups, roles, or token vendor IDs specified in the
     * search
     *                 filter do not exist, or access to them is not granted
     * by
     *                 the user's roles with userCardExport permission.
     */
    public CardExportResult userCardExport(com.good.adapters.entrust.stubs.UserCardExportCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Assign a token to the given user.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userTokenAssign permission and a group list that grants
     * access to the
     *                 user's group. Additionally, if the user is an administrator,
     * one
     *                 of these roles must also have a role list that grants
     * access to
     *                 all of the administrator's roles.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userTokenAssign permission.
     * 2. A fault with a USER_NOT_EXIST error code, if the user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     *                 4. A fault with a TOKEN_EXIST error code, if the user
     * already has
     *                 a token in the PENDING or HOLD_PENDING states.
     *                 5. A fault with a TOKEN_NOT_EXIST error code, if an
     * unassigned
     *                 token with the given serial number does not exist.
     * 6. A fault with an OBJECT_NOT_EXIST error code, if the
     *                 given token vendor ID does not exist.
     *                 7. A fault with an INVALID_ARGUMENT error code, if
     * the
     *                 token being assigned does not belong to the same group
     * as the
     *                 user.
     *                 8. A fault with an INVALID_TOKEN_STATE error code,
     * if an attempt
     *                 is made to assign a token in the CURRENT or HOLD state
     * when
     *                 the user already has a token in the CURRENT or HOLD
     * state.
     */
    public void userTokenAssign(com.good.adapters.entrust.stubs.UserTokenAssignCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Creates a new soft token for the given user, and returns
     *                 the serial number of the token that was created. Entrust
     * IdentityGuard
     *                 systems must be explicitly licensed for soft tokens
     * in order to
     *                 use this functionality. Once created, tokens are placed
     * in the
     *                 CREATED activation state, and must be activated using
     * userTokenActivate then userTokenActivateComplete before they can
     *                 be used for authentication.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userTokenCreate permission and a group list that grants
     * access to the
     *                 user's group. Additionally, if the user is an administrator,
     * one
     *                 of these roles must also have a role list that grants
     * access to
     *                 all of the administrator's roles.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userTokenCreate permission,
     * or the
     *                 system is not licensed to use soft tokens.
     *                 2. A fault with a USER_NOT_EXIST error code, if the
     * user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     *                 4. A fault with a TOKEN_EXIST error code, if the user
     * already has
     *                 a token in the PENDING or HOLD_PENDING states, or
     * the given 
     *                 token serial number has already been used by another
     * token.
     *                 5. A fault with an OBJECT_NOT_EXIST error code, if
     * the
     *                 given token vendor ID does not exist.
     *                 6. A fault with an INVALID_TOKEN_STATE error code,
     * if an attempt
     *                 is made to create a token in the CURRENT or HOLD state
     * when
     *                 the user already has a token in the CURRENT or HOLD
     * state, or
     *                 an attempt is made to create a token in the CANCELED
     * state.
     */
    public String userTokenCreate(com.good.adapters.entrust.stubs.UserTokenCreateCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Delete the tokens for the given user that match the given filter,
     * returning the number of tokens deleted.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userTokenDelete permission and a group list that grants
     * access to the
     *                 user's group. Additionally, if the user is an administrator,
     * one
     *                 of these roles must also have a role list that grants
     * access to
     *                 all of the administrator's roles.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userTokenDelete permission.
     * 2. A fault with a USER_NOT_EXIST error code, if the user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     *                 4. A fault with a TOKEN_NOT_EXIST error code, if none
     * of the user's
     *                 tokens match the given filter.
     */
    public int userTokenDelete(com.good.adapters.entrust.stubs.UserTokenDeleteCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Return tokens for the given user that match the given filter.
     * <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userTokenGet permission and a group list that grants
     * access to the
     *                 user's group. Additionally, if the user is an administrator,
     * one
     *                 of these roles must also have a role list that grants
     * access to
     *                 all of the administrator's roles.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userTokenGet permission.
     *                 2. A fault with a USER_NOT_EXIST error code, if the
     * user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     */
    public UserTokenInfo[] userTokenGet(UserTokenGetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Update tokens for the given user that match the given filter,
     * returning the number of tokens that were updated.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userTokenSet permission and a group list that grants
     * access to the
     *                 user's group. Additionally, if the user is an administrator,
     * one
     *                 of these roles must also have a role list that grants
     * access to
     *                 all of the administrator's roles.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userTokenSet permission.
     *                 2. A fault with a USER_NOT_EXIST error code, if the
     * user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     *                 4. A fault with an INVALID_TOKEN_STATE error code,
     * if an attempt
     *                 is made to move a token through an invalid state transition,
     * e.g.
     *                 change a CANCELED token to a state other than CANCELED,
     * or move
     *                 a CURRENT or HOLD token to the PENDING or HOLD_PENDING
     * state.
     *                 This error will also occur if an attempt is made to
     * put more
     *                 than one token in either of the CURRENT or HOLD states.
     */
    public int userTokenSet(UserTokenSetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Unassign the tokens for the given user that match the given
     * filter,
     *                 returning the number of tokens that were unassigned.
     * The tokens that being unassigned are moved to the unassigned token
     * list.
     *                 There is no token state limitation for token unassign
     * operation; user
     *                 tokens in any states can be unassigned.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userTokenUnassign permission and a group list that
     * grants access to the
     *                 user's group. Additionally, if the user is an administrator,
     * one
     *                 of these roles must also have a role list that grants
     * access to
     *                 all of the administrator's roles.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userTokenUnassign permission.
     * 2. A fault with a USER_NOT_EXIST error code, if the user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     *                 4. A fault with an TOKEN_NOT_EXIST error code, if
     * no tokens
     *                 match the given search filter.
     */
    public int userTokenUnassign(com.good.adapters.entrust.stubs.UserTokenUnassignCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Get a token challenge for the token specified by the
     *                 given filter. The challenge will be retained until
     * successfully
     *                 answered.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userTokenAuthenticate permission and a group list
     * that grants access to the
     *                 user's group. Additionally, if the user is an administrator,
     * one
     *                 of these roles must also have a role list that grants
     * access to
     *                 all of the administrator's roles.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userTokenAuthenticate permission.
     * 2. A fault with a USER_NOT_EXIST error code, if the user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     *                 4. A fault with a TOKEN_NOT_EXIST error code, if none
     * of the
     *                 user's tokens match the filter.
     *                 5. A fault with an INVALID_ARGUMENT error code, if
     * more than
     *                 one token matches the filter.
     *                 6. A fault with a NOT_SUPPORTED error code, if the
     * token
     *                 does not support challenges.
     */
    public String userTokenChallengeGet(com.good.adapters.entrust.stubs.UserTokenChallengeGetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Authenticate the response against the token specified by the
     * given filter. A successful authentication will not change the
     *                 token state. An error is returned if the token does
     * not
     *                 authenticate.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userTokenAuthenticate permission and a group list
     * that grants access to the
     *                 user's group. Additionally, if the user is an administrator,
     * one
     *                 of these roles must also have a role list that grants
     * access to
     *                 all of the administrator's roles.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userTokenAuthenticate permission.
     * 2. A fault with a USER_NOT_EXIST error code, if the user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     *                 4. A fault with a TOKEN_NOT_EXIST error code, if none
     * of the
     *                 user's tokens match the filter.
     *                 5. A fault with an INVALID_ARGUMENT error code, if
     * more than
     *                 one token matches the filter.
     *                 6. A fault with an INVALID_RESPONSE error code, if
     * the response
     *                 is not correct.
     */
    public String userTokenAuthenticate(com.good.adapters.entrust.stubs.UserTokenAuthenticateCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Authenticate the response against the token specified by the
     * given filter using a previously generated challenge.
     *                 A successful authentication will not change the
     *                 token state. This call should only be made after a
     * matching
     *                 call to userTokenChallengeGet.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userTokenAuthenticate permission and a group list
     * that grants access to the
     *                 user's group. Additionally, if the user is an administrator,
     * one
     *                 of these roles must also have a role list that grants
     * access to
     *                 all of the administrator's roles.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userTokenAuthenticate permission.
     * 2. A fault with a USER_NOT_EXIST error code, if the user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     *                 4. A fault with a TOKEN_NOT_EXIST error code, if none
     * of the
     *                 user's tokens match the filter.
     *                 5. A fault with an INVALID_ARGUMENT error code, if
     * more than
     *                 one token matches the filter.
     *                 6. A fault with a NOT_SUPPORTED error code, if
     *                 the token does not support challenges.
     *                 7. A fault with a CHALLENGE_NOT_EXIST error code,
     * if
     *                 there is no retained token challenge. This
     *                 will occur if no prior call was made to userTokenChallengeGet.
     * 8. A fault with an INVALID_RESPONSE error code, if the response
     *                 to the challenge is not correct.
     */
    public String userTokenChallengeAuthenticate(com.good.adapters.entrust.stubs.UserTokenChallengeAuthenticateCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Unlock the specified token using the given challenge
     *                 generated by the token.  The server will return an
     * unlock code
     *                 which must be entered into the token to complete the
     * unlock
     *                 operation.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userTokenUnlock permission and a group list that grants
     * access to the
     *                 user's group. Additionally, if the user is an administrator,
     * one
     *                 of these roles must also have a role list that grants
     * access to
     *                 all of the administrator's roles.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userTokenUnlock permission.
     * 2. A fault with a USER_NOT_EXIST error code, if the user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     *                 4. A fault with a TOKEN_NOT_EXIST error code, if none
     * of the
     *                 user's tokens match the filter.
     *                 5. A fault with an INVALID_ARGUMENT error code, if
     * more than
     *                 one token matches the filter, or the unlock challenge
     * is not
     *                 valid.
     *                 6. A fault with a NOT_SUPPORTED error code, if
     *                 the token does not support the unlock operation.
     */
    public UserTokenUnlockResult userTokenUnlock(com.good.adapters.entrust.stubs.UserTokenUnlockCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Return the next response for the specified token.  If a
     *                 challenge is specified, return the TOKENCR response
     * otherwise
     *                 return the TOKENRO response.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userTokenResponseGet permission and a group list that
     * grants access to the
     *                 user's group. Additionally, if the user is an administrator,
     * one
     *                 of these roles must also have a role list that grants
     * access to
     *                 all of the administrator's roles.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userTokenResponseGet permission.
     * 2. A fault with a USER_NOT_EXIST error code, if the user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     *                 4. A fault with a TOKEN_NOT_EXIST error code, if none
     * of the
     *                 user's tokens match the filter.
     *                 5. A fault with an INVALID_ARGUMENT error code, if
     * more than
     *                 one token matches the filter.
     *                 6. A fault with a NOT_SUPPORTED error code, if
     *                 the token does not support the ability to return a
     * token
     *                 response or if a challenge is specified for a token
     * that does not support TOKENCR.
     */
    public UserTokenResponse userTokenResponseGet(com.good.adapters.entrust.stubs.UserTokenResponseGetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Generate an activation code for the specified token. This only
     * needs
     *                 to be called for tokens that support activation, which
     * generally
     *                 means software tokens. This call may only be made
     * for tokens
     *                 in the CREATED or ACTIVATION_CODE_GENERATED activation
     * state.
     *                 After activation codes have been generated, the token
     * is placed
     *                 in the ACTIVATION_CODE_GENERATED activation state,
     * and 
     *                 userTokenActivateComplete must be called to complete
     * the activation process and allow the token to be used for
     *                 authentication. Generating activation codes for tokens
     * that are
     *                 already activated is not supported.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userTokenActivate permission and a group list that
     * grants access to the
     *                 user's group. Additionally, if the user is an administrator,
     * one
     *                 of these roles must also have a role list that grants
     * access to
     *                 all of the administrator's roles.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userTokenActivate permission.
     * 2. A fault with a USER_NOT_EXIST error code, if the user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     *                 4. A fault with a TOKEN_NOT_EXIST error code, if none
     * of the
     *                 user's tokens match the filter.
     *                 5. A fault with an INVALID_ARGUMENT error code, if
     * more than
     *                 one token matches the filter.
     *                 6. A fault with a NOT_SUPPORTED error code, if
     *                 the token does not support the activation operation,
     * or if the
     *                 token is in the ACTIVATED activation state.
     */
    public com.good.adapters.entrust.stubs.UserTokenActivateResult userTokenActivate(com.good.adapters.entrust.stubs.UserTokenActivateCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Complete the activation of the specified token. This must be
     * called after calling userTokenActivate to complete the
     *                 activation process, and move the token to the ACTIVATED
     * activation state. A token that requires activation cannot be
     *                 used for authentication until this call has completed
     * successfully.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userTokenActivate permission and a group list that
     * grants access to the
     *                 user's group. Additionally, if the user is an administrator,
     * one
     *                 of these roles must also have a role list that grants
     * access to
     *                 all of the administrator's roles.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userTokenActivate permission.
     * 2. A fault with a USER_NOT_EXIST error code, if the user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     *                 4. A fault with a TOKEN_NOT_EXIST error code, if none
     * of the
     *                 user's tokens match the filter.
     *                 5. A fault with an INVALID_ARGUMENT error code, if
     * more than
     *                 one token matches the filter, or the registration
     * code is not
     *                 valid.
     *                 6. A fault with a NOT_SUPPORTED error code, if
     *                 the token does not support the activation operation,
     * or if it
     *                 is already in the ACTIVATED activation state.
     */
    public com.good.adapters.entrust.stubs.UserTokenActivateCompleteResult userTokenActivateComplete(com.good.adapters.entrust.stubs.UserTokenActivateCompleteCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * List tokens that match the given search filter. The returned
     * list
     *                 of tokens will not be in any particular order.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userTokenList permission. Tokens matching the filter
     * are only
     *                 returned if the user that owns them is accessible
     * to the caller using the roles
     *                 with userTokenList permission and the access rules
     * described for the
     *                 userGet operation.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userTokenList permission.
     *                 2. A fault with an OBJECT_NOT_EXIST error code, if
     * any of the
     *                 groups, roles, or token vendor IDs specified in the
     * search
     *                 filter do not exist, or access to them is not granted
     * by
     *                 the user's roles with userTokenList permission.
     */
    public UserTokenListResult userTokenList(UserTokenListCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Creates a new Smart Credential for the given user, and returns
     * the Id of the Smart Credential that was created.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must
     *                 have the userSmartCredentialCreate permission, a group
     * list
     *                 that grants access to the user's group and a Smart
     * Credential
     *                 Definition list that grants access to the Definition
     * of the
     *                 Smart Credential. If enrollment values for the Smart
     * Credential
     *                 are being set the administrator must have the
     *                 userSmartCredentialSetEnrollmentValues permission.
     * Additionally, if the user is an administrator, one of these
     *                 roles must also have a role list that grants access
     * to all of
     *                 the administrator's roles.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userSmartCredentialCreate
     * permission.
     *                 2. A fault with a USER_NOT_EXIST error code, if the
     * user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     *                 4. A fault with an OBJECT_NOT_EXIST error code, if
     * the
     *                 given Definition ID does not exist or the administrator
     * does
     *                 not have have access to the specified Definition.
     */
    public String userSmartCredentialCreate(com.good.adapters.entrust.stubs.UserSmartCredentialCreateCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Delete the specified Smart Credential for the given user.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userSmartCredentialDelete permission, a group list
     * that grants access to the
     *                 user's group and a Smart Credential Definition list
     * that grants access to the
     *                 Smart Credential's Definition . Additionally, if the
     * user is an administrator, one
     *                 of these roles must also have a role list that grants
     * access to
     *                 all of the administrator's roles.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userSmartCredentialDelete
     * permission.
     *                 2. A fault with a USER_NOT_EXIST error code, if the
     * user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     *                 4. A fault with a OBJECT_NOT_EXIST error code, if
     * the
     *                 specified Id does not exist or the administrator
     *                 does not have access to it's Definition Id.
     */
    public void userSmartCredentialDelete(com.good.adapters.entrust.stubs.UserSmartCredentialDeleteCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Return the specified Smart Credential for the specified user.
     * <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userSmartCredentialGet permission, a group list that
     * grants access to the
     *                 user's group and a Smart Credential Definition list
     * that grants access to
     *                 the Smart Credential's Definition. Additionally, if
     * the user is an administrator, one
     *                 of these roles must also have a role list that grants
     * access to
     *                 all of the administrator's roles.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userSmartCredentialGet permission.
     * 2. A fault with a USER_NOT_EXIST error code, if the user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a OBJECT_NOT_EXIST error code, if
     * the specified
     *                 Smart Credential does not exist or the administrator
     * does not have
     *                 access to the Smart Credential's Definition.
     *                 4. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     */
    public com.good.adapters.entrust.stubs.UserSmartCredentialInfo userSmartCredentialGet(com.good.adapters.entrust.stubs.UserSmartCredentialGetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Authenticate the challenge previously returned from
     *                 userSmartCredentialChallengeGet against the response
     * provided
     *                 from the smart credential for the user smart
     *                 credential with the given userid and id.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the
     *                 userSmartCredentialChallengeAuthenticate permission
     * and a group
     *                 list that grants access to the group that the smart
     * credential
     *                 being retrieved belongs to.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userSmartCredentialChallengeAuthenticate
     * permission.
     *                 2. A fault with an INVALID_ARGUMENT error code, if
     * the given
     *                 id is not a valid smart credential id.
     *                 3. A fault with a OBJECT_NOT_EXIST error code, if
     * the given
     *                 smart credential does not exist, or belongs to a group
     * that the
     *                 caller does not have access to.
     */
    public byte[] userSmartCredentialChallengeGet(com.good.adapters.entrust.stubs.UserSmartCredentialChallengeGetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Return an authentication challenge for the user smart
     *                 credential with the given userid and id.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the
     *                 userSmartCredentialChallengeAuthenticate permission
     * and a group
     *                 list that grants access to the group that the smart
     * credential
     *                 being retrieved belongs to.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userSmartCredentialChallengeAuthenticate
     * permission.
     *                 2. A fault with an INVALID_ARGUMENT error code, if
     * the given
     *                 id is not a valid smart credential id.
     *                 3. A fault with a OBJECT_NOT_EXIST error code, if
     * the given
     *                 smart credential does not exist, or belongs to a group
     * that the
     *                 caller does not have access to.
     */
    public byte[] userSmartCredentialChallengeAuthenticate(com.good.adapters.entrust.stubs.UserSmartCredentialChallengeAuthenticateCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Get a challenge for the specified user smart credential
     *                 that can be used to generate a response to be validated
     * by a call to userSmartCredentialValidate.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the
     *                 userSmartCredentialValidate permission and a group
     * list that grants access to the group that the smart credential
     *                 being retrieved belongs to.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userSmartCredentialValidate
     * permission.
     *                 2. A fault with an INVALID_ARGUMENT error code, if
     * the given
     *                 id is not a valid smart credential id or the required
     * request and response arguments or not specified.
     *                 3. A fault with a OBJECT_NOT_EXIST error code, if
     * the given
     *                 smart credential does not exist, or belongs to a group
     * that the
     *                 caller does not have access to.
     */
    public com.good.adapters.entrust.stubs.UserSmartCredentialChallengeResult userSmartCredentialChallenge(com.good.adapters.entrust.stubs.UserSmartCredentialChallengeCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Validate that the specified response is the signature of
     *                 the specified challenge generated by a private key
     * associated
     *                 with the specified smart credential.  The challenge
     * can
     *                 be generated by calling userSmartCredentialChallenge.
     * <p>
     *                 Callers of this operation must have a role that has
     * the
     *                 userSmartCredentialValidate permission and a group
     * list that grants access to the group that the smart credential
     *                 being retrieved belongs to.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userSmartCredentialValidate
     * permission.
     *                 2. A fault with an INVALID_ARGUMENT error code, if
     * the given
     *                 id is not a valid smart credential id or the required
     * request and response arguments or not specified.
     *                 3. A fault with a OBJECT_NOT_EXIST error code, if
     * the given
     *                 smart credential does not exist, or belongs to a group
     * that the
     *                 caller does not have access to.
     */
    public void userSmartCredentialValidate(com.good.adapters.entrust.stubs.UserSmartCredentialValidateCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Validate that the specified response is the signature of
     *                 the specified transaction generated by a private key
     * associated
     *                 with the specified smart credential.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the
     *                 userSmartCredentialTransactionValidate permission
     * and a group
     *                 list that grants access to the group that the smart
     * credential
     *                 being retrieved belongs to.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userSmartCredentialTransactionValidate
     * permission.
     *                 2. A fault with an INVALID_ARGUMENT error code, if
     * the given
     *                 id is not a valid smart credential id or the required
     * transaction arguments are not specified.
     *                 3. A fault with a OBJECT_NOT_EXIST error code, if
     * the given
     *                 smart credential does not exist, or belongs to a group
     * that the
     *                 caller does not have access to.
     */
    public void userSmartCredentialTransactionValidate(com.good.adapters.entrust.stubs.UserSmartCredentialTransactionValidateCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Start the process of signing a given digest with the
     *                 private key associated with the specified smart credential.
     * <p>
     *                 Callers of this operation must have a role that has
     * the
     *                 userSmartCredentialSign permission and a group
     *                 list that grants access to the group that the smart
     * credential
     *                 being retrieved belongs to.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userSmartCredentialSign
     *                 permission.
     *                 2. A fault with an INVALID_ARGUMENT error code, if
     * the given
     *                 id is not a valid smart credential id or the required
     * arguments are not specified.
     *                 3. A fault with a OBJECT_NOT_EXIST error code, if
     * the given
     *                 smart credential does not exist, or belongs to a group
     * that the
     *                 caller does not have access to.
     */
    public com.good.adapters.entrust.stubs.UserSmartCredentialSignStartResult userSmartCredentialSignStart(com.good.adapters.entrust.stubs.UserSmartCredentialSignStartCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Complete the process of signing a given digest with the
     *                 private key associated with the specified smart credential.
     * <p>
     *                 Callers of this operation must have a role that has
     * the
     *                 userSmartCredentialSign permission and a group
     *                 list that grants access to the group that the smart
     * credential
     *                 being retrieved belongs to.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userSmartCredentialSign
     *                 permission.
     *                 2. A fault with an INVALID_ARGUMENT error code, if
     * the given
     *                 id is not a valid smart credential id or the required
     * arguments are not specified.
     *                 3. A fault with a OBJECT_NOT_EXIST error code, if
     * the given
     *                 smart credential does not exist, or belongs to a group
     * that the
     *                 caller does not have access to.
     */
    public com.good.adapters.entrust.stubs.UserSmartCredentialSignCompleteResult userSmartCredentialSignComplete(com.good.adapters.entrust.stubs.UserSmartCredentialSignCompleteCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Update the specified Smart Credential for the given user.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must
     *                 have the userSmartCredentialSet permission, a group
     * list that
     *                 grants access to the user's group and a Smart Credential
     * Definition list that grants access to the Smart Credential's
     *                 Definition. If the Smart Credential's enrollment values
     * are
     *                 being modified, the administrator must have the
     *                 userSmartCrentialSetEnrollmentValues permission. 
     * If the Smart
     *                 Credential's approval flag is being modified the administrator
     * must have the userSmartCredentialSetApproval permission.  If
     *                 the Smart Credential's sealed flag is being modified
     * the
     *                 administrator must have the userSmartCredentialSetSealed
     * permission.  Additionally, if the user is an administrator, one
     *                 of these roles must also have a role list that grants
     * access to
     *                 all of the administrator's roles.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userSmartCredentialSet permission.
     * 2. A fault with a USER_NOT_EXIST error code, if the user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a OBJECT_NOT_EXIST error code, if
     * the specified
     *                 Smart Credential does not exist or the administrator
     * does not have
     *                 access to the Smart Credential's Definition.
     *                 4. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     */
    public void userSmartCredentialSet(com.good.adapters.entrust.stubs.UserSmartCredentialSetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Unblock the Smart Credential for the given user using the
     *                 specified unblock variable and challenge.  The server
     * will
     *                 return an unblock code which must be entered into
     * the Smart
     *                 Credential to complete the unblock operation.  If
     * a delivery
     *                 configuration is specified, the unblock response is
     * delivered.
     *                 If a delivery configuration is specified it must be
     * allowed
     *                 by the definition of the user smart credential and
     * it must
     *                 have the type UNBLOCK.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userSmartCredentialUnBlock permission, a group list
     * that grants access to the
     *                 user's group and a Smart Credential Definition list
     * that grants access to
     *                 the Smart Credential's Definition. Additionally, if
     * the user is an administrator, one
     *                 of these roles must also have a role list that grants
     * access to
     *                 all of the administrator's roles.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userSmartCredentialUnBlock
     * permission.
     *                 2. A fault with a USER_NOT_EXIST error code, if the
     * user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a OBJECT_NOT_EXIST error code, if
     * the specified
     *                 Smart Credential does not exist or the administrator
     * does not have
     *                 access to the Smart Credential's Definition.
     *                 4. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     *                 5. A fault with a NOT_SUPPORTED error code, if
     *                 the Smart Credential does not support the unblock
     * operation.
     */
    public com.good.adapters.entrust.stubs.UserSmartCredentialUnblockResult userSmartCredentialUnblock(com.good.adapters.entrust.stubs.UserSmartCredentialUnblockCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Create/Recover a digital Id for the Smart Credential for the
     * given user using the specified parameters.  The server will
     *                 return a reference number and authcode that the client
     * can
     *                 use to perform PKIX-CMP operations to create/recover
     * certificates.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userSmartCredentialDigitalIdCreateRecover permission,
     * a group list that grants access to the
     *                 user's group and a Smart Credential Definition list
     * that grants access to
     *                 the Smart Credential's Definition. Additionally, if
     * the user is an administrator, one
     *                 of these roles must also have a role list that grants
     * access to
     *                 all of the administrator's roles.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userSmartCredentialDigitalIdCreateRecover
     * permission.
     *                 2. A fault with a USER_NOT_EXIST error code, if the
     * user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a OBJECT_NOT_EXIST error code, if
     * the specified
     *                 Smart Credential does not exist or the administrator
     * does not have
     *                 access to the Smart Credential's Definition.
     *                 4. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     */
    public com.good.adapters.entrust.stubs.UserDigitalIdCreateRecoverResult userSmartCredentialDigitalIdCreateRecover(com.good.adapters.entrust.stubs.UserSmartCredentialDigitalIdCreateRecoverCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Create a token for the specified user smart credential.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userSmartCredentialTokenCreate permission, a group
     * list that grants access to the
     *                 user's group and a Smart Credential Definition list
     * that grants access to
     *                 the Smart Credential's Definition. Additionally, if
     * the user is an administrator, one
     *                 of these roles must also have a role list that grants
     * access to
     *                 all of the administrator's roles.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userSmartCredentialTokenCreate
     * permission.
     *                 2. A fault with a USER_NOT_EXIST error code, if the
     * user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a OBJECT_NOT_EXIST error code, if
     * the specified
     *                 Smart Credential does not exist or the administrator
     * does not have
     *                 access to the Smart Credential's Definition.
     *                 4. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     */
    public UserTokenInfo userSmartCredentialTokenCreate(com.good.adapters.entrust.stubs.UserSmartCredentialTokenCreateCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Get status information for the Smart Credential from the PACS
     * assigned to its Smart Credential Definition.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userSmartCredentialPACSGet permission, a group list
     * that grants access to the
     *                 user's group and a Smart Credential Definition list
     * that grants access to
     *                 the Smart Credential's Definition. Additionally, if
     * the user is an administrator, one
     *                 of these roles must also have a role list that grants
     * access to
     *                 all of the administrator's roles.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userSmartCredentialPACSGet
     * permission.
     *                 2. A fault with a USER_NOT_EXIST error code, if the
     * user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a OBJECT_NOT_EXIST error code, if
     * the specified
     *                 Smart Credential does not exist or the administrator
     * does not have
     *                 access to the Smart Credential's Definition.
     *                 4. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     *                 5. A fault with a NOT_SUPPORTED error code, if no
     * PACS
     *                 are associated with the Smart Credential definition
     * of the
     *                 Smart Credential.
     */
    public com.good.adapters.entrust.stubs.UserSmartCredentialPACSGetResult userSmartCredentialPACSGet(com.good.adapters.entrust.stubs.UserSmartCredentialPACSGetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Register the Smart Credential in the PACS assigned to its
     *                 Smart Credential Definition.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userSmartCredentialPACSRegister permission, a group
     * list that grants access to the
     *                 user's group and a Smart Credential Definition list
     * that grants access to
     *                 the Smart Credential's Definition. Additionally, if
     * the user is an administrator, one
     *                 of these roles must also have a role list that grants
     * access to
     *                 all of the administrator's roles.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userSmartCredentialPACSRegister
     * permission.
     *                 2. A fault with a USER_NOT_EXIST error code, if the
     * user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a OBJECT_NOT_EXIST error code, if
     * the specified
     *                 Smart Credential does not exist or the administrator
     * does not have
     *                 access to the Smart Credential's Definition.
     *                 4. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     */
    public void userSmartCredentialPACSRegister(com.good.adapters.entrust.stubs.UserSmartCredentialPACSRegisterCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Suspend the Smart Credential from the PACS assigned to its
     *                 Smart Credential Definition.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userSmartCredentialPACSSuspend permission, a group
     * list that grants access to the
     *                 user's group and a Smart Credential Definition list
     * that grants access to
     *                 the Smart Credential's Definition. Additionally, if
     * the user is an administrator, one
     *                 of these roles must also have a role list that grants
     * access to
     *                 all of the administrator's roles.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userSmartCredentialPACSSuspend
     * permission.
     *                 2. A fault with a USER_NOT_EXIST error code, if the
     * user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a OBJECT_NOT_EXIST error code, if
     * the specified
     *                 Smart Credential does not exist or the administrator
     * does not have
     *                 access to the Smart Credential's Definition.
     *                 4. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     */
    public void userSmartCredentialPACSSuspend(com.good.adapters.entrust.stubs.UserSmartCredentialPACSSuspendCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Unassign the Smart Credential associated with the given user.
     * A smart credential can only be unassigned if an unassigned
     *                 smart credential has previously been assigned to it.
     * operation.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userSmartCredentialUnassign permission, a group list
     * that grants access to the
     *                 user's group and a Smart Credential Definition list
     * that grants access to
     *                 the Smart Credential's Definition. Additionally, if
     * the user is an administrator, one
     *                 of these roles must also have a role list that grants
     * access to
     *                 all of the administrator's roles.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userSmartCredentialUnassign
     * permission.
     *                 2. A fault with a USER_NOT_EXIST error code, if the
     * user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a OBJECT_NOT_EXIST error code, if
     * the specified
     *                 Smart Credential does not exist or the administrator
     * does not have
     *                 access to the Smart Credential's Definition.
     *                 4. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     *                 5. A fault with a NOT_SUPPORTED error code, if
     *                 the Smart Credential does not support the unassign
     * operation.
     */
    public void userSmartCredentialUnassign(com.good.adapters.entrust.stubs.UserSmartCredentialUnassignCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Cancel the Smart Credential associated with the given user.
     * The cancel operation revokes all certificates associated
     *                 with the smart credential.  By default, only certificates
     * not shared with other smart credentials are revoked.  If
     *                 the force option is specified, all certificates are
     * revoked.
     *                 The number of certificates revoked is returned.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userSmartCredentialCancel permission, a group list
     * that grants access to the
     *                 user's group and a Smart Credential Definition list
     * that grants access to
     *                 the Smart Credential's Definition. Additionally, if
     * the user is an administrator, one
     *                 of these roles must also have a role list that grants
     * access to
     *                 all of the administrator's roles.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userSmartCredentialCancel
     * permission.
     *                 2. A fault with a USER_NOT_EXIST error code, if the
     * user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a OBJECT_NOT_EXIST error code, if
     * the specified
     *                 Smart Credential does not exist or the administrator
     * does not have
     *                 access to the Smart Credential's Definition.
     *                 4. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     */
    public int userSmartCredentialCancel(com.good.adapters.entrust.stubs.UserSmartCredentialCancelCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Hold the Smart Credential associated with the given user.
     *                 The hold operation revokes all certificates associated
     * with the smart credential for hold.  By default, only
     *                 certificates not shared with other smart credentials
     * are
     *                 revoked for hold.  If the force option is specified,
     * all
     *                 certificates are revoked for hold.
     *                 The number of certificates revoked for hold is returned.
     * <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userSmartCredentialHold permission, a group list that
     * grants access to the
     *                 user's group and a Smart Credential Definition list
     * that grants access to
     *                 the Smart Credential's Definition. Additionally, if
     * the user is an administrator, one
     *                 of these roles must also have a role list that grants
     * access to
     *                 all of the administrator's roles.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userSmartCredentialHold permission.
     * 2. A fault with a USER_NOT_EXIST error code, if the user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a OBJECT_NOT_EXIST error code, if
     * the specified
     *                 Smart Credential does not exist or the administrator
     * does not have
     *                 access to the Smart Credential's Definition.
     *                 4. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     */
    public int userSmartCredentialHold(com.good.adapters.entrust.stubs.UserSmartCredentialHoldCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Unhold the Smart Credential associated with the given user.
     * The unhold operation unrevokes all certificates associated
     *                 with the smart credential that were previously revoked
     * for
     *                 hold.  By default, only
     *                 certificates not shared with other smart credentials
     * are
     *                 unrevoked.  If the force option is specified, all
     *                 certificates are unrevoked.
     *                 The number of certificates unrevoked is returned.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userSmartCredentialUnhold permission, a group list
     * that grants access to the
     *                 user's group and a Smart Credential Definition list
     * that grants access to
     *                 the Smart Credential's Definition. Additionally, if
     * the user is an administrator, one
     *                 of these roles must also have a role list that grants
     * access to
     *                 all of the administrator's roles.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userSmartCredentialUnhold
     * permission.
     *                 2. A fault with a USER_NOT_EXIST error code, if the
     * user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a OBJECT_NOT_EXIST error code, if
     * the specified
     *                 Smart Credential does not exist or the administrator
     * does not have
     *                 access to the Smart Credential's Definition.
     *                 4. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     */
    public int userSmartCredentialUnhold(com.good.adapters.entrust.stubs.UserSmartCredentialUnholdCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Issue the specified Smart Credential for the given user to
     *                 the specified print module.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userSmartCredentialPrint or userSmartCredentialEncode
     * permission, a group list that grants access to the
     *                 user's group, a Smart Credential Definition list that
     * grants access to
     *                 the Smart Credential's Definition and a Smart Credential
     * print module list that grants
     *                 access to the print module. Additionally, if the user
     * is an administrator, one
     *                 of these roles must also have a role list that grants
     * access to
     *                 all of the administrator's roles.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userSmartCredentialPrint or
     * the userSmartCredentialEncode permission.
     *                 2. A fault with a USER_NOT_EXIST error code, if the
     * user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a OBJECT_NOT_EXIST error code, if
     * the specified
     *                 Smart Credential does not exist, the administrator
     * does not have
     *                 access to the Smart Credential's Definition, the specified
     * print module does
     *                 not exist or the administrator does not have access
     * to the
     *                 print module.
     *                 4. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     *                 5. A fault with a NOT_SUPPORTED error code, if
     *                 the Smart Credential does not support the print operation.
     */
    public void userSmartCredentialIssue(com.good.adapters.entrust.stubs.UserSmartCredentialIssueCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Deliver the specified Smart Credential for the given user to
     * the specified delivery configuration.  The specified delivery
     *                 configuration must be allowed by the definition of
     * the user
     *                 smart credential and must not have the type UNBLOCK.
     * <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userSmartCredentialDeliver permission, a group list
     * that grants access to the
     *                 user's group and a Smart Credential Definition list
     * that grants access to
     *                 the Smart Credential's Definition.
     *                 Additionally, if the user is an administrator, one
     * of these roles must also have a role list that grants access to
     *                 all of the administrator's roles.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userSmartCredentialDeliver
     * permission.
     *                 2. A fault with a USER_NOT_EXIST error code, if the
     * user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a OBJECT_NOT_EXIST error code, if
     * the specified
     *                 Smart Credential does not exist, the administrator
     * does not have
     *                 access to the Smart Credential's Definition or the
     * specified
     *                 delivery configuration does not exist.
     *                 4. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     *                 5. A fault with a NOT_SUPPORTED error code, if
     *                 the Smart Credential does not support the specific
     * delivery
     *                 configuration.
     */
    public void userSmartCredentialDeliver(com.good.adapters.entrust.stubs.UserSmartCredentialDeliverCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * List Smart Credentials that match the given search filter.
     * The
     *                 returned list of Smart Credentials will not be in
     * any particular
     *                 order.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userSmartCredentialList permission. Smart Credentials
     * matching
     *                 the filter are only returned if the user that owns
     * them is
     *                 accessible to the caller using the roles
     *                 with userSmartCredentialList permission and the access
     * rules
     *                 described for the userGet operation.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userSmartCredentialList permission.
     * 2. A fault with an OBJECT_NOT_EXIST error code, if any of the
     *                 groups, roles, or token vendor IDs specified in the
     * search
     *                 filter do not exist, or access to them is not granted
     * by
     *                 the user's roles with userSmartCredentialList permission.
     */
    public com.good.adapters.entrust.stubs.UserSmartCredentialListResult userSmartCredentialList(com.good.adapters.entrust.stubs.UserSmartCredentialListCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Access the policy information related to a Digital Id
     *                 create/recover operation. Policy information indicates
     * how many
     *                 certificate streams the Digital Id contains and details
     * like 
     *                 the key type configured for each certificate stream.
     * 
     *                 <p>
     *                 This API is intended to be called prior to 
     *                 userDigitalIdCreateRecover or 
     *                 userSmartCredentialDigitalIdCreateRecover; it allows
     * the caller 
     *                 to determine how the certificate requests that will
     * be provided 
     *                 to userDigitalIdCreateRecover or 
     *                 userSmartCredentialDigitalIdCreateRecover should be
     * generated. 
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must
     *                 have the userDigitalIdCreateRecover permission and
     * a group list
     *                 that grants access to the user's group.
     *                 Additionally, if the user is an administrator, one
     * of these
     *                 roles must also have a role list that grants access
     * to all of
     *                 the administrator's roles.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userDigitalIdCreateRecover
     * permission.
     */
    public com.good.adapters.entrust.stubs.UserDigitalIdCreateRecoverPolicyGetResult userDigitalIdCreateRecoverPolicyGet(com.good.adapters.entrust.stubs.UserDigitalIdCreateRecoverPolicyGetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Creates a new Digital Id or recovers an existing Digital Id
     * for the given user.  Information about the digital Id including
     *                 the reference number and auth. code needed to create
     * 
     *                 certificates associated with the digital Id are returned.
     * <p>
     *                 To call this operation, at least one of the caller's
     * roles must
     *                 have the userDigitalIdCreateRecover permission and
     * a group list
     *                 that grants access to the user's group.
     *                 Additionally, if the user is an administrator, one
     * of these
     *                 roles must also have a role list that grants access
     * to all of
     *                 the administrator's roles.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userDigitalIdCreateRecover
     * permission.
     *                 2. A fault with a USER_NOT_EXIST error code, if the
     * user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     */
    public com.good.adapters.entrust.stubs.UserDigitalIdCreateRecoverResult userDigitalIdCreateRecover(com.good.adapters.entrust.stubs.UserDigitalIdCreateRecoverCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Delete the specified Digital Id for the given user.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userDigitalIdDelete permission and a group list that
     * grants access to the
     *                 user's group. Additionally, if the user is an administrator,
     * one
     *                 of these roles must also have a role list that grants
     * access to
     *                 all of the administrator's roles.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userDigitalIdDelete permission.
     * 2. A fault with a USER_NOT_EXIST error code, if the user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     *                 4. A fault with a OBJECT_NOT_EXIST error code, if
     * the
     *                 specified Digital Id does not exist.
     */
    public void userDigitalIdDelete(com.good.adapters.entrust.stubs.UserDigitalIdDeleteCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Update the specified Digital Id for the given user.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userDigitalIdSet permission and a group list that
     * grants access to the
     *                 user's group. Additionally, if the user is an administrator,
     * one
     *                 of these roles must also have a role list that grants
     * access to
     *                 all of the administrator's roles.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userDigitalIdSet permission.
     * 2. A fault with a USER_NOT_EXIST error code, if the user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     *                 4. A fault with a OBJECT_NOT_EXIST error code, if
     * the
     *                 specified Digital Id does not exist.
     */
    public void userDigitalIdSet(com.good.adapters.entrust.stubs.UserDigitalIdSetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Return the specified Digital Id for the specified user.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userDigitalIdGet permission and a group list that
     * grants access to the
     *                 user's group 
     *                 Additionally, if the user is an administrator, one
     * of these roles must also have a role list that grants access to
     *                 all of the administrator's roles.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userDigitalIdGet permission.
     * 2. A fault with a USER_NOT_EXIST error code, if the user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a OBJECT_NOT_EXIST error code, if
     * the specified
     *                 Digital Id does not exist.
     *                 4. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     */
    public UserDigitalIdInfo userDigitalIdGet(com.good.adapters.entrust.stubs.UserDigitalIdGetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Cancel the specified Digital Id for the specified user.
     *                 The cancel operation results in all certificates associated
     * with the Digital Id being revoked.  The number of certificates
     *                 revoked is returned.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userDigitalIdCancel permission and a group list that
     * grants access to the
     *                 user's group 
     *                 Additionally, if the user is an administrator, one
     * of these roles must also have a role list that grants access to
     *                 all of the administrator's roles.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userDigitalIdCancel permission.
     * 2. A fault with a USER_NOT_EXIST error code, if the user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a OBJECT_NOT_EXIST error code, if
     * the specified
     *                 Digital Id does not exist.
     *                 4. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     */
    public int userDigitalIdCancel(com.good.adapters.entrust.stubs.UserDigitalIdCancelCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Hold the specified Digital Id for the specified user.
     *                 The hold operation results in all certificates associated
     * with the Digital Id being revoked with the CERTIFICATE_HOLD
     *                 revocation reason.  The number of certificates
     *                 revoked is returned.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userDigitalIdHold permission and a group list that
     * grants access to the
     *                 user's group 
     *                 Additionally, if the user is an administrator, one
     * of these roles must also have a role list that grants access to
     *                 all of the administrator's roles.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userDigitalIdHold permission.
     * 2. A fault with a USER_NOT_EXIST error code, if the user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a OBJECT_NOT_EXIST error code, if
     * the specified
     *                 Digital Id does not exist.
     *                 4. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     */
    public int userDigitalIdHold(com.good.adapters.entrust.stubs.UserDigitalIdHoldCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Unhold the specified Digital Id for the specified user.
     *                 The unhold operation results in all certificates associated
     * with the Digital Id that are currently revoked with the
     *                 CERTIFICATE_HOLD revocation reason being unrevoked.
     * The number
     *                 of certificates unrevoked is returned.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userDigitalIdUnhold permission and a group list that
     * grants access to the
     *                 user's group 
     *                 Additionally, if the user is an administrator, one
     * of these roles must also have a role list that grants access to
     *                 all of the administrator's roles.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userDigitalIdUnhold permission.
     * 2. A fault with a USER_NOT_EXIST error code, if the user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a OBJECT_NOT_EXIST error code, if
     * the specified
     *                 Digital Id does not exist.
     *                 4. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     */
    public int userDigitalIdUnhold(com.good.adapters.entrust.stubs.UserDigitalIdUnholdCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * List Digital Ids that match the given search filter. The
     *                 returned list of Digital Ids will not be in any particular
     * order.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userDigitalIdList permission. Digital Ids matching
     * the filter are only returned if the user that owns them is
     *                 accessible to the caller using the roles
     *                 with userDigitalIdList permission and the access rules
     * described for the userGet operation.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userDigitalIdList permission.
     * 2. A fault with an OBJECT_NOT_EXIST error code, if any of the
     *                 groups, roles, or token vendor IDs specified in the
     * search
     *                 filter do not exist, or access to them is not granted
     * by
     *                 the user's roles with userDigitalIdList permission.
     */
    public com.good.adapters.entrust.stubs.UserDigitalIdListResult userDigitalIdList(com.good.adapters.entrust.stubs.UserDigitalIdListCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Assign a certificate to the given user.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must
     *                 have the userCertificateAssign permission and a group
     * list that
     *                 grants access to the user's group. Additionally, if
     * the user is
     *                 an administrator, one of these roles must also have
     * a role list 
     *                 that grants access to all of the administrator's roles.
     * <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userCertificateAssign permission.
     * 2. A fault with a USER_NOT_EXIST error code, if the user does
     *                 not exist, or access to the user is not granted because
     * of
     *                 their group membership or roles.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     *                 4. A fault with a OBJECT_EXIST error code, if the
     * user already
     *                 has this certificate assigned to them.
     */
    public void userCertificateAssign(com.good.adapters.entrust.stubs.UserCertificateAssignCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Check to see if the specified certificate can be assigned
     *                 to the user.  Information about the certificate is
     * returned
     *                 to the application if the certificate can be assigned.
     * <p>
     *                 To call this operation, at least one of the caller's
     * roles must
     *                 have the userCertificateAssign permission and a group
     * list that
     *                 grants access to the user's group. Additionally, if
     * the user is
     *                 an administrator, one of these roles must also have
     * a role list 
     *                 that grants access to all of the administrator's roles.
     * <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userCertificateAssign permission.
     * 2. A fault with a USER_NOT_EXIST error code, if the user does
     *                 not exist, or access to the user is not granted because
     * of
     *                 their group membership or roles.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     *                 4. A fault with a OBJECT_EXIST error code, if the
     * user already
     *                 has this certificate assigned to them.
     */
    public com.good.adapters.entrust.stubs.UserCertificateAssignVerifyResult userCertificateAssignVerify(com.good.adapters.entrust.stubs.UserCertificateAssignVerifyCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Export the specified user certificate.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must
     *                 have the userCertificateGet permission and a group
     * list that
     *                 grants access to the user's group. Additionally, if
     * the user is
     *                 an administrator, one of these roles must also have
     * a role list 
     *                 that grants access to all of the administrator's roles.
     * <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userCertificateGet permission.
     * 2. A fault with a USER_NOT_EXIST error code, if the user does
     *                 not exist, or access to the user is not granted because
     * of
     *                 their group membership or roles.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     *                 4. A fault with a OBJECT_NOT_EXIST error code, if
     * the specified
     *                 user certificate does not exist for the user.
     */
    public com.good.adapters.entrust.stubs.UserCertificateExportResult userCertificateExport(com.good.adapters.entrust.stubs.UserCertificateExportCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Delete the certificates for the given user that match the
     *                 given filter, returning the number of certificates
     * deleted.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must
     *                 have the userCertificateDelete permission and a group
     * list that
     *                 grants access to the user's group. Additionally, if
     * the user is
     *                 an administrator, one of these roles must also have
     * a role list
     *                 that grants access to all of the administrator's roles.
     * <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userCertificateDelete permission.
     * 2. A fault with a USER_NOT_EXIST error code, if the user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     *                 4. A fault with a OBJECT_NOT_EXIST error code, if
     * none of the
     *                 user's certificates match the given filter.
     */
    public int userCertificateDelete(com.good.adapters.entrust.stubs.UserCertificateDeleteCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Return certificates for the given user that match the given
     * filter.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must
     *                 have the userCertificateGet permission and a group
     * list that
     *                 grants access to the user's group. Additionally, if
     * the user is
     *                 an administrator, one of these roles must also have
     * a role list
     *                 that grants access to all of the administrator's roles.
     * <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userCertificateGet permission.
     * 2. A fault with a USER_NOT_EXIST error code, if the user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     */
    public UserCertificateInfo[] userCertificateGet(com.good.adapters.entrust.stubs.UserCertificateGetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Update certificates for the given user that match the given
     * filter, returning the number of certificates that were updated.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must
     *                 have the userCertificateSet permission and a group
     * list that
     *                 grants access to the user's group. Additionally, if
     * the user is
     *                 an administrator, one of these roles must also have
     * a role list
     *                 that grants access to all of the administrator's roles.
     * <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userCertificateSet permission.
     * 2. A fault with a USER_NOT_EXIST error code, if the user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     */
    public int userCertificateSet(com.good.adapters.entrust.stubs.UserCertificateSetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Get a certificate challenge for the certificate specified by
     * the given filter. The challenge will be retained until
     *                 successfully answered.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles
     *                 must have the userTokenAuthenticate permission and
     * a group
     *                 list that grants access to the user's group. Additionally,
     * if
     *                 the user is an administrator, one of these roles must
     * also
     *                 have a role list that grants access to all of the
     *                 administrator's roles.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userCertificateAuthenticate
     * permission.
     *                 2. A fault with a USER_NOT_EXIST error code, if the
     * user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     *                 4. A fault with a OBJECT_NOT_EXIST error code, if
     * none of the
     *                 user's certificates match the filter.
     *                 5. A fault with an INVALID_ARGUMENT error code, if
     * more than
     *                 one certificate matches the filter.
     */
    public CertificateChallenge userCertificateChallenge(com.good.adapters.entrust.stubs.UserCertificateChallengeCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Authenticate the response against the certificate specified
     * by
     *                 the given filter.  An error is returned if the response
     * does
     *                 not authenticate.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must
     *                 have the userTokenAuthenticate permission and a group
     * list that
     *                 grants access to the user's group. Additionally, if
     * the user is
     *                 an administrator, one of these roles must also have
     * a role list
     *                 that grants access to all of the administrator's roles.
     * <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userCertificateAuthenticate
     * permission.
     *                 2. A fault with a USER_NOT_EXIST error code, if the
     * user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     *                 4. A fault with a OBJECT_NOT_EXIST error code, if
     * none of the
     *                 user's certificates match the filter.
     *                 5. A fault with an INVALID_ARGUMENT error code, if
     * more than
     *                 one certificate matches the filter.
     *                 6. A fault with an INVALID_RESPONSE error code, if
     * the response
     *                 is not correct.
     */
    public void userCertificateAuthenticate(com.good.adapters.entrust.stubs.UserCertificateAuthenticateCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * List certificates that match the given search filter. The
     *                 returned list of certificates will not be in any particular
     * order.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must
     *                 have the userCertificateList permission. Certificates
     * matching
     *                 the filter are only returned if the user that owns
     * them is
     *                 accessible to the caller using the roles with
     *                 userCertificateList permission and the access rules
     * described
     *                 for the userGet operation.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userCertificateList permission.
     * 2. A fault with an OBJECT_NOT_EXIST error code, if any of the
     *                 groups or roles specified in the search
     *                 filter do not exist, or access to them is not granted
     * by
     *                 the user's roles with userCertificateList permission.
     */
    public com.good.adapters.entrust.stubs.UserCertificateListResult userCertificateList(com.good.adapters.entrust.stubs.UserCertificateListCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Create one or more preproduced cards, whose serial numbers
     *                 starting with next available serial number, and return
     * information about the cards created.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the
     *                 cardCreate permission and a group list that grants
     * access
     *                 to the group that the cards are to be created in.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the cardCreate permission.
     *                 2. A fault with an OBJECT_NOT_EXIST error code, if
     * the group
     *                 to create the cards in to does not exist or is not
     * accessible to
     *                 the caller.
     */
    public com.good.adapters.entrust.stubs.PreproducedCardCreateResult preproducedCardCreate(com.good.adapters.entrust.stubs.PreproducedCardCreateCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Delete the preproduced card with the given serial number.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the
     *                 cardDelete permission and a group list that grants
     * access
     *                 to the group that the card being deleted belongs to.
     * <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the cardDelete permission.
     *                 2. A fault with an INVALID_ARGUMENT error code, if
     * the given
     *                 serial number is not a valid card serial number.
     *                 3. A fault with a CARD_NOT_EXIST error code, if the
     * given
     *                 card does not exist, or belongs to a group that the
     * caller does
     *                 not have access to.
     */
    public void preproducedCardDelete(com.good.adapters.entrust.stubs.PreproducedCardDeleteCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Return the preproduced card with the given serial number.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the
     *                 cardGet permission and a group list that grants access
     * to the group that the card being retrieved belongs to.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the cardGet permission.
     *                 2. A fault with an INVALID_ARGUMENT error code, if
     * the given
     *                 serial number is not a valid preproduced card serial
     * number.
     *                 3. A fault with a CARD_NOT_EXIST error code, if the
     * given
     *                 card does not exist, or belongs to a group that the
     * caller does
     *                 not have access to.
     */
    public PreproducedCardInfo preproducedCardGet(com.good.adapters.entrust.stubs.PreproducedCardGetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Update preproduced card with given serial number.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the
     *                 cardSet permission and a group list that grants access
     * to the group that the card being updated belongs to.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the cardSet permission, or the
     * group the
     *                 card is assigned to is being changed and the caller
     * does not
     *                 have a role granting access to the destination group.
     * 2. A fault with an INVALID_ARGUMENT error code, if the given
     *                 serial number is not a valid card serial number.
     *                 3. A fault with a CARD_NOT_EXIST error code, if the
     * given
     *                 card does not exist, or belongs to a group that the
     * caller does
     *                 not have access to.
     */
    public void preproducedCardSet(com.good.adapters.entrust.stubs.PreproducedCardSetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * List preproduced cards that match the given search filter.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the
     *                 cardList permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the cardList permission.
     *                 2. A fault with an OBJECT_NOT_EXIST error code, if
     * groups are
     *                 specified in the filter that either do not exist or
     * are not
     *                 accessible to the caller.
     */
    public com.good.adapters.entrust.stubs.PreproducedCardListResult preproducedCardList(com.good.adapters.entrust.stubs.PreproducedCardListCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Export preproduced cards that match the given search filter.
     * 
     * @return a summary of the cards exported
     */
    public CardExportResult preproducedCardExport(com.good.adapters.entrust.stubs.PreproducedCardExportCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Load the token data included in the given token data file,
     *                 returning the number of tokens loaded and the number
     * of tokens
     *                 that failed to load. The token data file must be loaded
     * as
     *                 either a list of strings or an array of binary data.
     * The format
     *                 required depends on the token vendor, and whether
     * the file is
     *                 binary or not can be obtained from the token vendor
     * information
     *                 returned from tokenVendorGet or tokenVendorList.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the
     *                 tokenLoad permission and a group list that grants
     * access
     *                 to the group that the tokens are to be loaded in to.
     * <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the tokenLoad permission.
     *                 2. A fault with an OBJECT_NOT_EXIST error code, if
     * the group
     *                 to load the tokens in to does not exist or is not
     * accessible to
     *                 the caller.
     *                 3. A fault with an INVALID_ARGUMENT error code, if
     * the token
     *                 data file or key are not specified, or if the data
     * file cannot
     *                 be loaded.
     */
    public TokenLoadResult tokenLoad(TokenLoadCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Delete the unassigned token with the given serial number.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the
     *                 tokenDelete permission and a group list that grants
     * access
     *                 to the group that the token being deleted belongs
     * to.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the tokenDelete permission.
     *                 2. A fault with an INVALID_ARGUMENT error code, if
     * the given
     *                 serial number is not a valid token serial number.
     *                 3. A fault with a TOKEN_NOT_EXIST error code, if the
     * given
     *                 token does not exist, or belongs to a group that the
     * caller does
     *                 not have access to.
     */
    public void tokenDelete(TokenDeleteCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Return the unassigned token with the given serial number.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the
     *                 tokenGet permission and a group list that grants access
     * to the group that the token being retrieved belongs to.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the tokenGet permission.
     *                 2. A fault with an INVALID_ARGUMENT error code, if
     * the given
     *                 serial number is not a valid token serial number.
     *                 3. A fault with a TOKEN_NOT_EXIST error code, if the
     * given
     *                 token does not exist, or belongs to a group that the
     * caller does
     *                 not have access to.
     */
    public TokenInfo tokenGet(TokenGetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Update the unassigned token with the given serial number.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the
     *                 tokenSet permission and a group list that grants access
     * to the group that the token being deleted belongs to.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the tokenSet permission, or the
     * group the
     *                 token is assigned to is being changed and the caller
     * does not
     *                 have a role granting access to the destination group.
     * 2. A fault with an INVALID_ARGUMENT error code, if the given
     *                 serial number is not a valid token serial number.
     *                 3. A fault with a TOKEN_NOT_EXIST error code, if the
     * given
     *                 token does not exist, or belongs to a group that the
     * caller does
     *                 not have access to.
     */
    public void tokenSet(TokenSetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * List unassigned tokens that match the given search filter.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the
     *                 tokenList permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the tokenList permission.
     *                 2. A fault with an OBJECT_NOT_EXIST error code, if
     * the token
     *                 vendor ID in the search filter does not exist, or
     * groups are
     *                 specified in the filter that either do not exist or
     * are not
     *                 accessible to the caller.
     */
    public TokenListResult tokenList(TokenListCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Load the smart credential data included in the given smart
     *                 credential data, returning the number of smart credentials
     * loaded and the number of smart credentials that failed
     *                 to load.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the
     *                 smartCredentialLoad permission and a group list that
     * grants
     *                 access to the group that the smart credentials are
     * loaded in.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the smartCredentialLoad permission.
     * 2. A fault with an OBJECT_NOT_EXIST error code, if the group
     *                 the smart credentials are loaded in does not exist
     * or is not
     *                 accessible to the caller.
     *                 3. A fault with an INVALID_ARGUMENT error code, if
     * the smart
     *                 credential data or key are not specified, or if the
     * data
     *                 cannot be loaded.
     */
    public com.good.adapters.entrust.stubs.SmartCredentialLoadResult smartCredentialLoad(com.good.adapters.entrust.stubs.SmartCredentialLoadCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Delete the unassigned smart credential with the given serial
     * number.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the
     *                 smartCredentialDelete permission and a group list
     * that grants
     *                 access to the group that the smart credential being
     * deleted
     *                 belongs.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the smartCredentialDelete permission.
     * 2. A fault with an INVALID_ARGUMENT error code, if the given
     *                 serial number is not a valid smart credential serial
     * number.
     *                 3. A fault with a OBJECT_NOT_EXIST error code, if
     * the given
     *                 smart credential does not exist or belongs to a group
     * that the
     *                 caller does not have access to.
     */
    public void smartCredentialDelete(com.good.adapters.entrust.stubs.SmartCredentialDeleteCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Return the unassigned smart credential with the given serial
     * number.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the
     *                 smartCredentialGet permission and a group list that
     * grants
     *                 access to the group that the smart credential being
     * retrieved
     *                 belongs to.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the smartCredentialGet permission.
     * 2. A fault with an INVALID_ARGUMENT error code, if the given
     *                 serial number is not a valid smart credential serial
     * number.
     *                 3. A fault with a OBJECT_NOT_EXIST error code, if
     * the given
     *                 smart credential does not exist, or belongs to a group
     * that the
     *                 caller does not have access to.
     */
    public SmartCredentialInfo smartCredentialGet(com.good.adapters.entrust.stubs.SmartCredentialGetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Return an authentication challenge for the unassigned smart
     * credential with the given serial number.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the
     *                 smartCredentialChallengeAuthenticate permission and
     * a group
     *                 list that grants access to the group that the smart
     * credential
     *                 being retrieved belongs to.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the smartCredentialChallengeAuthenticate
     * permission.
     *                 2. A fault with an INVALID_ARGUMENT error code, if
     * the given
     *                 serial number is not a valid smart credential serial
     * number.
     *                 3. A fault with a OBJECT_NOT_EXIST error code, if
     * the given
     *                 smart credential does not exist, or belongs to a group
     * that the
     *                 caller does not have access to.
     */
    public byte[] smartCredentialChallengeGet(com.good.adapters.entrust.stubs.SmartCredentialChallengeGetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Authenticate the challenge previously returned from
     *                 smartCredentialChallengeGet against the response provided
     * from
     *                 the smart credential for the unassigned smart
     *                 credential with the given serial number.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the
     *                 smartCredentialChallengeAuthenticate permission and
     * a group
     *                 list that grants access to the group that the smart
     * credential
     *                 being retrieved belongs to.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the smartCredentialChallengeAuthenticate
     * permission.
     *                 2. A fault with an INVALID_ARGUMENT error code, if
     * the given
     *                 serial number is not a valid smart credential serial
     * number.
     *                 3. A fault with a OBJECT_NOT_EXIST error code, if
     * the given
     *                 smart credential does not exist, or belongs to a group
     * that the
     *                 caller does not have access to.
     */
    public byte[] smartCredentialChallengeAuthenticate(com.good.adapters.entrust.stubs.SmartCredentialChallengeAuthenticateCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Update the unassigned smart credential with the given serial
     * number.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the
     *                 smartCredentialSet permission and a group list that
     * grants
     *                 access to the group that the smart credential being
     * deleted
     *                 belongs to.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the smartCredentialSet permission,
     * or the
     *                 group the smart credential is assigned to is being
     * changed and
     *                 the caller does not have a role granting access to
     * the
     *                 destination group.
     *                 2. A fault with an INVALID_ARGUMENT error code, if
     * the given
     *                 serial number is not a valid smart credential serial
     * number.
     *                 3. A fault with a OBJECT_NOT_EXIST error code, if
     * the given
     *                 smart credential does not exist, or belongs to a group
     * that the
     *                 caller does not have access to.
     */
    public void smartCredentialSet(com.good.adapters.entrust.stubs.SmartCredentialSetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * List unassigned smart credentials that match the given search
     * filter.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the
     *                 smartCredentialList permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the smartCredentialList permission.
     * 2. A fault with an OBJECT_NOT_EXIST error code, if groups are
     *                 specified in the filter that either do not exist or
     * are not
     *                 accessible to the caller.
     */
    public com.good.adapters.entrust.stubs.SmartCredentialListResult smartCredentialList(com.good.adapters.entrust.stubs.SmartCredentialListCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Retrieves a grid challenge for the given user ID. The challenge
     * must
     *                 be authenticated using the challengeAuthenticate call.
     * <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userAuthenticate permission and a group list that
     * grants access to the
     *                 user's group. Additionally, if the user is an administrator,
     * one
     *                 of these roles must also have a role list that grants
     * access to
     *                 all of the administrator's roles.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userAuthenticate permission.
     * 2. A fault with a USER_NOT_EXIST error code, if the user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     *                 4. A fault with a CARD_NOT_EXIST error code, if the
     * user
     *                 does not have any cards.
     */
    public Challenge[] challengeGet(ChallengeGetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Authenticates a response against a grid challenge that was
     * issued
     *                 by the challengeGet call for the given user ID. A
     * successful
     *                 authentication will not change the user card state.
     * <p>
     *                 To call this operation, at least one of the caller's
     * roles must have the
     *                 userAuthenticate permission and a group list that
     * grants access to the
     *                 user's group. Additionally, if the user is an administrator,
     * one
     *                 of these roles must also have a role list that grants
     * access to
     *                 all of the administrator's roles.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userAuthenticate permission.
     * 2. A fault with a USER_NOT_EXIST error code, if the user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     *                 4. A fault with a CARD_NOT_EXIST error code, if none
     * of the
     *                 user's cards match the filter.
     *                 5. A fault with a CHALLENGE_NOT_EXIST error code,
     * if
     *                 there is no retained grid challenge. This
     *                 will occur if no prior call was made to challengeGet.
     * 6. A fault with an INVALID_RESPONSE error code, if the response
     *                 to the challenge is not correct.
     *                 7. A fault with an INVALID_CARD_STATE error code,
     * if an
     *                 attempt is made to authenticate a card in the CANCELED
     * state.
     */
    public void challengeAuthenticate(com.good.adapters.entrust.stubs.ChallengeAuthenticateCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Add an entry to the IP blacklist.
     *                 <p>
     *                 Callers of this operation must have a role with the
     * ipListSet
     *                 permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the ipListSet permission.
     *                 2. A fault with an INVALID_ARGUMENT error code, if
     * the start
     *                 address is not specified, the start or the end address
     * are not
     *                 valid IP addresses, or the start address comes after
     * the end
     *                 address.
     */
    public void ipListAdd(IPListAddCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Delete an entry from the IP blacklist.
     *                 <p>
     *                 Callers of this operation must have a role with the
     * ipListDelete
     *                 permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the ipListDelete permission.
     *                 2. A fault with an INVALID_ARGUMENT error code, if
     * the start or
     *                 the end address are not valid IP addresses, or the
     * start address
     *                 comes after the end address.
     */
    public void ipListDelete(IPListDeleteCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Get the entry from the IP blacklist containing the given
     *                 IP address.
     *                 <p>
     *                 Callers of this operation must have a role with the
     * ipListGet
     *                 permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the ipListGet permission.
     *                 2. A fault with an INVALID_ARGUMENT error code, if
     * the given
     *                 address is not a valid IP address.
     *                 3. A fault with an OBJECT_NOT_EXIST error code, if
     * there is no
     *                 IP blacklist entry with the given IP address
     */
    public IPListEntry ipListGet(IPListGetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * List the entries from the IP blacklist matching the given
     *                 search filter.
     *                 <p>
     *                 Callers of this operation must have a role with the
     * ipListGet
     *                 permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the ipListGet permission.
     *                 2. A fault with an INVALID_ARGUMENT error code, if
     * the start or
     *                 end addresses in the filter are not valid IP addresses.
     */
    public IPListListResult ipListList(IPListListCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Return the audit with the given sequence numbers.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the
     *                 auditGet permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the auditGet permission.
     *                 2. A fault with a OBJECT_NOT_EXIST error code, if
     * the given
     *                 audit does not exist.
     */
    public AuditInfo auditGet(AuditGetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Return the audits that match the given filter.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the
     *                 auditList permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the auditList permission.
     */
    public AuditListResult auditList(AuditListCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Create an audit containing the included values.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the
     *                 auditCreate permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the auditCreate permission.
     *                 2. A fault with a INVALID_ARGUMENT error code, if
     * a
     *                 supplied value is too long.
     */
    public void auditCreate(AuditCreateCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Delete the audits that match the given sequence number or
     *                 range of sequence numbers.  The number of audits deleted
     * is
     *                 returned from this method.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the
     *                 auditDelete permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the auditDelete permission.
     *                 2. A fault with a INVALID_ARGUMENT error code, if
     * a
     *                 sequence number of range of sequence numbers where
     * not
     *                 specified in the arguments.
     */
    public long auditDelete(AuditDeleteCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Return the transaction certificate with the given name.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the
     *                 transactionCertificateGet permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the transactionCertificateGet
     * permission.
     *                 2. A fault with a OBJECT_NOT_EXIST error code, if
     * the given
     *                 transaction certificate does not exist.
     */
    public com.good.adapters.entrust.stubs.TransactionCertificateInfo transactionCertificateGet(com.good.adapters.entrust.stubs.TransactionCertificateGetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Return all the transaction certificates.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the
     *                 transactionCertificateList permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the transactionCertificateList
     * permission.
     */
    public com.good.adapters.entrust.stubs.TransactionCertificateListResult transactionCertificateList(NameValue[] parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Create the transaction certificate with the given name.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the
     *                 transactionCertificateCreate permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the transactionCertificateCreate
     * permission.
     *                 2. A fault with a OBJECT_EXIST error code, if a
     *                 transaction certificate already exists with the given
     * name or
     *                 a transaction certificate already exists in the specified
     * state
     *                 and the force option was not specified as true.
     *                 3. A fault with a INVALID_ARGUMENT error code, if
     * any
     *                 of the specified parameters have invalid values.
     */
    public void transactionCertificateCreate(com.good.adapters.entrust.stubs.TransactionCertificateCreateCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Delete the transaction certificate with the given name.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the
     *                 transactionCertificateDelete permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the transactionCertificateDelete
     * permission.
     *                 2. A fault with a OBJECT_NOT_EXIST error code, if
     * the
     *                 given transaction certificate does not exist.
     */
    public void transactionCertificateDelete(com.good.adapters.entrust.stubs.TransactionCertificateDeleteCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Modify the transaction certificate with the given name.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the
     *                 transactionCertificateSet permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the transactionCertificateSet
     * permission.
     *                 2. A fault with a OBJECT_NOT_EXIST error code, if
     * the
     *                 given transaction certificate does not exist.
     *                 3. A fault with a OBJECT_EXIST error code, if the
     *                 a transaction certificate with the given name exists
     * when
     *                 renaming a transaction certificate or if a transaction
     * certificate in the active state already exists when changing
     *                 the state of a transaction certificate to active.
     *                 4. A fault with a INVALID_ARGUMENT error code, if
     * any
     *                 of the specified parameters have invalid values.
     */
    public void transactionCertificateSet(com.good.adapters.entrust.stubs.TransactionCertificateSetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Export the transaction certificate with the given name.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the
     *                 transactionCertificateGet permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the transactionCertificateGet
     * permission.
     *                 2. A fault with a OBJECT_NOT_EXIST error code, if
     * the
     *                 given transaction certificate does not exist.
     *                 2. A fault with a INVALID_ARGUMENT error code, if
     * any
     *                 of the specified parameters have invalid values.
     */
    public com.good.adapters.entrust.stubs.TransactionCertificateExportResult transactionCertificateExport(com.good.adapters.entrust.stubs.TransactionCertificateExportCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Verify that the specified data can be imported against the
     *                 current pending transaction certificate.  Return information
     * about the import data to the caller so that they can verify
     *                 that the import data contains the expected information.
     * <p>
     *                 Callers of this operation must have a role that has
     * the
     *                 transactionCertificateCreate permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the transactionCertificateCreate
     * permission.
     *                 2. A fault with a OBJECT_NOT_EXIST error code, if
     * a
     *                 transaction certificate in the pending state does
     * not exist.
     *                 2. A fault with a INVALID_ARGUMENT error code, if
     * the
     *                 specified import data is not a valid certificate or
     * PKCS#7
     *                 certificate chain.
     */
    public com.good.adapters.entrust.stubs.TransactionCertificateImportVerifyResult transactionCertificateImportVerify(com.good.adapters.entrust.stubs.TransactionCertificateImportVerifyCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Import the specified data against the pending
     *                 transaction certificate making in the active transaction
     * certificate.  The specified import data must match the
     *                 pending transaction certificate and must be a valid
     * certificate or PKCS#7 certificate chain.  The operation
     *                 will fail if there is already an active transaction
     * certificate
     *                 unless the force parameter is specified as true in
     * which
     *                 case the existing active transaction certificate will
     * have its
     *                 state changed to inactive.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the
     *                 transactionCertificateCreate permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the transactionCertificateCreate
     * permission.
     *                 2. A fault with a OBJECT_NOT_EXIST error code, if
     * a
     *                 transaction certificate in the pending state does
     * not exist.
     *                 3. A fault with a OBJECT_EXIST error code, if a
     *                 transaction certificate in the active state already
     * exists and
     *                 the force parameter is not specified as true.
     *                 4. A fault with a INVALID_ARGUMENT error code, if
     * the
     *                 specified import data is not a valid certificate or
     * PKCS#7
     *                 certificate chain.
     */
    public void transactionCertificateImport(com.good.adapters.entrust.stubs.TransactionCertificateImportCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Return the CA certificate with the given name.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the
     *                 caCertificateGet permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the caCertificateGet permission.
     * 2. A fault with a OBJECT_NOT_EXIST error code, if the given
     *                 CA certificate does not exist.
     */
    public CACertificateInfo caCertificateGet(com.good.adapters.entrust.stubs.CACertificateGetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Return all the CA certificates.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the
     *                 caCertificateList permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the caCertificateList permission.
     */
    public com.good.adapters.entrust.stubs.CACertificateListResult caCertificateList(NameValue[] parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Load the CA certificate with the given name.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the
     *                 caCertificateLoad permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the caCertificateLoad permission.
     * 2. A fault with a OBJECT_EXIST error code, if a
     *                 CA certificate already exists with the given name
     * or
     *                 a CA certificate already exists with the given certificate
     * data.
     *                 3. A fault with a INVALID_ARGUMENT error code, if
     * any
     *                 of the specified parameters have invalid values.
     */
    public void caCertificateLoad(com.good.adapters.entrust.stubs.CACertificateLoadCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Delete the CA certificate with the given name.  A CA
     *                 certificate can not be deleted if it is the issuer
     * of any
     *                 existing user certificates or if it is specified in
     * the list
     *                 of allowed registered CAs for any policy.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the
     *                 caCertificateDelete permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the caCertificateDelete permission
     * or if the CA is the issuer of any existing user certificates.
     *                 2. A fault with a OBJECT_NOT_EXIST error code, if
     * the
     *                 given CA certificate does not exist.
     */
    public void caCertificateDelete(com.good.adapters.entrust.stubs.CACertificateDeleteCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Modify the CA certificate with the given name.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the
     *                 caCertificateSet permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the caCertificateSet permission.
     * 2. A fault with a OBJECT_NOT_EXIST error code, if the
     *                 given CA certificate does not exist.
     *                 3. A fault with a OBJECT_EXIST error code, if the
     *                 a CA certificate with the given name exists when
     *                 renaming a CA certificate.
     *                 4. A fault with a INVALID_ARGUMENT error code, if
     * any
     *                 of the specified parameters have invalid values.
     */
    public void caCertificateSet(com.good.adapters.entrust.stubs.CACertificateSetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Export the CA certificate with the given name.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the
     *                 caCertificateGet permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the caCertificateGet permission.
     * 2. A fault with a OBJECT_NOT_EXIST error code, if the
     *                 given CA certificate does not exist.
     *                 2. A fault with a INVALID_ARGUMENT error code, if
     * any
     *                 of the specified parameters have invalid values.
     */
    public com.good.adapters.entrust.stubs.CACertificateExportResult caCertificateExport(com.good.adapters.entrust.stubs.CACertificateExportCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Verify that the specified data can be loaded as a new
     *                 CA certificate.  Return information
     *                 about the specified CA certificate data to the caller
     * so that
     *                 they can verify that the certificate data contains
     * the
     *                 expected information.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the
     *                 caCertificateLoad permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the caCertificateLoad permission.
     * 2. A fault with a OBJECT_EXIST error code, if a
     *                 CA certificate matching the specified certificate
     * data already
     *                 exists.
     *                 3. A fault with a INVALID_ARGUMENT error code, if
     * the
     *                 specified certificate data is not a valid certificate
     * or PKCS#7
     *                 certificate chain.
     */
    public com.good.adapters.entrust.stubs.CACertificateLoadVerifyResult caCertificateLoadVerify(com.good.adapters.entrust.stubs.CACertificateLoadVerifyCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Returns information about the given report name that can be
     * 
     *                 generated.
     *                 <p>
     *                 Callers of this operation must have a role with the
     * appropriate reportCreate permission for the given report name.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the appropriate reportCreate permission.
     * 2. A fault with an OBJECT_NOT_EXIST error code, if the
     *                 report name is not defined.
     */
    public ReportDefinitionInfo reportDefinitionGet(com.good.adapters.entrust.stubs.ReportDefinitionGetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Returns a list information about the reports that can 
     *                 be generated.
     *                 <p>
     *                 Callers of this operation must have a role with one
     * of the
     *                 appropriate reportCreate permissions.
     *                 <p>
     *                 Any parameters passed to this call are ignored, but
     * null is not an acceptable value. A zero-length array is acceptable.
     * <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have one of the appropriate reportCreate
     * 
     *                 permissions or if there are no reports that can be
     * 
     *                 generated.
     */
    public com.good.adapters.entrust.stubs.ReportDefinitionListResult reportDefinitionList(NameValue[] parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Creates a new report with the given report parameters and filters.
     * The Id of the report to be generated is returned.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must have 
     *                 the appropriate reportCreate permission. The contents
     * of the 
     *                 generated report will be limited to the information
     * the caller has 
     *                 access to.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the appropriate reportCreate permission.
     * 2. A fault with an OBJECT_NOT_EXIST error code, if the report
     *                 name of the report to be created does not exist.
     *                 3. A fault with an INVALID_ARGUMENT error code, if
     * any of the 
     *                 given arguments are incorrect, e.g. if the data source
     * is not 
     *                 appropriate for the report name, or the input parameters
     * are
     *                 not valid.
     */
    public String reportCreate(ReportCreateCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Returns information about the given report Id that has been
     * generated.
     *                 <p>
     *                 Callers of this operation must have a role with the
     * appropriate reportGet permission for the given Id.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the appropriate reportGet permission.
     * 2. A fault with an OBJECT_NOT_EXIST error code, if the
     *                 report Id does not exist.
     */
    public ReportInfo reportGet(ReportGetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Return a list of reports that match the given filter
     *                 The list includes generated reports and the reports
     * 
     *                 waiting or currently being generated. The reports
     *                 waiting to be generated are those that were created
     * using the reportCreate API against the same
     *                 Administration Service. The reports are returned with
     * the most recent ones first.
     *                 <p>
     *                 Callers of this operation must have a role with one
     * of the
     *                 appropriate reportList permissions.
     *                 <p>
     *                 Any parameters passed to this call are ignored, but
     * null is not an acceptable value. A zero-length array is acceptable.
     * <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have one of the appropriate reportList
     * 
     *                 permissions.
     */
    public ReportListResult reportList(ReportListCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Deletes reports based on the supplied Id.
     *                 <p>
     *                 Callers of this operation must have a role with the
     * appropriate reportDelete permission for the given Id.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the appropriate reportDelete permission.
     * 2. A fault with an OBJECT_NOT_EXIST error code, if the  
     *                 report Id does not exist.
     */
    public void reportDelete(ReportDeleteCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Create a federation for the given user.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must
     *                 have the userFederationCreate permission and a group
     * list that
     *                 grants access to the user's group. Additionally, if
     * the user is
     *                 an administrator, one of these roles must also have
     * a role list 
     *                 that grants access to all of the administrator's roles.
     * <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userFederationCreate permission.
     * 2. A fault with a USER_NOT_EXIST error code, if the user does
     *                 not exist, or access to the user is not granted because
     * of
     *                 their group membership or roles.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     *                 4. A fault with a OBJECT_EXIST error code, if the
     * user already
     *                 has this federation type and partnerID created for
     * them.
     *                 5. A fault with a FEDERATION_EXIST error code, if
     * the federation
     *                 has already been created for some user.
     */
    public void userFederationCreate(com.good.adapters.entrust.stubs.UserFederationCreateCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Delete the federations for the given user that match the
     *                 given filter, returning the number of federations
     * deleted.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must
     *                 have the userFederationDelete permission and a group
     * list that
     *                 grants access to the user's group. Additionally, if
     * the user is
     *                 an administrator, one of these roles must also have
     * a role list
     *                 that grants access to all of the administrator's roles.
     * <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userFederationDelete permission.
     * 2. A fault with a USER_NOT_EXIST error code, if the user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     *                 4. A fault with a OBJECT_NOT_EXIST error code, if
     * none of the
     *                 user's federations match the given filter.
     */
    public int userFederationDelete(com.good.adapters.entrust.stubs.UserFederationDeleteCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Return federations for the given user that matches the given
     * filter. Either the userid is required or the 
     *                 originatorFederationName is required; but not both.
     * If
     *                 originatorFederationName is specified, then the given
     * filter
     *                 must include a single type and a partnerID. The other
     * filter 
     *                 items are irrelevant.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must
     *                 have the userFederationGet permission and a group
     * list that
     *                 grants access to the user's group. Additionally, if
     * the user is
     *                 an administrator, one of these roles must also have
     * a role list
     *                 that grants access to all of the administrator's roles.
     * <p>
     *                 To obtain the federation names as part of the response,
     * the
     *                 caller's roles must have the userFederationView permission.
     * <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userFederationGet permission.
     * 2. A fault with a USER_NOT_EXIST error code, if the user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     */
    public UserFederationInfo[] userFederationGet(com.good.adapters.entrust.stubs.UserFederationGetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Update a federation for the given user that matches the given
     * filter. The given filter must include a single type and 
     *                 a partnerID. The other filter items are irrelevant.
     * <p>
     *                 To call this operation, at least one of the caller's
     * roles must
     *                 have the userFederationSet permission and a group
     * list that
     *                 grants access to the user's group. Additionally, if
     * the user is
     *                 an administrator, one of these roles must also have
     * a role list
     *                 that grants access to all of the administrator's roles.
     * <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userFederationSet permission.
     * 2. A fault with a USER_NOT_EXIST error code, if the user does
     *                 not exist, or access to the user is not granted because
     * of their
     *                 group membership or roles.
     *                 3. A fault with a USERNAME_NOT_UNIQUE error code,
     * if the user's
     *                 group is not specified in their user ID and multiple
     * users with
     *                 this user ID or alias exist in different groups.
     *                 4. A fault with a OBJECT_NOT_EXIST error code, if
     * the specified
     *                 user federation does not exist for the user.
     *                 5. A fault with a FEDERATION_EXIST error code, if
     * the federation
     *                 has already been created for some user.
     */
    public void userFederationSet(com.good.adapters.entrust.stubs.UserFederationSetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * List federations that match the given search filter. The
     *                 returned list of federations will not be in any particular
     * order.
     *                 <p>
     *                 To call this operation, at least one of the caller's
     * roles must
     *                 have the userFederationList permission. Federations
     * matching
     *                 the filter are only returned if the user that owns
     * them is
     *                 accessible to the caller using the roles with
     *                 userFederationList permission and the access rules
     * described
     *                 for the userGet operation.
     *                 <p>
     *                 To obtain the federation names as part of the response,
     * the
     *                 caller's roles must have the userFederationView permission.
     * <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the userFederationList permission.
     * 2. A fault with an OBJECT_NOT_EXIST error code, if any of the
     *                 groups or roles specified in the search
     *                 filter do not exist, or access to them is not granted
     * by
     *                 the user's roles with userFederationList permission.
     */
    public com.good.adapters.entrust.stubs.UserFederationListResult userFederationList(com.good.adapters.entrust.stubs.UserFederationListCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Create a new managed CA. All managed CA information parameters
     * are mandatory.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the 
     *                 managedCaCreate permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the managedCaCreate permission.
     * 2. A fault with an OBJECT_EXIST error code, if a managed CA
     *                 with the given name already exists.
     *                 3. A fault with an INVALID_ARGUMENT error code, if
     * any of
     *                 the managed CA information parameters are not valid.
     */
    public void managedCaCreate(com.good.adapters.entrust.stubs.ManagedCaCreateCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Delete the named managed CA. Managed CAs may only be deleted
     * 
     *                 when they are no longer any IDG users with certificate-based
     * 
     *                 authenticators issued by the managed CA.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the 
     *                 managedCaDelete permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the 
     *                 caller's roles have the managedCaDelete permission,
     * or there are
     *                 still IDG users with certificate-based authenticators
     * issued by
     *                 this managed CA.
     *                 2. A fault with an OBJECT_NOT_EXIST error code, if
     * the managed
     *                 CA does not exist.
     */
    public void managedCaDelete(com.good.adapters.entrust.stubs.ManagedCaDeleteCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Return the named managed CA.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the
     *                 managedCaGet permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the managedCaGet permission.
     *                 2. A fault with a OBJECT_NOT_EXIST error code, if
     * the managed
     *                 CA does not exist.
     */
    public ManagedCaInfo managedCaGet(ManagedCaGetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Modify the named managed CA. All managed CA information 
     *                 parameters are optional.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the 
     *                 managedCaSet permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have managedCaSet permission.
     *                 2. A fault with an OBJECT_NOT_EXIST error code, if
     * the managed
     *                 CA does not exist.
     *                 3. A fault with an OBJECT_EXIST error code, if the
     * managed CA
     *                 is being renamed but a managed CA with the new name
     * already
     *                 exists.
     *                 4. A fault with an INVALID_ARGUMENT error code, if
     * any of the 
     *                 managed CA information parameters are not valid.
     */
    public void managedCaSet(ManagedCaSetCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Return a list of the managed CAs.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the 
     *                 managedCaList permission.
     *                 <p>
     *                 Any parameters passed to this call are ignored, but
     * null is not 
     *                 an acceptable value. A zero-length array is acceptable.
     * <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have managedCaList permission.
     */
    public ManagedCaInfoList managedCaList(NameValue[] parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Signs the provided data using the PIV content signer configured
     * for the identified managed CA.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the 
     *                 pivSignContent permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have pivSignContent permission.
     *                 2. A fault with an OBJECT_NOT_EXIST error code, if
     * the managed
     *                 CA does not exist or does not have a PIV content signer
     * 
     *                 configured.
     *                 3. A fault with an INVALID_ARGUMENT error code, if
     * any of the 
     *                 parameters passed to the operation are invalid.
     */
    public PivSignContentResult managedCaPivSignContent(com.good.adapters.entrust.stubs.PivSignContentCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Indicates whether or not Microsoft CA support is available.
     * <p>
     *                 This call is not restricted by role permissions.
     *                 <p>
     *                 Any parameters passed to this call are ignored, but
     * null is not 
     *                 an acceptable value. A zero-length array is acceptable.
     */
    public boolean isMicrosoftCaSupportAvailable(NameValue[] parms) throws java.rmi.RemoteException, AdminServiceFault;

    /**
     * Checks whether or not a certificate issued by a manage CA has
     * been revoked.
     *                 <p>
     *                 Callers of this operation must have a role that has
     * the
     *                 managedCaIsCertRevoked permission.
     *                 <p>
     *                 The most likely faults from this call are:
     *                 1. A fault with a NOT_PERMITTED error code, if none
     * of the
     *                 caller's roles have the managedCaGet permission.
     *                 2. A fault with a OBJECT_NOT_EXIST error code, if
     * the managed
     *                 CA does not exist.
     */
    public com.good.adapters.entrust.stubs.ManagedCaIsCertRevokedResult managedCaIsCertRevoked(com.good.adapters.entrust.stubs.ManagedCaIsCertRevokedCallParms parms) throws java.rmi.RemoteException, AdminServiceFault;
}
